/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.gui;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.labymod.core.LabyModCore;
import net.labymod.core.ServerPingerData;
import net.labymod.gui.ModGuiMultiplayer;
import net.labymod.gui.elements.CheckBox;
import net.labymod.gui.elements.MultiplayerTabs;
import net.labymod.gui.elements.Scrollbar;
import net.labymod.gui.elements.Tabs;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.main.Source;
import net.labymod.main.lang.LanguageManager;
import net.labymod.utils.Consumer;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;
import net.labymod.utils.ServerData;
import net.labymod.utils.manager.ServerInfoRenderer;
import net.labymod.utils.manager.TooltipHelper;
import net.labymod.utils.request.DownloadServerRequest;
import net.labymod.utils.request.RequestException;
import net.labymod.utils.request.ServerResponse;

public class GuiServerList
extends axu {
    private static Map<String, ServerInfoRenderer> serverInfoRenderers = new HashMap<String, ServerInfoRenderer>();
    private static List<ServerInfoRenderer> serverInfoRenderersSorted = new ArrayList<ServerInfoRenderer>();
    private static List<ServerData> publicServerListEntrys = new ArrayList<ServerData>();
    private static boolean initialized;
    private static boolean partnersOnly;
    private axu parentScreen;
    private Scrollbar scrollbar;
    private long lastServerDataUpdate;
    private ServerPingerData joinOnServerData;
    private ServerPingerData saveServerData;
    private ServerPingerData hoverServerData;
    private ServerPingerData selectedServerData;
    private int selectedServerId;
    private long lastTimeSelected;
    private avs buttonConnect;
    private avs buttonSaveServer;
    private CheckBox checkBox;
    private int alternativeDragClickY = -1;

    public GuiServerList(axu parentScreen) {
        this.parentScreen = parentScreen;
        if (initialized) {
            return;
        }
        initialized = true;
        DownloadServerRequest.getJsonObjectAsync("https://dl.labymod.net/public_servers.json", new ServerResponse<JsonElement>(){

            @Override
            public void success(JsonElement result) {
                JsonObject servers = result.getAsJsonObject().get("servers").getAsJsonObject();
                int index = 0;
                Set entrySet = servers.entrySet();
                for (Map.Entry entry : entrySet) {
                    String address = (String)entry.getKey();
                    JsonObject data = ((JsonElement)entry.getValue()).getAsJsonObject();
                    boolean partner = data.has("partner") && data.get("partner").getAsBoolean();
                    ServerData serverData = new ServerData(address, 25565, partner);
                    serverData.setIndex(index);
                    publicServerListEntrys.add(serverData);
                    ++index;
                }
                GuiServerList.this.refreshServerList();
                GuiServerList.this.sortServerList();
            }

            @Override
            public void failed(RequestException exception) {
                exception.printStackTrace();
            }
        });
    }

    public void b() {
        MultiplayerTabs.initMultiplayerTabs(1);
        Tabs.initGui(this);
        this.scrollbar = new Scrollbar(36);
        this.scrollbar.setPosition(this.l / 2 + 150 + 4, 41, this.l / 2 + 150 + 4 + 6, this.m - 40);
        this.scrollbar.setSpeed(20);
        this.scrollbar.setSpaceBelow(5);
        this.refreshServerList();
        this.sortServerList();
        this.lastServerDataUpdate = System.currentTimeMillis() + 5000L;
        this.buttonSaveServer = new avs(6, this.l / 2 - 50 - 5 - 100, this.m - 30, 100, 20, LanguageManager.translate("button_save_server"));
        this.n.add(this.buttonSaveServer);
        this.buttonConnect = new avs(5, this.l / 2 - 50, this.m - 30, 100, 20, LanguageManager.translate("button_connect"));
        this.n.add(this.buttonConnect);
        avs cancelButton = new avs(4, this.l / 2 + 50 + 5, this.m - 30, 100, 20, LanguageManager.translate("button_cancel"));
        if (LabyMod.getInstance().isInGame()) {
            cancelButton.l = false;
        }
        this.n.add(cancelButton);
        this.checkBox = new CheckBox("", partnersOnly ? CheckBox.EnumCheckBoxValue.ENABLED : CheckBox.EnumCheckBoxValue.DISABLED, null, this.l / 2 - 180, this.m - 28, 19, 19);
        super.b();
    }

    private void refreshServerList() {
        boolean firstInit = serverInfoRenderers.isEmpty();
        for (final ServerData entry : publicServerListEntrys) {
            if (firstInit) {
                ServerPingerData dummyPingerData = new ServerPingerData(entry.getIp(), 0L);
                dummyPingerData.setPingToServer(-1L);
                dummyPingerData.setMotd(LanguageManager.translate("status_pinging_server"));
                dummyPingerData.setPinging(true);
                dummyPingerData.setVersion(Source.ABOUT_MC_PROTOCOL_VERSION);
                ServerInfoRenderer serverInfoRenderer = new ServerInfoRenderer(entry.getIp(), entry.getIp(), dummyPingerData).setIndex(entry.getIndex());
                serverInfoRenderer.setLabymodServerData(entry);
                serverInfoRenderers.put(entry.getIp(), serverInfoRenderer);
            }
            final long pingStartTime = System.currentTimeMillis();
            LabyModCore.getServerPinger().pingServer(null, pingStartTime, entry.getIp() + ":" + entry.getPort(), new Consumer<ServerPingerData>(){

                @Override
                public void accept(ServerPingerData accepted) {
                    if (accepted != null && accepted.getTimePinged() != pingStartTime) {
                        return;
                    }
                    ServerInfoRenderer preInfo = (ServerInfoRenderer)serverInfoRenderers.get(entry.getIp());
                    if (preInfo != null) {
                        if (accepted == null) {
                            if (!preInfo.canReachServer()) {
                                preInfo.setHidden(true);
                            }
                        } else {
                            preInfo.init(entry.getIp(), entry.getIp(), accepted);
                            preInfo.setHidden(false);
                        }
                    }
                }
            });
        }
        if (firstInit) {
            this.sortServerList();
        }
    }

    private void sortServerList() {
        ArrayList<ServerInfoRenderer> list = new ArrayList<ServerInfoRenderer>();
        int count = 0;
        String versionSplit = Source.ABOUT_MC_VERSION.replaceFirst("\\.", "/");
        String majorVersion = (versionSplit.contains(".") ? versionSplit.split("\\.")[0] : versionSplit).replaceAll("/", ".");
        for (ServerInfoRenderer serverInfoRenderer : serverInfoRenderers.values()) {
            boolean partner;
            if ((serverInfoRenderer.isClientOutOfDate() || serverInfoRenderer.isServerOutOfDate()) && !serverInfoRenderer.getServerData().getMotd().contains(majorVersion) && !serverInfoRenderer.getServerData().getGameVersion().contains(majorVersion) || serverInfoRenderer.getServerData() != null && serverInfoRenderer.canReachServer() && !serverInfoRenderer.getServerData().isPinging() && serverInfoRenderer.getServerData().getCurrentPlayers() < 30 || serverInfoRenderer.isHidden()) continue;
            boolean bl = partner = serverInfoRenderer.getLabymodServerData() != null && serverInfoRenderer.getLabymodServerData().isPartner();
            if (!partner && partnersOnly) continue;
            list.add(serverInfoRenderer);
            if (++count < 50) continue;
            break;
        }
        Collections.sort(list, new Comparator<ServerInfoRenderer>(){

            @Override
            public int compare(ServerInfoRenderer a2, ServerInfoRenderer b2) {
                return a2.getIndex() - b2.getIndex();
            }
        });
        serverInfoRenderersSorted = list;
        this.scrollbar.update(serverInfoRenderersSorted.size());
    }

    public void e() {
        if (LabyMod.getSettings().serverlistLiveView && this.lastServerDataUpdate < System.currentTimeMillis()) {
            this.lastServerDataUpdate = System.currentTimeMillis() + 15000L;
            this.sortServerList();
            this.refreshServerList();
        }
        super.e();
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        draw.drawAutoDimmedBackground(this.scrollbar.getScrollY());
        this.joinOnServerData = null;
        this.saveServerData = null;
        this.hoverServerData = null;
        this.selectedServerId = -1;
        int id = 1;
        int midX = this.l / 2;
        int entryWidth = 300;
        int entryHeight = 36;
        double posY = 45.0 + this.scrollbar.getScrollY();
        for (ServerInfoRenderer serverInfoRenderer : serverInfoRenderersSorted) {
            boolean partner;
            boolean bl = partner = serverInfoRenderer.getLabymodServerData() != null && serverInfoRenderer.getLabymodServerData().isPartner();
            if (this.selectedServerData != null && this.selectedServerData.getIpAddress().equals(serverInfoRenderer.getServerData().getIpAddress())) {
                draw.drawRect(midX - entryWidth / 2 - 2, posY - 2.0, midX + entryWidth / 2 + 2, posY + (double)entryHeight - 2.0, ModColor.toRGB(partner ? 155 : 128, partner ? 155 : 128, partner ? 0 : 128, 255));
                draw.drawRect(midX - entryWidth / 2 - 1, posY - 1.0, midX + entryWidth / 2 + 1, posY + (double)entryHeight - 3.0, ModColor.toRGB(0, 0, 0, 255));
                this.selectedServerId = id;
            } else if (partner) {
                int color = ModColor.toRGB(100, 80, 0, 30);
                int x = midX - entryWidth / 2 - 1;
                int y = (int)posY - 1;
                int x2 = midX + entryWidth / 2 + 2;
                int y2 = (int)posY + entryHeight - 3;
                DrawUtils.a((int)(x + 1), (int)(y + 1), (int)(x2 - 1), (int)(y2 - 1), (int)color);
                DrawUtils.a((int)x, (int)(y + 2), (int)(x + 1), (int)(y2 - 2), (int)color);
                DrawUtils.a((int)(x2 - 1), (int)(y + 2), (int)x2, (int)(y2 - 2), (int)color);
                DrawUtils.a((int)(x + 2), (int)y, (int)(x2 - 2), (int)(y + 1), (int)color);
                DrawUtils.a((int)(x + 2), (int)(y2 - 1), (int)(x2 - 2), (int)y2, (int)color);
            }
            serverInfoRenderer.drawEntry(midX - entryWidth / 2, (int)posY, entryWidth + 5, mouseX, mouseY);
            if (mouseY > 41 && mouseY < this.m - 40) {
                if (serverInfoRenderer.drawJoinServerButton(midX - entryWidth / 2, (int)posY, entryWidth + 5, entryHeight, mouseX, mouseY)) {
                    this.joinOnServerData = serverInfoRenderer.getServerData();
                }
                if (serverInfoRenderer.drawSaveServerButton(midX - entryWidth / 2, (int)posY, entryWidth + 5, entryHeight, mouseX, mouseY)) {
                    this.saveServerData = serverInfoRenderer.getServerData();
                    TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, 300L, LanguageManager.translate("button_save_in_my_server_list"));
                }
                if (mouseX > midX - entryWidth / 2 && mouseX < midX + entryWidth / 2 + 5 && (double)mouseY > posY && (double)mouseY < posY + (double)entryHeight) {
                    this.hoverServerData = serverInfoRenderer.getServerData();
                }
            }
            String number = "#" + id;
            if (partner) {
                double x = midX - entryWidth / 2 - draw.getStringWidth(number) - 12;
                boolean hover = (double)mouseX > x && (double)mouseX < x + 10.0 && (double)mouseY > posY && (double)mouseY < posY + 10.0;
                draw.bindTexture(ModTextures.MISC_PARTNER_CROWN);
                draw.drawTexture(x - (double)(hover ? 2 : 0), posY - (double)(hover ? 2 : 0), 255.0, 255.0, 10 + (hover ? 4 : 0), 10 + (hover ? 4 : 0), 1.1f);
                if (hover) {
                    TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, 0L, ModColor.cl('e') + LanguageManager.translate("partner_server_list"));
                }
                number = ModColor.cl('e') + number;
            }
            draw.drawRightString(number, midX - entryWidth / 2 - 3, posY + 2.0, 0.7);
            posY += (double)entryHeight;
            ++id;
        }
        this.buttonConnect.l = this.selectedServerData != null;
        this.buttonSaveServer.l = this.selectedServerData != null;
        draw.drawOverlayBackground(0, 41);
        draw.drawGradientShadowTop(41.0, 0.0, this.l);
        draw.drawOverlayBackground(this.m - 40, this.m);
        draw.drawGradientShadowBottom(this.m - 40, 0.0, this.l);
        if (serverInfoRenderersSorted.isEmpty()) {
            draw.drawCenteredString(LanguageManager.translate("status_loading_server_list"), this.l / 2, this.m / 2);
        }
        int qiX = this.l - 12;
        int qiY = 44;
        int qiW = 8;
        int qiH = 12;
        boolean hover = mouseX > qiX && mouseY > qiY && mouseX < qiX + qiW && mouseY < qiY + qiH;
        ave.A().P().a(ModTextures.BUTTON_QUESTION);
        draw.drawTexture(qiX, 44.0, hover ? 135.0 : 0.0, 0.0, 122.0, 255.0, qiW, qiH);
        if (hover) {
            String string = ModColor.cl("9") + ModColor.cl("n") + LanguageManager.translate("information") + "\n" + ModColor.cl("f") + LanguageManager.translate("info_public_server_list");
            TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, 0L, (String[])draw.listFormattedStringToWidth(string, this.l / 4).toArray());
        }
        this.scrollbar.draw();
        super.a(mouseX, mouseY, partialTicks);
        boolean isScrolled = !LabyMod.getInstance().isInGame() && this.scrollbar.getScrollY() == 0.0;
        boolean isIndex0Selected = !LabyMod.getInstance().isInGame() && this.selectedServerId == 1;
        MultiplayerTabs.drawMultiplayerTabs(1, mouseX, mouseY, isScrolled, isIndex0Selected);
        MultiplayerTabs.drawParty(mouseX, mouseY, this.l);
        Tabs.drawScreen(this, mouseX, mouseY);
        draw.bindTexture(ModTextures.MISC_PARTNER_CROWN);
        draw.drawTexture(this.l / 2 - 176, this.m - 36, 255.0, 255.0, 10.0, 10.0, 1.1f);
        this.checkBox.drawCheckbox(mouseX, mouseY);
    }

    protected void a(int mouseX, int mouseY, int mouseButton) throws IOException {
        MultiplayerTabs.mouseClickedMultiplayerTabs(1, mouseX, mouseY);
        if (Tabs.mouseClicked(this)) {
            return;
        }
        if (this.hoverServerData != null) {
            if (this.selectedServerData != null && this.selectedServerData.getIpAddress().equals(this.hoverServerData.getIpAddress()) && this.lastTimeSelected + 400L > System.currentTimeMillis()) {
                this.joinOnServerData = this.selectedServerData;
            }
            this.selectedServerData = this.hoverServerData;
            this.lastTimeSelected = System.currentTimeMillis();
            this.alternativeDragClickY = (int)(this.scrollbar.getScrollY() - (double)mouseY);
        }
        if (this.joinOnServerData != null) {
            this.joinServer();
        }
        if (this.saveServerData != null) {
            this.saveServer(this.selectedServerData);
        }
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.CLICKED);
        if (this.checkBox != null && this.checkBox.mouseClicked(mouseX, mouseY, mouseButton)) {
            partnersOnly = this.checkBox.getValue() == CheckBox.EnumCheckBoxValue.ENABLED;
            this.sortServerList();
        }
        super.a(mouseX, mouseY, mouseButton);
    }

    private void joinServer() {
        final ServerPingerData serverPingerData = this.selectedServerData;
        if (serverPingerData != null) {
            if (LabyMod.getInstance().isInGame() && !ave.A().F() && LabyMod.getSettings().confirmDisconnect) {
                final axu lastScreen = ave.A().m;
                ave.A().a((axu)new awy(new awx(){

                    public void a(boolean result, int id) {
                        if (result) {
                            LabyMod.getInstance().getLabyConnect().setViaServerList(true);
                            LabyMod.getInstance().connectToServer(serverPingerData.getIpAddress());
                        } else {
                            ave.A().a(lastScreen);
                        }
                    }
                }, LanguageManager.translate("warning_server_disconnect"), ModColor.cl("c") + serverPingerData.getIpAddress(), 0));
            } else {
                LabyMod.getInstance().getLabyConnect().setViaServerList(true);
                LabyMod.getInstance().connectToServer(serverPingerData.getIpAddress());
            }
        }
    }

    protected void a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.DRAGGING);
        if (this.alternativeDragClickY != -1) {
            this.scrollbar.setScrollY(this.alternativeDragClickY + mouseY);
            this.scrollbar.checkOutOfBorders();
        }
        super.a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    protected void b(int mouseX, int mouseY, int state) {
        super.b(mouseX, mouseY, state);
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.RELEASED);
        this.alternativeDragClickY = -1;
    }

    protected void a(avs button) throws IOException {
        super.a(button);
        if (button.k == 4) {
            if (this.parentScreen instanceof ModGuiMultiplayer) {
                ave.A().a(((ModGuiMultiplayer)this.parentScreen).getParentScreen());
            } else {
                ave.A().a(this.parentScreen);
            }
        }
        if (button.k == 6) {
            this.saveServer(this.selectedServerData);
        }
        if (button.k == 5 && this.selectedServerData != null) {
            this.joinServer();
        }
    }

    private void saveServer(ServerPingerData selectedServerData) {
        if (this.parentScreen instanceof ModGuiMultiplayer) {
            ModGuiMultiplayer gmp = (ModGuiMultiplayer)this.parentScreen;
            gmp.h().a(selectedServerData.toMCServerData());
            gmp.h().b();
            LabyModCore.getMinecraft().updateServerList(gmp.getServerSelector(), gmp.h());
            gmp.getServerSelector().h(Integer.MAX_VALUE);
            gmp.getServerSelector().c(gmp.h().c() - 1);
            ave.A().a(this.parentScreen);
        } else {
            bdf serverList = new bdf(ave.A());
            serverList.a();
            serverList.a(selectedServerData.toMCServerData());
            serverList.b();
        }
    }

    public void k() throws IOException {
        this.scrollbar.mouseInput();
        super.k();
    }

    public axu getParentScreen() {
        return this.parentScreen;
    }
}

