/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.gui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import net.labymod.core.LabyModCore;
import net.labymod.gui.elements.DropDownMenu;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.main.lang.LanguageManager;
import net.labymod.user.cosmetic.geometry.BlockBenchLoader;
import net.labymod.user.cosmetic.geometry.GeometryLoader;
import net.labymod.utils.Consumer;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;

public class GuiLabyNet
extends axu {
    private final List<LabyNetSetting> settings = new ArrayList<LabyNetSetting>();
    private final Consumer<JsonObject> callback;
    private final axu previousScreen;
    private avs doneButton;
    private avs openButton;
    private BlockBenchLoader blockBenchLoader;

    public GuiLabyNet(JsonObject options, Consumer<JsonObject> callback) {
        this.previousScreen = ave.A().m;
        this.callback = callback;
        try {
            for (Map.Entry entry : options.entrySet()) {
                JsonArray values = ((JsonElement)entry.getValue()).getAsJsonObject().get("values").getAsJsonArray();
                String selected = ((JsonElement)entry.getValue()).getAsJsonObject().get("selected").getAsString();
                this.settings.add(new LabyNetSetting((String)entry.getKey(), values, selected));
            }
            InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("assets/minecraft/labymod/models/alex.geo.json");
            String json = "";
            Scanner scanner = new Scanner(input);
            while (scanner.hasNextLine()) {
                json = json + scanner.nextLine();
            }
            scanner.close();
            this.blockBenchLoader = new GeometryLoader(json).toBlockBenchLoader(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void b() {
        super.b();
        this.doneButton = new avs(0, 10, 0, 100, 20, LanguageManager.translate("button_save"));
        this.n.add(this.doneButton);
        this.openButton = new avs(1, this.l - 105, 5, 100, 20, LanguageManager.translate("labynet_button_open_profile"));
        this.n.add(this.openButton);
    }

    protected void a(avs button) throws IOException {
        super.a(button);
        if (button.k == 0) {
            JsonObject response = new JsonObject();
            for (LabyNetSetting setting : this.settings) {
                response.addProperty(setting.getId(), ((SettingOption)setting.menu.getSelected()).value);
            }
            this.callback.accept(response);
            ave.A().a(this.previousScreen);
        }
        if (button.k == 1) {
            LabyMod.getInstance().openWebpage("https://laby.net/@" + LabyMod.getInstance().getPlayerName(), false);
        }
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        DrawUtils drawUtils = LabyMod.getInstance().getDrawUtils();
        drawUtils.drawBackground(32);
        int menuLeft = this.l / 2 - 80;
        int menuTop = 50;
        int menuBottom = menuTop + 150;
        drawUtils.drawOverlayBackground(0, 30, this.l, menuBottom, 32);
        avp.a((int)0, (int)0, (int)this.l, (int)30, (int)ModColor.toRGB(30, 30, 30, 255));
        bfl.l();
        ave.A().P().a(ModTextures.TITLE_LABYMOD_WHITE_WOLF);
        drawUtils.drawTexture(10.0, 5.0, 0.0, 0.0, 256.0, 256.0, 20.0, 20.0, 1.0f);
        drawUtils.drawString(ModColor.cl('e') + LanguageManager.translate("labynet_title", ModColor.cl('f') + ModColor.cl('f') + "LABY.net"), 40.0, 12.0, 1.0);
        drawUtils.drawString(ModColor.cl('f') + LabyMod.getInstance().getPlayerName(), menuLeft, menuTop, 3.0);
        drawUtils.drawString(ModColor.cl('7') + LabyMod.getInstance().getPlayerUUID(), menuLeft, menuTop + 30, 1.0);
        int settingX = menuLeft;
        int settingY = menuTop + 70;
        int elementWidth = Math.min(140, this.l / 3);
        for (LabyNetSetting setting : this.settings) {
            setting.menu.setX(settingX);
            setting.menu.setY(settingY);
            setting.menu.setWidth(elementWidth);
            setting.menu.setHeight(20);
            if ((settingX += setting.menu.getWidth() + 10) <= this.l - setting.menu.getWidth()) continue;
            settingY += 50;
            settingX = menuLeft;
        }
        LabyModCore.getMinecraft().setButtonXPosition(this.doneButton, settingX + elementWidth * 2 - this.doneButton.b() + 10);
        LabyModCore.getMinecraft().setButtonYPosition(this.doneButton, menuBottom + 5);
        if (this.blockBenchLoader != null) {
            try {
                float rotation = 40.0f;
                float scale = 6.0f;
                bfl.E();
                bfl.b((float)(menuLeft - 80), (float)(menuTop + 50), (float)-100.0f);
                bfl.b((float)(rotation + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                bfl.a((float)scale, (float)scale, (float)scale);
                this.blockBenchLoader.getModel((String)"Head").rotateAngleY = (float)Math.toRadians(-rotation);
                this.blockBenchLoader.getModel((String)"LeftLeg").rotateAngleX = (float)Math.toRadians(-20.0);
                this.blockBenchLoader.getModel((String)"RightLeg").rotateAngleX = (float)Math.toRadians(20.0);
                this.blockBenchLoader.getModel((String)"LeftArm").rotateAngleX = (float)Math.toRadians(20.0);
                this.blockBenchLoader.getModel((String)"RightArm").rotateAngleX = (float)Math.toRadians(-20.0);
                jy skin = drawUtils.getPlayerSkinTextureCache().getSkinTexture(LabyMod.getInstance().getPlayerUUID());
                ave.A().P().a(skin);
                bfl.f();
                bfl.c((float)1.0f, (float)1.0f, (float)1.0f);
                bfl.j();
                bfl.p();
                this.blockBenchLoader.getModel().render(1.0f);
                bfl.o();
                bfl.F();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        drawUtils.drawOverlayBackground(menuBottom, this.m);
        drawUtils.drawGradientShadowTop(30.0, 0.0, this.l);
        drawUtils.drawGradientShadowBottom(menuBottom, 0.0, this.l);
        if (this.m - menuBottom > 60) {
            drawUtils.drawCenteredString(ModColor.cl('9') + ModColor.cl('n') + "laby.net/@" + LabyMod.getInstance().getPlayerName(), (float)this.l / 2.0f, (float)this.m - (float)(this.m - menuBottom) / 2.0f);
        }
        super.a(mouseX, mouseY, partialTicks);
        for (int i = this.settings.size() - 1; i >= 0; --i) {
            LabyNetSetting setting = this.settings.get(i);
            setting.menu.draw(mouseX, mouseY);
        }
    }

    protected void a(int mouseX, int mouseY, int button) throws IOException {
        for (LabyNetSetting setting : this.settings) {
            if (!setting.menu.onClick(mouseX, mouseY, button)) continue;
            for (LabyNetSetting innerSetting : this.settings) {
                if (innerSetting == setting) continue;
                innerSetting.menu.setOpen(false);
            }
            return;
        }
        if (mouseY < 30 && mouseX < this.l / 2 || (float)mouseY > (float)this.m - (float)(this.m - 200) / 2.0f && (float)mouseY < (float)this.m - (float)(this.m - 200) / 2.0f + 10.0f) {
            LabyMod.getInstance().openWebpage("https://laby.net/@" + LabyMod.getInstance().getPlayerName(), true);
        }
        super.a(mouseX, mouseY, button);
    }

    protected void a(char typedChar, int keyCode) throws IOException {
        super.a(typedChar, keyCode);
        if (keyCode == 1) {
            this.a(this.doneButton);
        }
        super.a(typedChar, keyCode);
    }

    public class SettingOption {
        private final char character;
        private final String value;
        private final String displayString;

        public SettingOption(char character, String value) {
            this.character = character;
            this.value = value;
            this.displayString = ModColor.cl(this.character) + LanguageManager.translate("labynet_setting_option_" + value.toLowerCase());
        }

        public char getCharacter() {
            return this.character;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.displayString;
        }
    }

    public class LabyNetSetting {
        private final DropDownMenu<SettingOption> menu;
        private final String id;

        public LabyNetSetting(String id, JsonArray values, String selected) {
            this.id = id;
            String displayString = LanguageManager.translate("labynet_setting_" + id.replace(".", "_"));
            this.menu = new DropDownMenu(displayString, 0, 0, 0, 0);
            for (JsonElement value : values) {
                JsonObject entry = value.getAsJsonObject();
                char character = entry.get("character").getAsString().charAt(0);
                String valueString = entry.get("value").getAsString();
                SettingOption option = new SettingOption(character, valueString);
                this.menu.addOption(option);
                if (!valueString.equals(selected)) continue;
                this.menu.setSelected(option);
            }
            this.menu.setEntryDrawer((object, x, y, trimmedEntry) -> {
                SettingOption value = (SettingOption)object;
                LabyMod.getInstance().getDrawUtils().drawString(value.toString(), x, y);
            });
        }

        public DropDownMenu<SettingOption> getMenu() {
            return this.menu;
        }

        public String getId() {
            return this.id;
        }
    }
}

