/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.discordapp.listeners;

import net.labymod.api.events.MessageSendEvent;
import net.labymod.core.LabyModCore;
import net.labymod.discordapp.DiscordApp;
import net.labymod.discordapp.api.DiscordEventHandlers;
import net.labymod.discordapp.api.DiscordJoinRequest;
import net.labymod.main.LabyMod;
import net.labymod.main.lang.LanguageManager;
import net.labymod.support.util.Debug;
import net.labymod.utils.ModColor;

public class JoinRequestListener
implements DiscordEventHandlers.joinRequest_callback,
MessageSendEvent {
    private DiscordApp discordApp;

    public JoinRequestListener(DiscordApp discordApp) {
        this.discordApp = discordApp;
        LabyMod.getInstance().getEventManager().register(this);
    }

    @Override
    public boolean onSend(String message) {
        if (message.toLowerCase().startsWith("/discordrpc ")) {
            String[] args = message.split(" ");
            if (args.length >= 3) {
                boolean accepted = args[1].equalsIgnoreCase("accept");
                this.discordApp.respond(args[2], accepted ? 1 : 0);
                LabyMod.getInstance().displayMessageInChat(LanguageManager.translate("discordrpc_join_request_accepted"));
            }
            return true;
        }
        return false;
    }

    @Override
    public void apply(DiscordJoinRequest request) {
        Debug.log(Debug.EnumDebugMode.DISCORD, "Join request: " + request.username + "#" + request.userId);
        LabyModCore.getMinecraft().displayMessageInChatCustomAction(LanguageManager.translate("discordrpc_join_request_chat", request.username), 2, "/discordrpc accept " + request.userId);
        String imageURL = String.format("https://cdn.discordapp.com/avatars/%s/%s.png", request.userId, request.avatar);
        String username = ModColor.cl('3') + request.username + ModColor.cl('8') + "#" + ModColor.cl('7') + request.discriminator;
        String message = ModColor.cl('a') + LanguageManager.translate("discordrpc_join_request_achievement");
        if (LabyMod.getSettings().discordShowAchievements) {
            LabyMod.getInstance().getGuiCustomAchievement().displayAchievement(imageURL, username, message);
        }
    }
}

