/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.core.asm.global;

import net.labymod.core.asm.LabyModTransformer;
import net.labymod.core.asm.global.ClassEditor;
import net.labymod.main.Source;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class NetHandlerPlayClientVisitor
extends ClassEditor {
    private static final boolean MC_18 = Source.ABOUT_MC_VERSION.startsWith("1.8");
    private String packetCustomPayloadName = LabyModTransformer.getMappingImplementation().getCustomPayLoadPacketName();
    private String handleCustomPayloadName = LabyModTransformer.getMappingImplementation().getHandleCustomPayLoadName();
    private String getChannelNameName = LabyModTransformer.getMappingImplementation().getChannelNameName();
    private String getBufferDataName = LabyModTransformer.getMappingImplementation().getBufferDataName();
    private String packetBufferName = LabyModTransformer.getMappingImplementation().getPacketBufferName();
    private String handleResourcePackName = LabyModTransformer.getMappingImplementation().getHandleResourcePackName();
    private String packetResourcePackSendName = LabyModTransformer.getMappingImplementation().getPacketResourcePackSendName();
    private String packetPlayerListItemName = LabyModTransformer.getMappingImplementation().getPacketPlayerListItemName();
    private String networkPlayerInfoName = LabyModTransformer.getMappingImplementation().getNetworkPlayerInfoName();

    public NetHandlerPlayClientVisitor() {
        super(ClassEditor.ClassEditorType.CLASS_NODE);
    }

    @Override
    public void accept(String name, ClassNode node) {
        for (MethodNode methodNode : node.methods) {
            AbstractInsnNode targetNode;
            InsnList insnList;
            if (methodNode.name.equals(this.handleCustomPayloadName) && methodNode.desc.equals("(L" + this.packetCustomPayloadName + ";)V")) {
                AbstractInsnNode returnNode = null;
                for (AbstractInsnNode insnNode : methodNode.instructions.toArray()) {
                    if (!(insnNode instanceof InsnNode) || ((InsnNode)insnNode).getOpcode() != 177) continue;
                    returnNode = insnNode;
                    break;
                }
                if (returnNode == null) continue;
                insnList = new InsnList();
                insnList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                insnList.add((AbstractInsnNode)new MethodInsnNode(182, this.packetCustomPayloadName, this.getChannelNameName, "()Ljava/lang/String;", false));
                insnList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                insnList.add((AbstractInsnNode)new MethodInsnNode(182, this.packetCustomPayloadName, this.getBufferDataName, "()L" + this.packetBufferName + ";", false));
                insnList.add((AbstractInsnNode)new MethodInsnNode(184, "BytecodeMethods", "onReceivePluginMessage", "(Ljava/lang/String;L" + this.packetBufferName + ";)V", false));
                methodNode.instructions.insertBefore(returnNode, insnList);
            }
            if (MC_18 && methodNode.name.equals(this.handleResourcePackName) && methodNode.desc.equals("(L" + this.packetResourcePackSendName + ";)V")) {
                MethodInsnNode methodInsnNode = null;
                for (AbstractInsnNode insnNode : methodNode.instructions.toArray()) {
                    if (!(insnNode instanceof MethodInsnNode) || ((MethodInsnNode)insnNode).getOpcode() != 182) continue;
                    methodInsnNode = (MethodInsnNode)insnNode;
                    break;
                }
                if (methodInsnNode == null) continue;
                methodNode.instructions.insert(methodInsnNode, (AbstractInsnNode)new MethodInsnNode(184, "BytecodeMethods", "modifyResourcePackURL", "(Ljava/lang/String;)Ljava/lang/String;", false));
            }
            if (methodNode.desc.equals("(L" + this.packetPlayerListItemName + ";)V")) {
                targetNode = null;
                for (AbstractInsnNode insnNode : methodNode.instructions.toArray()) {
                    if (insnNode.getOpcode() != 177) continue;
                    targetNode = insnNode;
                    break;
                }
                if (targetNode != null) {
                    insnList = new InsnList();
                    insnList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    insnList.add((AbstractInsnNode)new MethodInsnNode(184, "BytecodeMethods", "handlePlayerListItem", "(Ljava/lang/Object;)V", false));
                    methodNode.instructions.insertBefore(targetNode, insnList);
                }
            }
            if (!methodNode.desc.equals("(Ljava/util/UUID;)L" + this.networkPlayerInfoName + ";")) continue;
            targetNode = null;
            for (AbstractInsnNode insnNode : methodNode.instructions.toArray()) {
                if (insnNode.getOpcode() != 176) continue;
                targetNode = insnNode;
                break;
            }
            if (targetNode == null) continue;
            insnList = new InsnList();
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 1));
            insnList.add((AbstractInsnNode)new MethodInsnNode(184, "BytecodeMethods", "getCachedPlayerInfo", "(L" + this.networkPlayerInfoName + ";Ljava/util/UUID;)L" + this.networkPlayerInfoName + ";", false));
            methodNode.instructions.insertBefore(targetNode, insnList);
        }
    }
}

