/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.api.protocol.screen.render.components.widgets;

import com.google.gson.JsonObject;
import net.labymod.api.protocol.screen.render.components.RenderWidget;
import net.labymod.api.protocol.screen.render.util.IInteractionCallback;
import net.labymod.api.protocol.screen.render.util.IScreenAccessor;
import net.labymod.core.LabyModCore;
import net.labymod.gui.elements.ModTextField;
import net.labymod.serverapi.common.widgets.components.widgets.TextFieldWidget;

public class RenderTextFieldWidget
extends RenderWidget<TextFieldWidget> {
    private ModTextField textField;

    public RenderTextFieldWidget(TextFieldWidget widget, IInteractionCallback callback) {
        super(widget, callback);
    }

    @Override
    public void createScreen(IScreenAccessor accessor) {
        this.textField = new ModTextField(((TextFieldWidget)this.widget).getId(), LabyModCore.getMinecraft().getFontRenderer(), this.getX(accessor), this.getY(accessor), ((TextFieldWidget)this.widget).getWidth(), ((TextFieldWidget)this.widget).getHeight());
        this.textField.setText(((TextFieldWidget)this.widget).getValue());
        this.textField.setMaxStringLength(((TextFieldWidget)this.widget).getMaxLength());
        this.textField.setFocused(((TextFieldWidget)this.widget).isFocused());
        this.textField.setCursorPositionEnd();
        this.textField.setPlaceHolder(((TextFieldWidget)this.widget).getPlaceholder());
    }

    @Override
    public void initScreen(IScreenAccessor accessor) {
        super.initScreen(accessor);
        this.textField.xPosition = this.getX(accessor);
        this.textField.yPosition = this.getY(accessor);
        this.textField.setFocused(((TextFieldWidget)this.widget).isFocused());
    }

    @Override
    public void renderScreen(IScreenAccessor accessor, int mouseX, int mouseY) {
        this.textField.drawTextBox();
    }

    @Override
    public void keyTyped(IScreenAccessor accessor, char typedChar, int keyCode) {
        this.textField.textboxKeyTyped(typedChar, keyCode);
    }

    @Override
    public boolean mouseClicked(IScreenAccessor accessor, double mouseX, double mouseY, int button) {
        boolean prevFocused = this.textField.isFocused();
        boolean result = this.textField.mouseClicked((int)mouseX, (int)mouseY, button);
        if (prevFocused && !this.textField.isFocused()) {
            this.sendResponse(accessor);
        }
        return result;
    }

    @Override
    public void tick(IScreenAccessor accessor) {
        this.textField.updateCursorCounter();
    }

    @Override
    protected void fillResponsePayload(JsonObject payload) {
        payload.addProperty("value", this.textField.getText());
    }
}

