/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.api.protocol.screen.render;

import java.io.IOException;
import java.util.List;
import net.labymod.api.protocol.screen.render.GuiScreenProtocol;
import net.labymod.api.protocol.screen.render.components.RenderWidget;
import net.labymod.api.protocol.screen.render.util.IInteractionCallback;
import net.labymod.core.LabyModCore;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.serverapi.common.widgets.WidgetLayout;
import net.labymod.serverapi.common.widgets.components.Widget;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;
import net.labymod.utils.manager.TooltipHelper;

public class GuiWrappedInventory
extends GuiScreenProtocol {
    protected final ayl screen;
    protected final xi container;
    protected final int id;
    protected final IInteractionCallback callback;
    protected final List<RenderWidget<? extends Widget>> widgets;
    private final int slotWidth;
    private final int slotHeight;
    private final int slotMarginX;
    private final int slotMarginY;
    private final int borderPaddingX;
    private final int borderPaddingY;
    private final double fontSize;
    private int lastHoveredSlotIndex = -1;
    private int lastLabelShiftY;
    private boolean canRender = false;

    public GuiWrappedInventory(ayl containerScreen, int id, IInteractionCallback callback, List<RenderWidget<? extends Widget>> widgets, WidgetLayout layout) {
        super(null, id, callback, widgets);
        this.screen = containerScreen;
        this.container = containerScreen.h;
        this.id = id;
        this.callback = callback;
        this.widgets = widgets;
        this.slotWidth = layout.getSlotWidth();
        this.slotHeight = layout.getSlotHeight();
        this.slotMarginX = layout.getSlotMarginX();
        this.slotMarginY = layout.getSlotMarginY();
        this.borderPaddingX = layout.getBorderPaddingX();
        this.borderPaddingY = layout.getBorderPaddingY();
        this.fontSize = layout.getFontSize();
    }

    @Override
    public void a(int mouseX, int mouseY, float partialTicks) {
        super.a(mouseX, mouseY, partialTicks);
        List slots = this.container.c;
        int amount = slots.size() - 36;
        int columns = 9;
        int rows = amount / columns;
        double totalWidth = columns * (this.slotWidth + this.slotMarginX) - this.slotMarginX;
        double totalHeight = rows * (this.slotHeight + this.slotMarginY) - this.slotMarginY + this.lastLabelShiftY;
        double left = (double)this.l / 2.0 - totalWidth / 2.0 - (double)this.borderPaddingX;
        double top = (double)this.m / 2.0 - totalHeight / 2.0 - (double)this.borderPaddingY;
        double right = (double)this.l / 2.0 + totalWidth / 2.0 + (double)this.borderPaddingX;
        double bottom = (double)this.m / 2.0 + totalHeight / 2.0 + (double)this.borderPaddingY;
        if (this.canRender) {
            this.renderBackground(left, top, right, bottom);
        }
        this.lastHoveredSlotIndex = -1;
        int labelShiftY = 0;
        int highestSlotInRow = 0;
        boolean emptyRow = true;
        try {
            for (int i = 0; i < amount; ++i) {
                int slotHeight;
                boolean mouseOver;
                boolean stackEmpty;
                yg slot = (yg)slots.get(i);
                if (i % columns == 0) {
                    if (emptyRow) {
                        labelShiftY += highestSlotInRow;
                    } else {
                        emptyRow = true;
                        labelShiftY -= this.slotHeight - highestSlotInRow;
                    }
                    highestSlotInRow = 0;
                }
                if (!(stackEmpty = LabyModCore.getMinecraft().isItemStackEmpty(slot.d()))) {
                    emptyRow = false;
                }
                double offsetX = (double)this.l / 2.0 - totalWidth / 2.0;
                double offsetY = (double)this.m / 2.0 - totalHeight / 2.0;
                double x = (double)(i % columns * (this.slotWidth + this.slotMarginX)) + offsetX;
                double y = (double)(i / columns * (this.slotHeight + this.slotMarginY)) + offsetY + (double)labelShiftY;
                boolean bl = mouseOver = (double)mouseX >= x && (double)mouseX <= x + (double)this.slotWidth && (double)mouseY >= y && (double)mouseY <= y + (double)this.slotHeight;
                if (mouseOver && !stackEmpty) {
                    this.lastHoveredSlotIndex = i;
                }
                if ((slotHeight = this.renderWrappedWidget(slot, x, y, mouseOver, mouseX, mouseY)) <= highestSlotInRow) continue;
                highestSlotInRow = slotHeight;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.canRender) {
            // empty if block
        }
        this.lastLabelShiftY = labelShiftY + highestSlotInRow;
        this.canRender = true;
    }

    @Override
    protected void a(int mouseX, int mouseY, int button) throws IOException {
        super.a(mouseX, mouseY, button);
        if (this.lastHoveredSlotIndex != -1) {
            ave minecraft = ave.A();
            if (minecraft.c != null && LabyModCore.getMinecraft().getPlayer() != null) {
                LabyModCore.getMinecraft().windowClick(this.container.d, this.lastHoveredSlotIndex, button, 0, LabyModCore.getMinecraft().getPlayer());
            }
        }
        super.a(mouseX, mouseY, button);
    }

    @Override
    protected void a(char typedChar, int keyCode) throws IOException {
        super.a(typedChar, keyCode);
        if (ave.A().t.af.i() == keyCode) {
            this.closeProperly();
            return;
        }
        super.a(typedChar, keyCode);
    }

    private void renderBackground(double left, double top, double right, double bottom) {
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        draw.drawRect(left + 5.0, top + 5.0, right - 5.0, bottom - 5.0, ModColor.toRGB(0, 0, 0, 200));
        ave.A().P().a(ModTextures.GUI_WRAPPER_INVENTORY);
        double texWidth = 32.0;
        double texHeight = 1.3689839572192513 * texWidth;
        draw.drawTexture(left, top, texWidth, texHeight, texWidth, texWidth);
        draw.drawTexture(right - texWidth, top, 256.0 - texWidth, 0.0, texWidth, texHeight, texWidth, texWidth);
        draw.drawTexture(left, bottom - texWidth, 0.0, 256.0 - texHeight, texWidth, texHeight, texWidth, texWidth);
        draw.drawTexture(right - texWidth, bottom - texWidth, 256.0 - texWidth, 256.0 - texHeight, texWidth, texHeight, texWidth, texWidth);
        draw.drawTexture(left + texWidth, top, texWidth, 0.0, 1.0, texHeight, right - left - texWidth * 2.0, texWidth);
        draw.drawTexture(left + texWidth, bottom - texWidth, texWidth, 256.0 - texHeight, 1.0, texHeight, right - left - texWidth * 2.0, texWidth);
        draw.drawTexture(left, top + texWidth, 0.0, texHeight, texWidth, texHeight, texWidth, bottom - top - texWidth * 2.0);
        draw.drawTexture(right - texWidth, top + texWidth, 256.0 - texWidth, texHeight, texWidth, texHeight, texWidth, bottom - top - texWidth * 2.0);
    }

    private int renderWrappedWidget(yg slot, double x, double y, boolean mouseOver, int mouseX, int mouseY) {
        dn tag;
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        double hover = mouseOver ? 3.0 : 0.0;
        zx itemStack = slot == null ? null : slot.d();
        String url = null;
        dn dn2 = tag = itemStack == null ? null : itemStack.o();
        if (tag != null) {
            dn publicBukkitValues;
            if (tag.c("CustomImageUrl")) {
                url = tag.j("CustomImageUrl");
            }
            if (tag.c("PublicBukkitValues") && (publicBukkitValues = tag.m("PublicBukkitValues")).c("labymod3:customimageurl")) {
                url = publicBukkitValues.j("labymod3:customimageurl");
            }
        }
        if (this.canRender) {
            if (url == null) {
                this.renderItem(slot.d(), x - hover, y - hover, (double)this.slotWidth + hover * 2.0, (double)this.slotHeight + hover * 2.0);
            } else {
                jy resourceLocation = LabyMod.getInstance().getDynamicTextureManager().getTexture("screen_image_widget_" + url.hashCode(), url);
                ave.A().P().a(resourceLocation);
                draw.drawTexture(x - hover, y - hover, 256.0, 256.0, (double)this.slotWidth + hover * 2.0, (double)this.slotHeight + hover * 2.0);
            }
        }
        if (!LabyModCore.getMinecraft().isItemStackEmpty(slot.d())) {
            zx stack = slot.d();
            String title = stack.q();
            List<String> list = draw.listFormattedStringToWidth(title, (int)((double)(this.slotWidth + this.slotMarginX) / this.fontSize));
            int listY = 0;
            for (String line : list) {
                if (this.canRender) {
                    draw.drawCenteredString(line, (float)(x + (double)((float)this.slotWidth / 2.0f)), (float)(y + (double)this.slotHeight + 3.0) + (float)listY, (float)this.fontSize);
                }
                listY = (int)((double)listY + this.fontSize * 10.0);
            }
            if (this.canRender && mouseOver) {
                List<String> tooltip = LabyModCore.getMinecraft().getTooltip(stack, LabyModCore.getMinecraft().getPlayer());
                String[] processors = new String[tooltip.size()];
                tooltip.toArray(processors);
                TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, 0L, processors);
            }
            return listY + 2;
        }
        return 0;
    }

    private void renderItem(zx itemStack, double x, double y, double width, double height) {
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        double scale = 0.05 * width;
        bfl.E();
        bfl.j();
        bfl.a((double)scale, (double)scale, (double)scale);
        if (itemStack != null) {
            draw.drawItem(itemStack, (x - 3.0 + width / 2.0 - scale * 6.0) / scale, (y - 3.0 + height / 2.0 - scale * 6.0) / scale, "");
        }
        bfl.F();
    }
}

