/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.api.protocol.screen.render;

import java.io.IOException;
import java.util.List;
import net.labymod.api.protocol.screen.render.components.RenderWidget;
import net.labymod.api.protocol.screen.render.util.IInteractionCallback;
import net.labymod.api.protocol.screen.render.util.IScreenAccessor;
import net.labymod.main.LabyMod;
import net.labymod.serverapi.common.widgets.components.Widget;
import net.labymod.serverapi.common.widgets.util.EnumResponse;
import net.labymod.utils.ModColor;

public class GuiScreenProtocol
extends axu
implements IScreenAccessor {
    private final axu lastScreen;
    private final int id;
    private IInteractionCallback callback;
    private List<RenderWidget<? extends Widget>> widgets;
    private String lastExceptionMessage = null;
    private boolean screenCreated = false;

    public GuiScreenProtocol(axu lastScreen, int id, IInteractionCallback callback, List<RenderWidget<? extends Widget>> widgets) {
        this.lastScreen = lastScreen;
        this.id = id;
        this.callback = callback;
        this.widgets = widgets;
    }

    public void b() {
        super.b();
        try {
            this.n.clear();
            for (RenderWidget<? extends Widget> widget : this.widgets) {
                if (!this.screenCreated) {
                    widget.createScreen(this);
                }
                widget.initScreen(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.lastExceptionMessage = e.getMessage();
        }
        this.screenCreated = true;
    }

    @Override
    public void closeProperly() {
        try {
            for (RenderWidget<? extends Widget> widget : this.widgets) {
                widget.onClose(this);
            }
            this.callback.sendResponse(this.id, EnumResponse.CLOSE, -1, states -> this.widgets.forEach(widget -> widget.putState(states)));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.lastExceptionMessage = e.getMessage();
        }
        ave.A().a(this.lastScreen);
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        this.c();
        if (this.lastExceptionMessage == null) {
            super.a(mouseX, mouseY, partialTicks);
            try {
                for (RenderWidget<? extends Widget> widget : this.widgets) {
                    widget.renderScreen(this, mouseX, mouseY);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.lastExceptionMessage = e instanceof NullPointerException ? "NullPointerException" : e.getMessage();
            }
        } else {
            LabyMod.getInstance().getDrawUtils().drawCenteredString(ModColor.cl('c') + this.lastExceptionMessage, (double)this.l / 2.0, (double)this.m / 2.0);
        }
    }

    protected void a(char typedChar, int keyCode) throws IOException {
        try {
            for (RenderWidget<? extends Widget> widget : this.widgets) {
                widget.keyTyped(this, typedChar, keyCode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.lastExceptionMessage = e.getMessage();
        }
        if (keyCode == 1) {
            this.closeProperly();
            return;
        }
        super.a(typedChar, keyCode);
    }

    protected void a(int mouseX, int mouseY, int button) throws IOException {
        try {
            for (RenderWidget<? extends Widget> widget : this.widgets) {
                if (!widget.mouseClicked(this, mouseX, mouseY, button)) continue;
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.lastExceptionMessage = e.getMessage();
        }
        super.a(mouseX, mouseY, button);
    }

    public void e() {
        try {
            for (RenderWidget<? extends Widget> widget : this.widgets) {
                widget.tick(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.lastExceptionMessage = e.getMessage();
        }
    }

    protected void a(avs button) throws IOException {
        try {
            for (RenderWidget<? extends Widget> widget : this.widgets) {
                if (widget.getWidget().getId() != button.k) continue;
                widget.actionPerformed(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.lastExceptionMessage = e.getMessage();
        }
        super.a(button);
    }

    @Override
    public void addMinecraftButton(avs button) {
        this.n.add(button);
    }

    @Override
    public int getScreenId() {
        return this.id;
    }

    @Override
    public int getWidth() {
        return this.l;
    }

    @Override
    public int getHeight() {
        return this.m;
    }

    public axu getLastScreen() {
        return this.lastScreen;
    }

    public void setWidgets(List<RenderWidget<? extends Widget>> widgets) {
        this.widgets = widgets;
    }
}

