/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.api.protocol.cinematic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import net.labymod.api.protocol.cinematic.Cubic;
import net.labymod.api.protocol.cinematic.EnumPositionValue;
import net.labymod.api.protocol.cinematic.IPositionValueAdapter;
import net.labymod.api.protocol.cinematic.Position;

public class Spline {
    private Vector<Position> points = new Vector();
    private List<Vector<Cubic>> cubics = Collections.emptyList();
    private int cubicEntrySize;

    public boolean isValid() {
        return this.points.size() >= 2 && !this.cubics.isEmpty();
    }

    public void reset() {
        this.points.clear();
        this.cubics.clear();
        this.cubicEntrySize = 0;
    }

    public void add(Position point) {
        if (this.points.isEmpty()) {
            point.setYaw((point.getYaw() + 180.0) % 360.0 - 180.0);
            point.setTilt(point.getTilt() % 360.0);
        } else {
            Position last = this.points.get(this.points.size() - 1);
            point.setYaw(this.fixEulerRotation(last.getYaw(), point.getYaw(), 180));
            point.setTilt(this.fixEulerRotation(last.getTilt(), point.getTilt(), 0));
        }
        this.points.add(point);
    }

    public Position get(float progress) {
        float progressAtCubics = progress * (float)this.cubicEntrySize;
        int cubicIndex = (int)Math.min((float)(this.cubicEntrySize - 1), progressAtCubics);
        float cubicProgress = progressAtCubics - (float)cubicIndex;
        Position position = new Position();
        for (EnumPositionValue valueType : EnumPositionValue.values()) {
            double value = this.cubics.get(valueType.ordinal()).get(cubicIndex).eval(cubicProgress);
            valueType.getAdapter().set(position, value);
        }
        return position;
    }

    public void calculate() {
        this.cubics = new ArrayList<Vector<Cubic>>(EnumPositionValue.values().length);
        for (EnumPositionValue type : EnumPositionValue.values()) {
            Vector<Cubic> vector = new Vector<Cubic>();
            try {
                this.calculateNaturalCubic(type, this.points, vector);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.cubicEntrySize = vector.size();
            this.cubics.add(vector);
        }
    }

    private void calculateNaturalCubic(EnumPositionValue type, Vector<Position> points, Vector<Cubic> cubics) {
        int i;
        IPositionValueAdapter adapter = type.getAdapter();
        int num = points.size() - 1;
        double[] gamma = new double[num + 1];
        double[] delta = new double[num + 1];
        double[] D = new double[num + 1];
        gamma[0] = 0.5;
        for (i = 1; i < num; ++i) {
            gamma[i] = 1.0 / (4.0 - gamma[i - 1]);
        }
        gamma[num] = 1.0 / (2.0 - gamma[num - 1]);
        Double p0 = adapter.get(points.get(0));
        Double p1 = adapter.get(points.get(1));
        delta[0] = 3.0 * (p1 - p0) * gamma[0];
        for (i = 1; i < num; ++i) {
            p0 = adapter.get(points.get(i - 1));
            p1 = adapter.get(points.get(i + 1));
            delta[i] = (3.0 * (p1 - p0) - delta[i - 1]) * gamma[i];
        }
        p0 = adapter.get(points.get(num - 1));
        p1 = adapter.get(points.get(num));
        delta[num] = (3.0 * (p1 - p0) - delta[num - 1]) * gamma[num];
        D[num] = delta[num];
        for (i = num - 1; i >= 0; --i) {
            D[i] = delta[i] - gamma[i] * D[i + 1];
        }
        cubics.clear();
        for (i = 0; i < num; ++i) {
            p0 = adapter.get(points.get(i));
            p1 = adapter.get(points.get(i + 1));
            cubics.add(new Cubic(p0, D[i], 3.0 * (p1 - p0) - 2.0 * D[i] - D[i + 1], 2.0 * (p0 - p1) + D[i] + D[i + 1]));
        }
    }

    private double fixEulerRotation(double first, double second, int eulerBreak) {
        int factor;
        if (first == second) {
            return first;
        }
        double normalizedFirst = (first + (double)eulerBreak) % 360.0;
        double normalizedSecond = (second + (double)eulerBreak) % 360.0;
        double pathDifference = Math.abs(normalizedSecond - normalizedFirst);
        int n = factor = normalizedSecond > normalizedFirst ? 1 : -1;
        if (pathDifference > 180.0) {
            pathDifference = -1.0 * (360.0 - pathDifference);
        }
        return first + (double)factor * pathDifference;
    }
}

