/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.api.protocol.cinematic;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.labymod.api.EventManager;
import net.labymod.api.LabyModAPI;
import net.labymod.api.events.ServerMessageEvent;
import net.labymod.api.protocol.cinematic.Position;
import net.labymod.api.protocol.cinematic.Spline;
import net.labymod.core.LabyModCore;
import net.labymod.main.LabyMod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class CinematicProtocol
implements ServerMessageEvent {
    private Spline spline = new Spline();
    private long duration = 0L;
    private long startTime = -1L;
    private float currentTilt = 0.0f;

    public CinematicProtocol() {
        LabyModAPI api = LabyMod.getInstance().getLabyModAPI();
        EventManager eventManager = api.getEventManager();
        eventManager.register(this);
        api.registerForgeListener(this);
    }

    @Override
    public void onServerMessage(String messageKey, JsonElement serverMessage) {
        if (messageKey.equals("cinematic")) {
            JsonObject cinematic = serverMessage.getAsJsonObject();
            this.reset(false);
            bew player = LabyModCore.getMinecraft().getPlayer();
            if (player == null || player.bA == null || !player.bA.c) {
                return;
            }
            if (cinematic.has("points")) {
                JsonArray points = cinematic.get("points").getAsJsonArray();
                for (int i = 0; i < points.size(); ++i) {
                    JsonObject point = points.get(i).getAsJsonObject();
                    double x = point.get("x").getAsDouble();
                    double y = point.get("y").getAsDouble();
                    double z = point.get("z").getAsDouble();
                    double yaw = point.get("yaw").getAsDouble();
                    double pitch = point.get("pitch").getAsDouble();
                    double tilt = point.has("tilt") ? point.get("tilt").getAsDouble() : 0.0;
                    this.spline.add(new Position(x, y, z, yaw, pitch, tilt));
                }
                this.spline.calculate();
            }
            if (cinematic.has("duration")) {
                this.duration = cinematic.get("duration").getAsLong();
            }
            if (cinematic.has("clear_chat")) {
                LabyModCore.getMinecraft().clearChatMessages();
            }
            this.startTime = System.currentTimeMillis();
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (!this.isRunning()) {
            return;
        }
        long timePassed = System.currentTimeMillis() - this.startTime;
        float progress = Math.min(1.0f, (float)timePassed / (float)this.duration);
        if (progress >= 1.0f) {
            this.reset(true);
            return;
        }
        Position position = this.spline.get(progress);
        this.currentTilt = (float)position.getTilt();
        ave.A().t.aB = 0;
        bew player = LabyModCore.getMinecraft().getPlayer();
        if (player != null) {
            player.a(position.getX(), position.getY(), position.getZ(), (float)position.getYaw(), (float)position.getPitch());
            player.A = player.y;
            player.B = player.z;
            player.P = player.s;
            player.Q = player.t;
            player.R = player.u;
        }
    }

    public boolean isRunning() {
        return this.duration != 0L && this.spline.isValid();
    }

    public void reset(boolean completed) {
        if (completed) {
            JsonObject cinematic = new JsonObject();
            cinematic.addProperty("completed", Boolean.valueOf(true));
            LabyMod.getInstance().getLabyModAPI().sendJsonMessageToServer("cinematic", (JsonElement)cinematic);
        }
        this.spline.reset();
        this.duration = 0L;
        this.currentTilt = 0.0f;
    }

    public float getCurrentTilt() {
        return this.currentTilt;
    }
}

