/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addon.online;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.concurrent.Executors;
import net.labymod.addon.AddonLoader;
import net.labymod.addon.online.CallbackAddonDownloadProcess;
import net.labymod.addon.online.info.AddonInfo;
import net.labymod.addon.online.info.OnlineAddonInfo;
import net.labymod.main.Source;
import net.labymod.utils.request.DownloadServerRequest;
import net.labymod.utils.request.InputStreamOutput;

public class AddonDownloader {
    private AddonInfo addonInfo;
    private CallbackAddonDownloadProcess callback;
    private File file;

    public AddonDownloader(OnlineAddonInfo addonInfo, File file, CallbackAddonDownloadProcess callback) {
        this.addonInfo = addonInfo;
        this.callback = callback;
        this.file = file;
    }

    public AddonDownloader(OnlineAddonInfo addonInfo, CallbackAddonDownloadProcess callback) {
        this.addonInfo = addonInfo;
        this.callback = callback;
        if (addonInfo.isIncludeInJar()) {
            this.file = new File(Source.FILE_OFHANDLER_FOLDER, "optifine.jar");
            this.file.getParentFile().mkdir();
        } else {
            this.file = new File(AddonLoader.getAddonsDirectory(), addonInfo.getName() + ".jar");
        }
    }

    public void downloadAsync() {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AddonDownloader.this.downloadSync();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    AddonDownloader.this.callback.failed(e.getMessage());
                }
            }
        });
    }

    public void downloadSync() throws Exception {
        InputStreamOutput inputStream = DownloadServerRequest.getInputStream(this.addonInfo.getDownloadURL());
        DataInputStream dataInputStream = new DataInputStream(inputStream.getInputStream());
        FileOutputStream fileOutputStream = new FileOutputStream(this.file);
        int total = inputStream.getContentLength();
        int current = 0;
        boolean smooth = total < 1000000;
        long start = System.currentTimeMillis();
        byte[] buff = new byte[2048];
        int readBytes = 0;
        int iterations = total / buff.length;
        long animationDuration = 2000L;
        long sleep = Math.min(30L, animationDuration / (long)iterations);
        while ((readBytes = dataInputStream.read(buff, 0, buff.length)) != -1) {
            fileOutputStream.write(buff, 0, readBytes);
            if (total != -1 && (current += readBytes) != total) {
                this.callback.progress((double)current / (double)total * 100.0);
            }
            if (System.currentTimeMillis() - start > animationDuration) {
                smooth = false;
            }
            if (!smooth) continue;
            Thread.sleep(sleep);
        }
        dataInputStream.close();
        fileOutputStream.close();
        this.callback.progress(100.0);
        this.callback.success(this.file);
    }
}

