/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addon;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.jar.JarFile;
import net.labymod.addon.About;
import net.labymod.addon.AddonLoader;
import net.labymod.api.LabyModAddon;
import net.labymod.core.asm.LabyModCoreMod;
import net.labymod.main.Source;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.support.util.Debug;
import net.labymod.utils.LauncherDirectoryUtils;
import net.labymod.utils.request.DownloadServerRequest;
import net.labymod.utils.request.RequestException;
import net.labymod.utils.request.ServerStatus;

public class LabyModOFAddon
extends LabyModAddon {
    public static final Map<String, UUID> OPTIFINE_VERSIONS = new HashMap<String, UUID>(){
        {
            this.put("1.8.9", UUID.fromString("2cc09032-995f-4b57-a2a1-f1399addbb21"));
            this.put("1.12.2", UUID.fromString("7d62bffd-fe3f-4667-8200-e8decb384fa0"));
        }
    };
    private static final File FILE_OF_HANDLER = new File(Source.FILE_OFHANDLER_FOLDER, "ofhandler.jar");
    private static final JsonParser parser = new JsonParser();
    private static File OPTIFINE_FORGE = null;
    public static boolean INSTALL = false;
    public static String INSTALLED_VERSION = null;

    @Override
    public void onEnable() {
    }

    @Override
    public void onDisable() {
    }

    @Override
    public void init(String addonName, UUID uuid) {
        this.about = new About(uuid, addonName);
        this.about.loaded = true;
        INSTALLED_VERSION = addonName == null ? null : addonName.replaceAll("_", "");
    }

    public static void downloadOFHandler(boolean async) {
        if (FILE_OF_HANDLER.exists()) {
            FILE_OF_HANDLER.delete();
        }
        if (!FILE_OF_HANDLER.exists()) {
            try {
                FILE_OF_HANDLER.getParentFile().mkdirs();
                final FileOutputStream fos = new FileOutputStream(FILE_OF_HANDLER);
                if (async) {
                    DownloadServerRequest.writeBytesAsync("https://dl.labymod.net/latest/install/ofhandler.jar", fos, new ServerStatus(){

                        @Override
                        public void success() {
                            Debug.log(Debug.EnumDebugMode.UPDATER, "Downloaded of handler https://dl.labymod.net/latest/install/ofhandler.jar");
                        }

                        @Override
                        public void failed(RequestException exception) {
                            exception.printStackTrace();
                        }

                        @Override
                        public void close() throws Exception {
                            fos.close();
                        }
                    });
                } else {
                    DownloadServerRequest.writeBytes("https://dl.labymod.net/latest/install/ofhandler.jar", fos);
                    fos.close();
                }
            }
            catch (Exception error) {
                error.printStackTrace();
            }
        }
    }

    public static void executeOfHandler(boolean installOptifine) {
        boolean isVanillaForge = !LabyModCoreMod.isForge();
        try {
            Debug.log(Debug.EnumDebugMode.ADDON, installOptifine ? (isVanillaForge ? "Installing optifine for vanillaforge" : "Uninstall optifine for vanillaforge") : (isVanillaForge ? "Installing optifine for forge" : "Uninstall optifine for forge"));
            if (isVanillaForge) {
                if (!FILE_OF_HANDLER.exists()) {
                    Debug.log(Debug.EnumDebugMode.ADDON, "OfHandler not found:" + FILE_OF_HANDLER.getAbsolutePath());
                    return;
                }
                if (Source.RUNNING_JAR == null) {
                    Debug.log(Debug.EnumDebugMode.ADDON, "Can't execute ofhandler: Running jar not found!");
                    return;
                }
                if (!Source.RUNNING_JAR.getName().endsWith(".jar")) {
                    Debug.log(Debug.EnumDebugMode.ADDON, "Can't execute ofhandler: " + Source.RUNNING_JAR.getAbsolutePath() + " is not a jar file!");
                    return;
                }
                LabyModOFAddon.executeOfHandlerDirect(installOptifine, Source.ABOUT_MC_VERSION, Source.RUNNING_JAR);
                Debug.log(Debug.EnumDebugMode.ADDON, "OfHandler executed!");
            } else if (installOptifine) {
                File optifineMods = new File(Source.FILE_MODS_FOLDER, "optifine.jar");
                File optifineTemp = new File(Source.FILE_OFHANDLER_FOLDER, "optifine.jar");
                Debug.log(Debug.EnumDebugMode.ADDON, "Copy " + optifineTemp.getAbsolutePath() + " to " + optifineMods.getAbsolutePath());
                if (optifineTemp.exists()) {
                    optifineTemp.renameTo(optifineMods);
                }
                Source.FILE_OFHANDLER_FOLDER.delete();
            } else if (OPTIFINE_FORGE != null) {
                if (!FILE_OF_HANDLER.exists()) {
                    Debug.log(Debug.EnumDebugMode.ADDON, "OfHandler not found:" + FILE_OF_HANDLER.getAbsolutePath());
                    return;
                }
                String javaHome = System.getProperty("java.home");
                String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
                ArrayList<String> arguments = new ArrayList<String>();
                arguments.add(javaBin);
                arguments.add("-jar");
                arguments.add(FILE_OF_HANDLER.getAbsolutePath());
                arguments.add("del");
                arguments.add(OPTIFINE_FORGE.getAbsolutePath());
                StringBuilder debug = new StringBuilder();
                for (String arg : arguments) {
                    debug.append(arg).append(" ");
                }
                Debug.log(Debug.EnumDebugMode.ADDON, "Execute ofhandler:" + debug.toString());
                ProcessBuilder pb = new ProcessBuilder(arguments);
                pb.start();
                Debug.log(Debug.EnumDebugMode.ADDON, "OfHandler executed!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void executeOfHandlerDirect(boolean installOptifine, String mcVersion, File runningJar) throws Exception {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(javaBin);
        arguments.add("-jar");
        arguments.add(FILE_OF_HANDLER.getAbsolutePath());
        arguments.add(String.valueOf(installOptifine));
        arguments.add(mcVersion);
        arguments.add(runningJar.getAbsolutePath());
        StringBuilder debug = new StringBuilder();
        for (String arg : arguments) {
            debug.append(arg).append(" ");
        }
        Debug.log(Debug.EnumDebugMode.ADDON, "Execute ofhandler:" + debug.toString());
        ProcessBuilder pb = new ProcessBuilder(arguments);
        pb.start();
    }

    public static void addOptifineVersion() {
        if (FILE_OF_HANDLER.getParentFile().exists()) {
            FILE_OF_HANDLER.getParentFile().delete();
        }
        if (LabyModCoreMod.isForge()) {
            File modsFolder = Source.FILE_MODS_FOLDER;
            if (!modsFolder.exists()) {
                return;
            }
            for (File mod : modsFolder.listFiles()) {
                if (!mod.getName().endsWith(".jar")) continue;
                try {
                    JarFile jarFile = new JarFile(mod);
                    if (jarFile.getJarEntry("changelog.txt") == null || jarFile.getJarEntry("buildof.txt") == null) {
                        jarFile.close();
                        continue;
                    }
                    LabyModOFAddon.addOptifineUsingJarFile(jarFile);
                    OPTIFINE_FORGE = mod;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void addOptifineByVanillaForge(String version) {
        if (FILE_OF_HANDLER.getParentFile().exists()) {
            FILE_OF_HANDLER.getParentFile().delete();
        }
        try {
            Debug.log(Debug.EnumDebugMode.ADDON, "Detected game version: " + version);
            if (version == null || version.isEmpty()) {
                Debug.log(Debug.EnumDebugMode.ADDON, "Can't check installed optifine version: version is not present!");
                return;
            }
            File runningJar = new File(LauncherDirectoryUtils.getWorkingDirectory(), "versions/" + version + "/" + version + ".jar");
            if (!runningJar.exists()) {
                Debug.log(Debug.EnumDebugMode.ADDON, "Can't check installed optifine version: running jar file " + runningJar.getAbsolutePath() + " doesn't exists!");
                return;
            }
            Source.RUNNING_JAR = runningJar;
            JarFile jarFile = new JarFile(runningJar);
            if (jarFile.getJarEntry("changelog.txt") == null || jarFile.getJarEntry("buildof.txt") == null) {
                Debug.log(Debug.EnumDebugMode.ADDON, "Optifine is not installed");
                jarFile.close();
                return;
            }
            LabyModOFAddon.addOptifineUsingJarFile(jarFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addOptifineUsingJarFile(JarFile jarFile) throws Exception {
        String fileContent = null;
        String changeLogContents = LabyModOFAddon.getStringByInputStream(jarFile.getInputStream(jarFile.getJarEntry("changelog.txt")));
        changeLogContents = changeLogContents.replace("\r", "");
        for (String line : changeLogContents.split("\n")) {
            String version;
            if (!line.startsWith("OptiFine ") || (version = line.split("OptiFine ")[1].split("_")[0]) == null || version.isEmpty() || !OPTIFINE_VERSIONS.containsKey(version)) continue;
            fileContent = "{\"uuid\":\"" + OPTIFINE_VERSIONS.get(version) + "\",\"name\":\"" + line + "\"}";
            break;
        }
        jarFile.close();
        if (fileContent == null) {
            return;
        }
        JsonObject object = (JsonObject)parser.parse(fileContent);
        String name = null;
        UUID uuid = null;
        if (!object.has("name")) {
            if (jarFile != null) {
                Debug.log(Debug.EnumDebugMode.ADDON, "Name not set in " + jarFile.getName());
                jarFile.close();
            }
            return;
        }
        name = object.get("name").getAsString();
        if (!object.has("uuid")) {
            if (jarFile != null) {
                Debug.log(Debug.EnumDebugMode.ADDON, "UUID not set in " + name);
                jarFile.close();
            }
            return;
        }
        uuid = UUID.fromString(object.get("uuid").getAsString());
        Debug.log(Debug.EnumDebugMode.ADDON, "Optifine is installed!");
        LabyModOFAddon ofAddon = new LabyModOFAddon();
        ofAddon.init(name, uuid);
        AddonLoader.getAddons().add(ofAddon);
    }

    public static String getStringByInputStream(InputStream inputStream) {
        StringBuilder sb = new StringBuilder();
        try {
            int ch;
            while ((ch = inputStream.read()) != -1) {
                sb.append((char)ch);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    @Override
    public void loadConfig() {
    }

    @Override
    protected void fillSettings(List<SettingsElement> subSettings) {
    }
}

