/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.output.StringBuilderWriter;

public final class IOUtil {
    public static final int EOF = -1;
    public static final int DEFAULT_BUFFER_SIZE = 1024;

    public static String toString(InputStream inputStream) throws IOException {
        return IOUtil.toString(inputStream, StandardCharsets.UTF_8);
    }

    public static String toString(InputStream inputStream, Charset encoding) throws IOException {
        try (StringBuilderWriter stringBuilderWriter = new StringBuilderWriter();){
            IOUtil.copy(inputStream, (Writer)stringBuilderWriter, encoding);
            String string = stringBuilderWriter.toString();
            return string;
        }
    }

    public static void copy(InputStream input, Writer output, Charset inputEncoding) throws IOException {
        try (InputStreamReader inputStreamReader = new InputStreamReader(input, inputEncoding);){
            IOUtil.copy(inputStreamReader, output);
        }
    }

    public static int copy(Reader input, Writer output) throws IOException {
        long count = IOUtil.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(Reader input, Writer output) throws IOException {
        return IOUtil.copyLarge(input, output, new char[1024]);
    }

    public static long copyLarge(Reader input, Writer output, char[] buffer) throws IOException {
        int n;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static void write(byte[] data, OutputStream outputStream) throws IOException {
        if (data == null) {
            return;
        }
        outputStream.write(data);
    }

    public static void write(byte[] data, Writer output, Charset encoding) throws IOException {
        if (data == null) {
            return;
        }
        output.write(new String(data, encoding));
    }

    public static void write(CharSequence data, OutputStream output, Charset encoding) throws IOException {
        if (data == null) {
            return;
        }
        IOUtil.write(data.toString(), output, encoding);
    }

    public static void write(String data, OutputStream output, Charset encoding) throws IOException {
        if (data == null) {
            return;
        }
        output.write(data.getBytes(encoding));
    }

    public static void writeBytes(InputStream inputStream, OutputStream outputStream) throws IOException {
        int readable;
        byte[] data = new byte[1024];
        while ((readable = inputStream.read(data, 0, data.length)) != -1) {
            outputStream.write(data, 0, readable);
        }
        outputStream.flush();
    }
}

