/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.storage.loader.microsoft.model.msa.token;

import com.google.gson.annotations.SerializedName;
import net.labymod.accountmanager.authentication.microsoft.MicrosoftAuthentication;
import net.labymod.accountmanager.storage.account.TokenAccessor;
import net.labymod.accountmanager.storage.loader.microsoft.model.msa.token.DisplayClaims;

public class TokenData
implements TokenAccessor {
    @SerializedName(value="Token")
    public String token;
    @SerializedName(value="NotAfter")
    public String notAfter;
    @SerializedName(value="IssueInstant")
    public String issueInstant;
    @SerializedName(value="ClientAttested")
    public boolean clientAttested;
    @SerializedName(value="DisplayClaims")
    public DisplayClaims displayClaims;

    public TokenData(String token, String notAfter, String issueInstant, boolean clientAttested, DisplayClaims displayClaims) {
        this.token = token;
        this.notAfter = notAfter;
        this.issueInstant = issueInstant;
        this.clientAttested = clientAttested;
        this.displayClaims = displayClaims;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public long getExpiresAt() {
        try {
            return MicrosoftAuthentication.DATE_FORMAT_EXACT.parse(this.notAfter).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return System.currentTimeMillis();
        }
    }
}

