/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.storage.loader.microsoft.model.msa;

import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import java.util.HashMap;
import java.util.Map;
import net.labymod.accountmanager.storage.loader.microsoft.model.msa.XALType;

public class MSACredentials {
    public static final Gson GSON = new Gson();
    public String activeUserXuid;
    public Map<String, LinkedTreeMap<String, String>> credentials = new HashMap<String, LinkedTreeMap<String, String>>();

    public <T> T get(String xuid, XALType key, Class<T> clazz) {
        return this.get(xuid, key.getKey(), clazz);
    }

    public <T> T get(String xuid, String key, Class<T> clazz) {
        LinkedTreeMap<String, String> userCredentials = this.credentials.get(xuid);
        if (userCredentials == null) {
            return null;
        }
        String json = (String)userCredentials.get((Object)key);
        if (json == null) {
            return null;
        }
        return (T)GSON.fromJson(json, clazz);
    }

    public <T> void put(String xuid, XALType key, T object) {
        this.put(xuid, key.getKey(), object);
    }

    public <T> void put(String xuid, String key, T object) {
        LinkedTreeMap userCredentials = this.credentials.get(xuid);
        if (userCredentials == null) {
            userCredentials = new LinkedTreeMap();
            this.credentials.put(xuid, (LinkedTreeMap<String, String>)userCredentials);
        }
        userCredentials.put((Object)key, (Object)GSON.toJson(object));
    }
}

