/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.storage.loader.microsoft.model;

import java.util.UUID;
import net.labymod.accountmanager.storage.StorageType;
import net.labymod.accountmanager.storage.account.AbstractAccount;
import net.labymod.accountmanager.storage.account.Account;
import net.labymod.accountmanager.storage.loader.microsoft.model.MinecraftProfile;
import net.labymod.accountmanager.utils.UUIDUtil;

public class LauncherAccount
extends AbstractAccount {
    public transient String accessToken;
    public String type;
    public MinecraftProfile minecraftProfile;
    public String accessTokenExpiresAt;
    public String avatar;
    private transient StorageType storageType = StorageType.MICROSOFT;

    @Override
    public boolean isMicrosoft() {
        return this.type != null && this.type.equals("Xbox");
    }

    @Override
    public UUID getUUID() {
        return this.minecraftProfile == null || this.minecraftProfile.id == null ? null : UUIDUtil.getUUIDFromCompactUUID(this.minecraftProfile.id);
    }

    @Override
    public boolean isPremium() {
        return this.accessToken != null && this.accessToken.length() > 10;
    }

    @Override
    public boolean isAccessTokenExpired() {
        this.setAccessTokenExpiresAt(this.accessTokenExpiresAt);
        return super.isAccessTokenExpired();
    }

    @Override
    public String getAvatarImage() {
        return this.avatar;
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    @Override
    public String getUsername() {
        return this.minecraftProfile.name;
    }

    @Override
    public boolean isDemo() {
        return this.minecraftProfile == null || this.minecraftProfile.id == null;
    }

    @Override
    public StorageType getStorageType() {
        return this.storageType;
    }

    public void setStorageType(StorageType storageType) {
        this.storageType = storageType;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Account) {
            return ((Account)obj).getUUID().equals(this.getUUID());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getUUID().hashCode();
    }
}

