/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.storage.loader.java;

import com.google.gson.internal.LinkedTreeMap;
import java.io.File;
import java.util.Collection;
import net.labymod.accountmanager.storage.StorageType;
import net.labymod.accountmanager.storage.account.Account;
import net.labymod.accountmanager.storage.loader.JsonStorageImpl;
import net.labymod.accountmanager.storage.loader.java.model.AuthenticationDatabase;
import net.labymod.accountmanager.storage.loader.java.model.LauncherProfiles;

public class JavaProfileLauncherStorage
extends JsonStorageImpl<LauncherProfiles, AuthenticationDatabase> {
    private final File minecraftDirectory;
    private LauncherProfiles storage;

    public JavaProfileLauncherStorage(File minecraftDirectory) {
        this.minecraftDirectory = minecraftDirectory;
    }

    @Override
    public File getFile() {
        return new File(this.minecraftDirectory, "launcher_profiles.json");
    }

    @Override
    protected Class<?> onJsonObjectClass() {
        return LauncherProfiles.class;
    }

    @Override
    public boolean isLoaded() {
        return this.storage != null && this.storage.authenticationDatabase != null;
    }

    @Override
    protected LauncherProfiles getStorage() {
        return this.storage;
    }

    @Override
    protected void onStorageLoaded(LauncherProfiles storage) {
        this.storage = storage;
    }

    @Override
    public Collection<AuthenticationDatabase> getAccounts() {
        return this.storage.authenticationDatabase.values();
    }

    @Override
    public String getClientToken() {
        return this.storage.clientToken;
    }

    @Override
    public StorageType getType() {
        return StorageType.JAVA;
    }

    @Override
    public Account getActiveAccount() {
        if (this.storage.selectedUser == null) {
            return null;
        }
        String localId = null;
        if (this.storage.selectedUser instanceof String) {
            localId = (String)this.storage.selectedUser;
        } else if (this.storage.selectedUser instanceof LinkedTreeMap) {
            LinkedTreeMap selectedUser = (LinkedTreeMap)this.storage.selectedUser;
            localId = (String)selectedUser.getOrDefault((Object)"account", null);
        }
        return localId == null ? null : (Account)this.storage.authenticationDatabase.get(localId);
    }
}

