/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.storage.loader.external.model.token;

import com.google.gson.annotations.SerializedName;
import net.labymod.accountmanager.authentication.microsoft.model.MicrosoftAccountResult;
import net.labymod.accountmanager.authentication.microsoft.model.oauth.OAuthResponse;
import net.labymod.accountmanager.storage.loader.external.model.token.Token;
import net.labymod.accountmanager.storage.loader.microsoft.model.msa.token.TokenData;
import net.labymod.accountmanager.utils.TokenPatcher;

public class TokenChain {
    @SerializedName(value="microsoft")
    private final Token microsoftToken = new Token();
    @SerializedName(value="xbl")
    private final Token xblToken = new Token();
    @SerializedName(value="xsts")
    private final Token xstsToken = new Token();

    public void update(MicrosoftAccountResult result) {
        OAuthResponse microsoft = result.getOAuth();
        this.microsoftToken.update(microsoft);
        this.microsoftToken.setData("refresh_token", microsoft.refreshToken);
        this.xblToken.update(result.getXblAuth());
        TokenData xsts = result.getMinecraftScope();
        this.xstsToken.update(xsts);
        this.xstsToken.setData("user_hash", xsts.displayClaims.xui[0].uhs);
    }

    public Token getMicrosoftToken() {
        return this.microsoftToken;
    }

    public Token getXblToken() {
        return this.xblToken;
    }

    public Token getXstsToken() {
        return this.xstsToken;
    }

    public boolean isEmpty() {
        return this.microsoftToken.getToken() == null;
    }

    public void patch(TokenPatcher patcher) throws Exception {
        this.microsoftToken.patch(patcher);
        this.xblToken.patch(patcher);
        this.xstsToken.patch(patcher);
    }
}

