/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.storage.loader.external;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.Collection;
import java.util.function.Consumer;
import net.labymod.accountmanager.storage.StorageType;
import net.labymod.accountmanager.storage.account.Account;
import net.labymod.accountmanager.storage.account.AccountSessionState;
import net.labymod.accountmanager.storage.credentials.CredentialsAccessor;
import net.labymod.accountmanager.storage.loader.EncryptedJsonStorageImpl;
import net.labymod.accountmanager.storage.loader.external.model.ExternalAccount;
import net.labymod.accountmanager.storage.loader.external.model.ExternalAccounts;
import net.labymod.accountmanager.storage.loader.external.model.ExternalMicrosoftAccount;
import net.labymod.accountmanager.utils.TokenPatcher;

public class ExternalAccountStorage
extends EncryptedJsonStorageImpl<ExternalAccounts, ExternalAccount> {
    private final File file;
    private ExternalAccounts storage = new ExternalAccounts();

    public ExternalAccountStorage(File file, CredentialsAccessor credentialsAccessor) {
        super(credentialsAccessor);
        this.file = file;
    }

    @Override
    protected void registerTypeAdapters(GsonBuilder builder) {
        Gson gson = new Gson();
        builder.registerTypeAdapter(ExternalAccount.class, (json, type, context) -> {
            JsonObject object = json.getAsJsonObject();
            if (object.has("refresh_token") || object.has("tokens")) {
                type = ExternalMicrosoftAccount.class;
            }
            return (ExternalAccount)gson.fromJson(json, type);
        });
        builder.registerTypeAdapter(ExternalAccount.class, (account, type, context) -> gson.toJsonTree(account));
    }

    @Override
    public String getClientToken() {
        return this.storage.clientToken;
    }

    public void addAccount(ExternalAccount account) {
        this.storage.accounts.put(account.getUUID(), account);
    }

    public void removeAccount(ExternalAccount account) {
        this.storage.accounts.remove(account.getUUID());
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isLoaded() {
        return this.storage != null && this.storage.accounts != null;
    }

    @Override
    public Collection<ExternalAccount> getAccounts() {
        return this.storage.accounts.values();
    }

    @Override
    public Account getActiveAccount() {
        return null;
    }

    @Override
    public StorageType getType() {
        return StorageType.EXTERNAL;
    }

    @Override
    protected Class<?> onJsonObjectClass() {
        return ExternalAccounts.class;
    }

    @Override
    protected void onStorageLoaded(ExternalAccounts storage) {
        this.storage = storage == null ? new ExternalAccounts() : storage;
        super.onStorageLoaded(storage);
    }

    @Override
    protected void patchTokens(ExternalAccount account, TokenPatcher patcher) throws Exception {
        account.patchTokens(patcher);
    }

    @Override
    protected ExternalAccounts getStorage() {
        return this.storage;
    }

    @Override
    public void refreshAccounts(Consumer<Account> callback) {
        for (ExternalAccount account : this.getAccounts()) {
            this.refreshAccount(account);
            callback.accept(account);
        }
    }

    public void refreshAccount(ExternalAccount account) {
        try {
            if (account.isPremium()) {
                if (account.isMicrosoft()) {
                    if (account.isAccessTokenExpired()) {
                        account.setSessionState(AccountSessionState.REFRESHING);
                        this.authentication.refreshMicrosoftSession((ExternalMicrosoftAccount)account);
                    }
                } else if (!this.authentication.isAccessTokenValid(account)) {
                    account.setSessionState(AccountSessionState.REFRESHING);
                    this.authentication.refreshMojangSession(account);
                }
                account.setSessionState(AccountSessionState.VALID);
            } else {
                account.setSessionState(AccountSessionState.OFFLINE);
            }
        }
        catch (Throwable e) {
            account.setSessionState(AccountSessionState.EXPIRED);
        }
    }
}

