/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.storage.credentials.windows;

import java.util.HashMap;
import java.util.Map;

public enum CredentialType {
    CRED_TYPE_GENERIC(1),
    CRED_TYPE_DOMAIN_PASSWORD(2),
    CRED_TYPE_DOMAIN_CERTIFICATE(3),
    CRED_TYPE_DOMAIN_VISIBLE_PASSWORD(4),
    CRED_TYPE_GENERIC_CERTIFICATE(5),
    CRED_TYPE_DOMAIN_EXTENDED(6),
    CRED_TYPE_MAXIMUM(7);

    private static final Map<Integer, CredentialType> map;
    private final int code;

    private CredentialType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static CredentialType fromCode(int code) {
        if (code > 7) {
            throw new RuntimeException("unknown CredentialType");
        }
        return map.get(code);
    }

    static {
        map = new HashMap<Integer, CredentialType>();
        for (CredentialType c2 : CredentialType.values()) {
            map.put(c2.code, c2);
        }
    }
}

