/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.authentication.microsoft.oauth;

import java.awt.Desktop;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.labymod.accountmanager.authentication.microsoft.MicrosoftAuthentication;

public class OAuthServer {
    private static final String CO_BRAND_ID = "8058f65d-ce06-4c30-9559-473c9275a65d";
    private static final String URL_OAUTH_LOGIN = String.format("https://login.live.com/oauth20_authorize.srf?client_id=%s&response_type=code&redirect_uri=%s&scope=%s&cobrandid=%s&prompt=select_account", "27843883-6e3b-42cb-9e51-4f55a700601e", MicrosoftAuthentication.REDIRECT_URL, "XboxLive.signin%20offline_access", "8058f65d-ce06-4c30-9559-473c9275a65d");
    private final ServerSocket serverSocket = new ServerSocket(8086);
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public void listenForCodeAsync(Consumer<String> callback) {
        this.executor.execute(() -> callback.accept(this.listenForCode()));
    }

    public String listenForCode() {
        while (this.serverSocket.isBound()) {
            try {
                Socket socket = this.serverSocket.accept();
                Scanner scanner = new Scanner(socket.getInputStream());
                String path = scanner.nextLine().split(" ")[1];
                PrintWriter printWriter = new PrintWriter(socket.getOutputStream());
                printWriter.write("HTTP/1.0 200 OK\r\n");
                printWriter.write("Content-Type: html; charset=UTF-8\r\n");
                printWriter.write("\r\n");
                printWriter.write("You can close this window now");
                printWriter.flush();
                printWriter.close();
                scanner.close();
                socket.close();
                this.close();
                if (path.contains("=") && path.contains("?code=")) {
                    return path.substring(path.indexOf("=") + 1);
                }
                if (!path.contains("?error=")) continue;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
        return null;
    }

    public void close() {
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public URL getUrl() throws IOException {
        return new URL(URL_OAUTH_LOGIN);
    }

    public static void main(String[] args) throws Exception {
        OAuthServer server = new OAuthServer();
        Desktop.getDesktop().browse(server.getUrl().toURI());
        System.out.println(server.listenForCode());
        server.close();
    }
}

