/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.authentication;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.labymod.accountmanager.authentication.AccountAuthentication;
import net.labymod.accountmanager.storage.account.Account;
import net.labymod.accountmanager.storage.loader.external.model.ExternalAccount;
import net.labymod.accountmanager.storage.loader.external.model.ExternalMicrosoftAccount;

public class AsyncAccountAuthentication
extends AccountAuthentication {
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public AsyncAccountAuthentication(String clientToken) {
        super(clientToken);
    }

    public void authenticateMojangAsync(String username, String password, Consumer<ExternalAccount> successCallback, Consumer<Exception> exceptionConsumer) {
        this.executor.execute(() -> {
            try {
                successCallback.accept(this.authenticateMojang(username, password));
            }
            catch (Exception e) {
                exceptionConsumer.accept(e);
            }
        });
    }

    public void authenticateMicrosoftAsync(String code, Consumer<ExternalAccount> successCallback, Consumer<Exception> exceptionConsumer) {
        this.executor.execute(() -> {
            try {
                successCallback.accept(this.authenticateMicrosoft(code));
            }
            catch (Exception e) {
                exceptionConsumer.accept(e);
            }
        });
    }

    public void refreshMojangSessionAsync(ExternalAccount account, Consumer<Exception> exceptionConsumer) {
        this.executor.execute(() -> {
            try {
                this.refreshMojangSession(account);
            }
            catch (Exception e) {
                exceptionConsumer.accept(e);
            }
        });
    }

    public void refreshMicrosoftSessionAsync(ExternalMicrosoftAccount account, Consumer<Exception> exceptionConsumer) {
        this.executor.execute(() -> {
            try {
                this.refreshMicrosoftSession(account);
            }
            catch (Exception e) {
                exceptionConsumer.accept(e);
            }
        });
    }

    public void refreshSessionsStateAsync(Account account, Consumer<Exception> exceptionConsumer) {
        this.executor.execute(() -> {
            try {
                this.updateMojangSessionState(account);
            }
            catch (Exception e) {
                exceptionConsumer.accept(e);
            }
        });
    }
}

