/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.authentication;

import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.UserAuthentication;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication;
import java.lang.reflect.Method;
import java.net.Proxy;
import java.util.HashMap;
import java.util.UUID;
import net.labymod.accountmanager.authentication.microsoft.MicrosoftAuthentication;
import net.labymod.accountmanager.authentication.microsoft.model.MicrosoftAccountResult;
import net.labymod.accountmanager.authentication.microsoft.model.minecraft.LoginResponse;
import net.labymod.accountmanager.authentication.microsoft.model.minecraft.ProfileResponse;
import net.labymod.accountmanager.storage.account.Account;
import net.labymod.accountmanager.storage.account.AccountSessionState;
import net.labymod.accountmanager.storage.loader.external.model.ExternalAccount;
import net.labymod.accountmanager.storage.loader.external.model.ExternalMicrosoftAccount;
import net.labymod.accountmanager.storage.loader.external.model.token.Token;
import net.labymod.accountmanager.storage.loader.external.model.token.TokenChain;
import net.labymod.accountmanager.storage.loader.microsoft.model.msa.token.TokenData;
import net.labymod.accountmanager.utils.UUIDUtil;

public class AccountAuthentication {
    private final YggdrasilAuthenticationService mojangService;
    private final MicrosoftAuthentication microsoftService;
    private Method checkTokenValidity;

    public AccountAuthentication(String clientToken) {
        this.mojangService = new YggdrasilAuthenticationService(Proxy.NO_PROXY, clientToken);
        this.microsoftService = new MicrosoftAuthentication();
        try {
            this.checkTokenValidity = YggdrasilUserAuthentication.class.getDeclaredMethod("checkTokenValidity", new Class[0]);
            this.checkTokenValidity.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ExternalAccount authenticateMojang(String username, String password) throws AuthenticationException {
        UserAuthentication authentication = this.mojangService.createUserAuthentication(Agent.MINECRAFT);
        authentication.setUsername(username);
        authentication.setPassword(password);
        authentication.logIn();
        if (authentication.canPlayOnline()) {
            GameProfile profile = authentication.getSelectedProfile();
            ExternalAccount account = new ExternalAccount(profile.getId(), profile.getName(), authentication.getAuthenticatedToken());
            account.setAccessTokenExpiresAt(-1L);
            account.setSessionState(AccountSessionState.VALID);
            return account;
        }
        throw new AuthenticationException("Can't play online");
    }

    public void refreshMojangSession(ExternalAccount account) throws AuthenticationException {
        UserAuthentication authentication = this.mojangService.createUserAuthentication(Agent.MINECRAFT);
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put("username", account.getUsername());
        credentials.put("accessToken", account.getAccessToken());
        authentication.loadFromStorage(credentials);
        authentication.logIn();
        account.setAccessToken(authentication.getAuthenticatedToken());
        account.setUsername(authentication.getSelectedProfile().getName());
        account.setAccessTokenExpiresAt(-1L);
        account.setSessionState(AccountSessionState.VALID);
    }

    public ExternalMicrosoftAccount authenticateMicrosoft(String code) throws Exception {
        MicrosoftAccountResult result = this.microsoftService.authenticate(code);
        ProfileResponse profile = result.getMinecraftProfile();
        if (profile.id == null) {
            throw new RuntimeException("Minecraft is not purchased on this Microsoft account");
        }
        UUID uuid = UUIDUtil.getUUIDFromCompactUUID(profile.id);
        String username = profile.name;
        ExternalMicrosoftAccount account = new ExternalMicrosoftAccount(uuid, username, result);
        account.setSessionState(AccountSessionState.VALID);
        return account;
    }

    public void refreshMicrosoftSession(ExternalMicrosoftAccount account) throws Exception {
        LoginResponse minecraftResult;
        TokenChain chain = account.getTokens();
        Token xsts = chain.getXstsToken();
        Token xbl = chain.getXblToken();
        Token microsoft = chain.getMicrosoftToken();
        if (xsts.hasExpired()) {
            if (xbl.hasExpired()) {
                if (microsoft.hasExpired()) {
                    String refreshToken = chain.getMicrosoftToken().getData("refresh_token");
                    MicrosoftAccountResult result = this.microsoftService.refresh(refreshToken);
                    if (result.getMinecraftProfile().id == null) {
                        throw new RuntimeException("Minecraft is not purchased on this Microsoft account");
                    }
                    account.updateProfile(result);
                    account.setSessionState(AccountSessionState.VALID);
                    return;
                }
                TokenData xblResult = this.microsoftService.getXBL(microsoft.getToken());
                xbl.update(xblResult);
            }
            TokenData xstsResult = this.microsoftService.getXSTS(xbl.getToken(), "rp://api.minecraftservices.com/");
            if (xstsResult.notAfter == null) {
                throw new RuntimeException("Can't refresh XSTS token because XBL token is invalid");
            }
            xsts.update(xstsResult);
            xsts.setData("user_hash", xstsResult.displayClaims.xui[0].uhs);
        }
        if ((minecraftResult = this.microsoftService.getMinecraftAccess(xsts.getData("user_hash"), xsts.getToken())).getToken() == null) {
            throw new RuntimeException("Can't refresh Minecraft token because XSTS token is invalid");
        }
        account.setAccessToken(minecraftResult.getToken());
        account.setAccessTokenExpiresAt(minecraftResult.getExpiresAt());
    }

    public void updateMojangSessionState(Account account) throws Exception {
        boolean isValid = this.isAccessTokenValid(account);
        account.setSessionState(isValid ? AccountSessionState.VALID : AccountSessionState.EXPIRED);
    }

    public boolean isAccessTokenValid(Account account) throws Exception {
        if (account.isMicrosoft()) {
            throw new RuntimeException("Can't validate access token of a Microsoft account");
        }
        UserAuthentication authentication = this.mojangService.createUserAuthentication(Agent.MINECRAFT);
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put("accessToken", account.getAccessToken());
        authentication.loadFromStorage(credentials);
        return this.checkTokenValidity != null && (Boolean)this.checkTokenValidity.invoke((Object)authentication, new Object[0]) != false;
    }

    public MicrosoftAuthentication getMicrosoftService() {
        return this.microsoftService;
    }
}

