/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager;

import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.labymod.accountmanager.AccountManager;
import net.labymod.accountmanager.storage.account.Account;
import net.labymod.accountmanager.storage.credentials.CredentialsAccessor;

public class AsyncAccountManager
extends AccountManager {
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public AsyncAccountManager(File file) {
        super(file);
    }

    public AsyncAccountManager(File file, CredentialsAccessor accessor, File minecraftDirectory) {
        super(file, accessor, minecraftDirectory);
    }

    public void loadAsync(Runnable ... callback) {
        this.executor.execute(() -> {
            try {
                this.load();
                for (Runnable runnable : callback) {
                    runnable.run();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void refreshExternalSessionsAsync(Consumer<Account> accountCallback, Runnable ... callback) {
        this.executor.execute(() -> {
            try {
                this.refreshExternalSessions(accountCallback);
                for (Runnable runnable : callback) {
                    runnable.run();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void refreshLauncherSessionsAsync(Consumer<Account> accountCallback, Runnable ... callback) {
        this.executor.execute(() -> {
            try {
                this.refreshLauncherSessions(accountCallback);
                for (Runnable runnable : callback) {
                    runnable.run();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void saveAsync(Runnable ... callback) {
        this.executor.execute(() -> {
            try {
                this.save();
                for (Runnable runnable : callback) {
                    runnable.run();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

