/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.vanillaforge.editors;

import net.labymod.vanillaforge.ClassEditor;
import net.labymod.vanillaforge.LabyModTweaker;
import net.labymod.vanillaforge.Names;
import net.minecraftforge.client.event.GuiOpenEvent;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class MinecraftEditor
extends ClassEditor {
    private static final String modClassName = "net/labymod/main/LabyMod";
    private static final String modClassInit = "init";

    public MinecraftEditor() {
        super(ClassEditor.ClassEditorType.CLASS_NODE);
    }

    @Override
    public void accept(String name, ClassNode node) {
        for (Object methodObj : node.methods) {
            MethodNode method = (MethodNode)methodObj;
            if (method.name.equals(Names.START_MINECRAFT.getName()) && method.desc.equals("()V")) {
                AbstractInsnNode postStartup = null;
                for (AbstractInsnNode instruction : method.instructions.toArray()) {
                    Object cst;
                    if (instruction.getOpcode() != 18 || !(cst = ((LdcInsnNode)instruction).cst).equals("Post startup")) continue;
                    postStartup = instruction.getPrevious();
                    break;
                }
                if (postStartup == null) continue;
                InsnList insertList = new InsnList();
                insertList.add((AbstractInsnNode)new TypeInsnNode(187, "LabyMod"));
                insertList.add((AbstractInsnNode)new InsnNode(89));
                insertList.add((AbstractInsnNode)new MethodInsnNode(183, "LabyMod", "<init>", "()V", false));
                insertList.add((AbstractInsnNode)new MethodInsnNode(182, "LabyMod", modClassInit, "()V", false));
                insertList.add((AbstractInsnNode)new TypeInsnNode(187, modClassName));
                insertList.add((AbstractInsnNode)new InsnNode(89));
                insertList.add((AbstractInsnNode)new MethodInsnNode(183, modClassName, "<init>", "()V", false));
                String fmlInitializationEventName = "net/minecraftforge/fml/common/event/FMLInitializationEvent";
                insertList.add((AbstractInsnNode)new TypeInsnNode(187, fmlInitializationEventName));
                insertList.add((AbstractInsnNode)new InsnNode(89));
                insertList.add((AbstractInsnNode)new MethodInsnNode(183, fmlInitializationEventName, "<init>", "()V", false));
                insertList.add((AbstractInsnNode)new MethodInsnNode(182, modClassName, modClassInit, "(L" + fmlInitializationEventName + ";)V", false));
                insertList.add((AbstractInsnNode)new LdcInsnNode((Object)LabyModTweaker.getVersionStatic()));
                insertList.add((AbstractInsnNode)new MethodInsnNode(184, "net/labymod/addon/LabyModOFAddon", "addOptifineByVanillaForge", "(Ljava/lang/String;)V", false));
                method.instructions.insertBefore(postStartup, insertList);
                continue;
            }
            if (method.name.equals(Names.RUN_TICK.getName()) && method.desc.equals("()V")) {
                AbstractInsnNode instruction;
                AbstractInsnNode endSectionNode = null;
                int eventKeyStateCount = 0;
                boolean nextKeyboardJumpInstruction = false;
                LabelNode insertLabelNode = null;
                instruction = method.instructions.toArray();
                int cst = ((AbstractInsnNode[])instruction).length;
                for (int i = 0; i < cst; ++i) {
                    AbstractInsnNode prevNode;
                    AbstractInsnNode instruction2 = instruction[i];
                    if (instruction2.getOpcode() == 184) {
                        MethodInsnNode methodInsnNode = (MethodInsnNode)instruction2;
                        if (methodInsnNode.name.equals("getEventKeyState") && methodInsnNode.owner.equals("org/lwjgl/input/Keyboard")) {
                            if (++eventKeyStateCount != 3) continue;
                            nextKeyboardJumpInstruction = true;
                            continue;
                        }
                        if (!methodInsnNode.name.equals("next") || !methodInsnNode.owner.equals("org/lwjgl/input/Mouse")) continue;
                        methodInsnNode.name = "mouseNext";
                        methodInsnNode.owner = "EventCaller";
                        continue;
                    }
                    if (instruction2.getOpcode() == 153 && nextKeyboardJumpInstruction) {
                        nextKeyboardJumpInstruction = false;
                        insertLabelNode = ((JumpInsnNode)instruction2).label;
                        continue;
                    }
                    if (instruction2.getOpcode() != 182) continue;
                    MethodInsnNode methodNode = (MethodInsnNode)instruction2;
                    if (!methodNode.name.equals(Names.PROFILER_END_SECTION.getName()) || !methodNode.owner.equals(Names.PROFILER.getName()) || (prevNode = instruction2.getPrevious()) == null || !((FieldInsnNode)prevNode).name.equals(Names.MINECRAFT_MC_PROFILER.getName())) continue;
                    endSectionNode = instruction2;
                }
                if (endSectionNode == null || insertLabelNode == null) continue;
                InsnList insertList = new InsnList();
                insertList.add((AbstractInsnNode)new MethodInsnNode(184, "EventCaller", "instance", "()LEventCaller;", false));
                insertList.add((AbstractInsnNode)new MethodInsnNode(182, "EventCaller", "callTick", "()V", false));
                method.instructions.insertBefore(endSectionNode.getPrevious().getPrevious(), insertList);
                InsnList keyInsertList = new InsnList();
                keyInsertList.add((AbstractInsnNode)new MethodInsnNode(184, "EventCaller", "instance", "()LEventCaller;", false));
                keyInsertList.add((AbstractInsnNode)new MethodInsnNode(182, "EventCaller", "callKeyInput", "()V", false));
                method.instructions.insert((AbstractInsnNode)insertLabelNode, keyInsertList);
                continue;
            }
            if (method.name.equals(Names.DISPLAY_GUI_SCREEN.getName()) && method.desc.equals("(L" + Names.GUI_SCREEN.getName() + ";)V")) {
                AbstractInsnNode instanceOfNode = null;
                for (AbstractInsnNode instruction : method.instructions.toArray()) {
                    if (instruction.getOpcode() != 193 || !((TypeInsnNode)instruction).desc.equals(Names.GUI_MAIN_MENU.getName())) continue;
                    instanceOfNode = instruction;
                    break;
                }
                if (instanceOfNode == null) continue;
                InsnList insertList = new InsnList();
                insertList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                insertList.add((AbstractInsnNode)new FieldInsnNode(180, Names.MINECRAFT_CLASS.getName(), Names.CURRENT_SCREEN.getName(), "L" + Names.GUI_SCREEN.getName() + ";"));
                insertList.add((AbstractInsnNode)new VarInsnNode(58, 4));
                String guiOpenEvent = Type.getInternalName(GuiOpenEvent.class);
                insertList.add((AbstractInsnNode)new TypeInsnNode(187, guiOpenEvent));
                insertList.add((AbstractInsnNode)new InsnNode(89));
                insertList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                insertList.add((AbstractInsnNode)new MethodInsnNode(183, guiOpenEvent, "<init>", "(L" + Names.GUI_SCREEN.getName() + ";)V", false));
                insertList.add((AbstractInsnNode)new VarInsnNode(58, 5));
                insertList.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraftforge/common/MinecraftForge", "EVENT_BUS", "Lnet/minecraftforge/fml/common/eventhandler/EventBus;"));
                insertList.add((AbstractInsnNode)new VarInsnNode(25, 5));
                insertList.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraftforge/fml/common/eventhandler/EventBus", "post", "(Lnet/minecraftforge/fml/common/eventhandler/Event;)Z", false));
                LabelNode label = new LabelNode();
                insertList.add((AbstractInsnNode)new JumpInsnNode(153, label));
                insertList.add((AbstractInsnNode)new InsnNode(177));
                insertList.add((AbstractInsnNode)label);
                insertList.add((AbstractInsnNode)new VarInsnNode(25, 5));
                insertList.add((AbstractInsnNode)new FieldInsnNode(180, guiOpenEvent, "gui", "L" + Names.GUI_SCREEN.getName() + ";"));
                insertList.add((AbstractInsnNode)new VarInsnNode(58, 1));
                method.instructions.insertBefore(instanceOfNode.getPrevious(), insertList);
                continue;
            }
            if (!method.name.equals(Names.RUN_GAME_LOOP.getName()) || !method.desc.equals("()V")) continue;
            AbstractInsnNode gameRendererInstruction = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (!(instruction instanceof LdcInsnNode) || !((LdcInsnNode)instruction).cst.equals("gameRenderer")) continue;
                gameRendererInstruction = instruction;
                break;
            }
            if (gameRendererInstruction == null) continue;
            InsnList insertList = new InsnList();
            insertList.add((AbstractInsnNode)new MethodInsnNode(184, "EventCaller", "instance", "()LEventCaller;", false));
            insertList.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insertList.add((AbstractInsnNode)new FieldInsnNode(180, Names.MINECRAFT_CLASS.getName(), Names.TIMER_FIELD.getName(), "L" + Names.TIMER_CLASS.getName() + ";"));
            insertList.add((AbstractInsnNode)new FieldInsnNode(180, Names.TIMER_CLASS.getName(), Names.TIMER_RENDER_PARTIAL_TICKS.getName(), "F"));
            insertList.add((AbstractInsnNode)new MethodInsnNode(182, "EventCaller", "callRenderTick", "(F)V", false));
            method.instructions.insert(gameRendererInstruction.getNext(), insertList);
        }
    }
}

