/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.vanillaforge;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.labymod.vanillaforge.LabyModTransformer;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class LabyModTweaker
implements ITweaker {
    private static LabyModTweaker instance;
    private LaunchClassLoader launchClassLoader;
    public static File gameDirectory;
    private static String launchedProfile;
    private List<String> arguments;
    private File assetsDirectory;
    private String version;
    private boolean obfuscated;
    private static final String coreModClass = "net.labymod.core.asm.LabyModCoreMod";

    public void acceptOptions(List<String> arguments, File gameDirectory, File assetsDirectory, String version) {
        instance = this;
        launchedProfile = version;
        this.arguments = arguments;
        LabyModTweaker.gameDirectory = gameDirectory;
        this.assetsDirectory = assetsDirectory;
        boolean nextArgumentIsVersion = false;
        for (String arg : arguments) {
            if (nextArgumentIsVersion) {
                this.version = arg;
                break;
            }
            if (!arg.equals("--assetIndex")) continue;
            nextArgumentIsVersion = true;
        }
        if (this.version == null) {
            this.version = version;
        }
        System.out.println("[LabyMod-Vanilla] Detected version: " + this.version);
    }

    public void injectIntoClassLoader(LaunchClassLoader launchClassLoader) {
        this.launchClassLoader = launchClassLoader;
        try {
            Class labyModCoreModClass = launchClassLoader.loadClass(coreModClass);
            Object labyModCoreMod = labyModCoreModClass.newInstance();
            try {
                Class.forName("net.minecraft.client.Minecraft");
                this.obfuscated = false;
            }
            catch (ClassNotFoundException e) {
                this.obfuscated = true;
            }
            labyModCoreModClass.getDeclaredMethod("setObfuscated", Boolean.TYPE).invoke(null, this.obfuscated);
            for (String transformer : (String[])labyModCoreModClass.getDeclaredMethod("getASMTransformerClass", new Class[0]).invoke(labyModCoreMod, new Object[0])) {
                launchClassLoader.registerTransformer(transformer);
                System.out.println("Registering transformer " + transformer);
            }
            launchClassLoader.registerTransformer(LabyModTransformer.class.getName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    public String getLaunchTarget() {
        return "net.minecraft.client.main.Main";
    }

    public String[] getLaunchArguments() {
        ArrayList<String> returnedArguments = new ArrayList<String>();
        returnedArguments.addAll(this.arguments);
        returnedArguments.addAll(Arrays.asList("--version", this.version));
        if (gameDirectory != null) {
            returnedArguments.addAll(Arrays.asList("--gameDir", gameDirectory.getPath()));
        }
        if (this.assetsDirectory != null) {
            returnedArguments.addAll(Arrays.asList("--assetsDir", this.assetsDirectory.getPath()));
        }
        return returnedArguments.toArray(new String[0]);
    }

    public LaunchClassLoader getLaunchClassLoader() {
        return this.launchClassLoader;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isObfuscated() {
        return this.obfuscated;
    }

    public File getGameDirectory() {
        return gameDirectory;
    }

    public static LabyModTweaker getInstance() {
        return instance;
    }

    public static String getVersionStatic() {
        return launchedProfile;
    }
}

