/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.utils.texture;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import net.labymod.support.util.Debug;
import net.labymod.utils.Consumer;
import net.labymod.utils.texture.async.AsyncTextureUtil;

public class ThreadDownloadTextureImage
extends bme {
    private static ExecutorService executorService = Executors.newFixedThreadPool(5);
    private String imageUrl;
    private Consumer<Boolean> consumer;
    private String userAgent = "Unknown";
    private SSLSocketFactory socketFactory;
    private TextureImageParser textureImageParser;
    private Debug.EnumDebugMode debugMode = Debug.EnumDebugMode.GENERAL;
    private BufferedImage bufferedImage;
    private boolean textureLoaded = false;
    private Consumer<BufferedImage> callback;

    public ThreadDownloadTextureImage(String imageUrl, jy textureResourceLocation, Consumer<Boolean> consumer, String userAgent) {
        super(textureResourceLocation);
        this.imageUrl = imageUrl;
        this.consumer = consumer;
        this.userAgent = userAgent;
    }

    public int b() {
        int textureId = super.b();
        if (!this.textureLoaded && this.bufferedImage != null) {
            this.textureLoaded = true;
            AsyncTextureUtil.uploadTextureImage(textureId, this.bufferedImage);
        }
        return textureId;
    }

    public void a(bni resourceManager) throws IOException {
        this.downloadTexture(null);
    }

    public void downloadTexture(final Consumer<ThreadDownloadTextureImage> loadTextureCallback) {
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ThreadDownloadTextureImage.this.imageUrl.startsWith("data:")) {
                        String[] parts = ThreadDownloadTextureImage.this.imageUrl.split(",");
                        if (parts.length >= 2) {
                            String data = parts[1];
                            BufferedImage loadedImage = ImageIO.read(new ByteArrayInputStream(Base64.getDecoder().decode(data)));
                            if (ThreadDownloadTextureImage.this.textureImageParser != null) {
                                loadedImage = ThreadDownloadTextureImage.this.textureImageParser.parse(loadedImage);
                            }
                            ThreadDownloadTextureImage.this.bufferedImage = loadedImage;
                            if (ThreadDownloadTextureImage.this.bufferedImage == null) {
                                Debug.log(ThreadDownloadTextureImage.this.debugMode, "Failed to convert base64 texture " + data);
                            } else {
                                Debug.log(ThreadDownloadTextureImage.this.debugMode, "Converted texture from base64 with size " + loadedImage.getWidth() + "x" + loadedImage.getHeight());
                            }
                        }
                    } else {
                        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(ThreadDownloadTextureImage.this.imageUrl).openConnection();
                        httpURLConnection.setRequestProperty("User-Agent", ThreadDownloadTextureImage.this.userAgent);
                        if (ThreadDownloadTextureImage.this.socketFactory != null && httpURLConnection instanceof HttpsURLConnection) {
                            ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(ThreadDownloadTextureImage.this.socketFactory);
                        }
                        httpURLConnection.connect();
                        int responseCode = httpURLConnection.getResponseCode();
                        if (responseCode / 100 == 2) {
                            BufferedImage loadedImage = bml.a((InputStream)httpURLConnection.getInputStream());
                            if (ThreadDownloadTextureImage.this.textureImageParser != null) {
                                loadedImage = ThreadDownloadTextureImage.this.textureImageParser.parse(loadedImage);
                            }
                            ThreadDownloadTextureImage.this.bufferedImage = loadedImage;
                            if (ThreadDownloadTextureImage.this.bufferedImage == null) {
                                Debug.log(ThreadDownloadTextureImage.this.debugMode, "Failed to download texture " + ThreadDownloadTextureImage.this.imageUrl + " (" + responseCode + ")");
                            } else {
                                Debug.log(ThreadDownloadTextureImage.this.debugMode, "Downloaded texture " + ThreadDownloadTextureImage.this.imageUrl);
                            }
                        } else {
                            Debug.log(ThreadDownloadTextureImage.this.debugMode, "Response code for " + ThreadDownloadTextureImage.this.imageUrl + " is " + responseCode);
                        }
                    }
                }
                catch (Exception error) {
                    error.printStackTrace();
                }
                if (ThreadDownloadTextureImage.this.callback != null) {
                    ThreadDownloadTextureImage.this.callback.accept(ThreadDownloadTextureImage.this.bufferedImage);
                }
                ThreadDownloadTextureImage.this.consumer.accept(ThreadDownloadTextureImage.this.bufferedImage != null);
                if (loadTextureCallback != null) {
                    loadTextureCallback.accept(ThreadDownloadTextureImage.this);
                }
            }
        });
    }

    public void setCallback(Consumer<BufferedImage> callback) {
        this.callback = callback;
    }

    public void setSocketFactory(SSLSocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public void setTextureImageParser(TextureImageParser textureImageParser) {
        this.textureImageParser = textureImageParser;
    }

    public void setDebugMode(Debug.EnumDebugMode debugMode) {
        this.debugMode = debugMode;
    }

    public static interface TextureImageParser {
        public BufferedImage parse(BufferedImage var1);
    }
}

