/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.utils.texture;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import net.labymod.accountmanager.utils.CertificateLoader;
import net.labymod.core.LabyModCore;
import net.labymod.main.ModTextures;
import net.labymod.utils.Consumer;
import net.labymod.utils.manager.TagManager;
import net.labymod.utils.texture.DynamicModTexture;
import net.labymod.utils.texture.ThreadDownloadTextureImage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class DynamicTextureManager {
    private final String resourceName;
    private final jy defaultTexture;
    private String userAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36";
    private SSLSocketFactory socketFactory = null;
    private ThreadDownloadTextureImage.TextureImageParser textureImageParser = null;
    protected final Map<String, DynamicModTexture> resourceLocations = new HashMap<String, DynamicModTexture>();
    private Map<jy, bmk> mapTextureObjects = new HashMap<jy, bmk>();

    public DynamicTextureManager(String resourceName, jy defaultTexture) {
        this.resourceName = resourceName;
        this.defaultTexture = defaultTexture;
        try {
            this.socketFactory = CertificateLoader.getSocketFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init() {
        try {
            Field field = ReflectionHelper.findField(bmj.class, LabyModCore.getMappingAdapter().getMapTextureObjects());
            field.setAccessible(true);
            this.mapTextureObjects = (Map)field.get(ave.A().P());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (TagManager.SYMBOL - 10 != 9988) {
            TagManager.SYMBOL = (char)9898;
            TagManager.SYMBOL = (char)(TagManager.SYMBOL + 100);
        }
    }

    @Deprecated
    public jy getHeadTexture(GameProfile gameProfile) {
        return ModTextures.MISC_HEAD_QUESTION;
    }

    public jy getTexture(String identifier, String url) {
        boolean unloadImage;
        bmj textureManager = ave.A().P();
        DynamicModTexture dynamicModTexture = this.resourceLocations.get(identifier);
        boolean bl = unloadImage = dynamicModTexture != null && dynamicModTexture.getUrl() != null && !dynamicModTexture.getUrl().equals(url);
        if (dynamicModTexture == null || unloadImage) {
            if (unloadImage) {
                textureManager.c(dynamicModTexture.getResourceLocation());
                dynamicModTexture.setResourceLocation(this.defaultTexture);
                dynamicModTexture.setUrl(null);
            } else {
                dynamicModTexture = new DynamicModTexture(this.defaultTexture, null);
            }
            this.resourceLocations.put(identifier, dynamicModTexture);
            this.resolveImageTexture(identifier, url);
        }
        return dynamicModTexture.getResourceLocation();
    }

    private void resolveImageTexture(final String identifier, final String url) {
        if (identifier == null || url == null) {
            return;
        }
        bmj textureManager = ave.A().P();
        final jy resourceLocation = new jy(this.resourceName + "/" + this.getHash(url));
        ThreadDownloadTextureImage threadDownloadImageData = new ThreadDownloadTextureImage(url, resourceLocation, new Consumer<Boolean>(){

            @Override
            public void accept(Boolean accepted) {
                DynamicTextureManager.this.resourceLocations.put(identifier, new DynamicModTexture(resourceLocation, url));
            }
        }, this.userAgent);
        threadDownloadImageData.setSocketFactory(this.socketFactory);
        threadDownloadImageData.setTextureImageParser(this.textureImageParser);
        textureManager.a(resourceLocation, (bmk)threadDownloadImageData);
    }

    public void unloadAll() {
        ave.A().a(new Runnable(){

            @Override
            public void run() {
                try {
                    for (Map.Entry<String, DynamicModTexture> entry : DynamicTextureManager.this.resourceLocations.entrySet()) {
                        jy resourceLocation = entry.getValue().getResourceLocation();
                        DynamicTextureManager.this.mapTextureObjects.remove(resourceLocation);
                    }
                    DynamicTextureManager.this.resourceLocations.clear();
                }
                catch (Exception error) {
                    error.printStackTrace();
                }
            }
        });
    }

    private int getHash(String url) {
        int hash = 7;
        for (int i = 0; i < url.length(); ++i) {
            hash = hash * 31 + url.charAt(i);
        }
        return hash;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public jy getDefaultTexture() {
        return this.defaultTexture;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public SSLSocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public ThreadDownloadTextureImage.TextureImageParser getTextureImageParser() {
        return this.textureImageParser;
    }

    public Map<String, DynamicModTexture> getResourceLocations() {
        return this.resourceLocations;
    }

    public Map<jy, bmk> getMapTextureObjects() {
        return this.mapTextureObjects;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setSocketFactory(SSLSocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public void setTextureImageParser(ThreadDownloadTextureImage.TextureImageParser textureImageParser) {
        this.textureImageParser = textureImageParser;
    }
}

