/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.utils.manager;

import java.util.HashMap;
import java.util.Map;
import net.labymod.core.BlockPosition;
import net.labymod.core.LabyModCore;
import net.labymod.main.LabyMod;

public class SignManager {
    private static SignSearchSettings signSearchSettings = new SignSearchSettings();
    private static Map<BlockPosition, SignData> signDataMap = new HashMap<BlockPosition, SignData>();

    public static void render(aln tileEntitySign) {
        if (!LabyMod.getSettings().signSearch || !signSearchSettings.isEnabled()) {
            if (!signDataMap.isEmpty()) {
                SignManager.reset();
            }
            return;
        }
        BlockPosition blockPosition = LabyModCore.getMinecraft().getPosition(tileEntitySign.v());
        SignData signData = signDataMap.get(blockPosition);
        if (signData == null || signData.getLastSignUpdated() + 500L < System.currentTimeMillis()) {
            signData = new SignData(tileEntitySign);
            signDataMap.put(blockPosition, signData);
        }
        signData.getSignColor().applyColor();
    }

    public static void reset() {
        signDataMap = new HashMap<BlockPosition, SignData>();
    }

    public static SignSearchSettings getSignSearchSettings() {
        return signSearchSettings;
    }

    public static class SignSearchSettings {
        private String searchString = "";
        private String blacklistString = "";
        private boolean useAdvancedOptions = false;
        private boolean filterFullServer = false;
        private boolean filterEmptyServer = false;
        private boolean enabled;

        public void update() {
            this.enabled = this.useAdvancedOptions && (this.filterFullServer || this.filterEmptyServer || !this.blacklistString.isEmpty()) || !this.searchString.isEmpty();
        }

        public String getSearchString() {
            return this.searchString;
        }

        public String getBlacklistString() {
            return this.blacklistString;
        }

        public boolean isUseAdvancedOptions() {
            return this.useAdvancedOptions;
        }

        public boolean isFilterFullServer() {
            return this.filterFullServer;
        }

        public boolean isFilterEmptyServer() {
            return this.filterEmptyServer;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setSearchString(String searchString) {
            this.searchString = searchString;
        }

        public void setBlacklistString(String blacklistString) {
            this.blacklistString = blacklistString;
        }

        public void setUseAdvancedOptions(boolean useAdvancedOptions) {
            this.useAdvancedOptions = useAdvancedOptions;
        }

        public void setFilterFullServer(boolean filterFullServer) {
            this.filterFullServer = filterFullServer;
        }

        public void setFilterEmptyServer(boolean filterEmptyServer) {
            this.filterEmptyServer = filterEmptyServer;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class SignData {
        private aln tileEntitySign;
        private SignColor signColor = SignColor.NONE;
        private long lastSignUpdated;

        public SignData(aln sign) {
            this.tileEntitySign = sign;
            this.lastSignUpdated = System.currentTimeMillis();
            this.parseSignData();
        }

        private void parseSignData() {
            boolean searchFound;
            String fullString = "";
            String[] lines = new String[4];
            int lineCount = -1;
            for (eu eu2 : this.tileEntitySign.a) {
                String line;
                ++lineCount;
                if (eu2 == null || (line = LabyModCore.getMinecraft().getChatComponent(eu2).getUnformattedText()) == null) continue;
                fullString = fullString + line;
                lines[lineCount] = line;
            }
            if (fullString.isEmpty()) {
                return;
            }
            SignSearchSettings settings = signSearchSettings;
            fullString = fullString.toLowerCase();
            String searchString = settings.getSearchString().toLowerCase();
            boolean bl = searchFound = searchString.isEmpty() || fullString.contains(searchString);
            if (!searchFound && searchString.contains(",")) {
                for (String word : searchString.split("\\,")) {
                    if (!fullString.contains(word)) continue;
                    searchFound = true;
                }
            }
            if (settings.isUseAdvancedOptions()) {
                boolean bl2 = !settings.getBlacklistString().isEmpty() && fullString.contains(settings.getBlacklistString().toLowerCase());
                Integer currentUserCount = this.getUserCount(lines, true);
                Integer maxUserCount = this.getUserCount(lines, false);
                if (searchFound && !bl2) {
                    boolean isFull;
                    boolean isEmpty = currentUserCount != null && currentUserCount == 0 && settings.isFilterEmptyServer();
                    boolean bl3 = isFull = maxUserCount != null && currentUserCount != null && currentUserCount >= maxUserCount && settings.isFilterFullServer();
                    this.signColor = !isEmpty && !isFull ? SignColor.GREEN : (isEmpty ? SignColor.GRAY : (isFull ? SignColor.ORANGE : SignColor.RED));
                } else {
                    this.signColor = SignColor.RED;
                }
            } else {
                this.signColor = searchFound ? SignColor.GREEN : SignColor.RED;
            }
        }

        private Integer getUserCount(String[] lines, boolean pre) {
            for (String line : lines) {
                if (line == null || !line.contains("/")) continue;
                String[] parts = line.split("/");
                if (parts.length <= (pre ? 0 : 1)) continue;
                String result = parts[pre ? 0 : 1].replaceAll(" ", "");
                return result.matches("^-?\\d+$") ? Integer.valueOf(Integer.parseInt(result)) : null;
            }
            return null;
        }

        public aln getTileEntitySign() {
            return this.tileEntitySign;
        }

        public SignColor getSignColor() {
            return this.signColor;
        }

        public long getLastSignUpdated() {
            return this.lastSignUpdated;
        }

        public void setTileEntitySign(aln tileEntitySign) {
            this.tileEntitySign = tileEntitySign;
        }

        public void setSignColor(SignColor signColor) {
            this.signColor = signColor;
        }

        public void setLastSignUpdated(long lastSignUpdated) {
            this.lastSignUpdated = lastSignUpdated;
        }
    }

    public static enum SignColor {
        NONE(1.0f, 1.0f, 1.0f, 1.0f),
        GREEN(0.6f, 23.6f, 0.6f, 0.6f),
        RED(23.6f, 0.6f, 0.6f, 0.6f),
        ORANGE(10.0f, 10.0f, 0.6f, 0.6f),
        GRAY(0.6f, 0.6f, 0.6f, 0.6f);

        private float red;
        private float green;
        private float blue;
        private float alpha;

        public void applyColor() {
            bfl.c((float)this.red, (float)this.green, (float)this.blue, (float)this.alpha);
        }

        private SignColor(float red, float green, float blue, float alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        public float getRed() {
            return this.red;
        }

        public float getGreen() {
            return this.green;
        }

        public float getBlue() {
            return this.blue;
        }

        public float getAlpha() {
            return this.alpha;
        }
    }
}

