/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.utils.manager;

import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import net.labymod.core.LabyModCore;
import net.labymod.core.ServerPingerData;
import net.labymod.main.LabyMod;
import net.labymod.main.Source;
import net.labymod.utils.ServerData;
import net.labymod.utils.manager.TooltipHelper;
import org.apache.commons.lang3.Validate;

public class ServerInfoRenderer {
    private static final jy UNKNOWN_SERVER = new jy("textures/misc/unknown_server.png");
    private static final jy SERVER_SELECTION_BUTTONS = new jy("textures/gui/server_selection.png");
    private final ave mc = ave.A();
    private ServerPingerData serverData;
    private jy serverIcon;
    private String base64;
    private blz dynamicTexture;
    private boolean canReachServer = false;
    private boolean hidden = false;
    private ServerData labymodServerData;
    private int index = 0;

    public ServerInfoRenderer(String rawIp, ServerPingerData serverData) {
        this(rawIp, rawIp, serverData);
    }

    public ServerInfoRenderer(String serverName, String rawIp, ServerPingerData serverData) {
        this.init(serverName, rawIp, serverData);
    }

    public void init(String serverName, String rawIp, ServerPingerData serverData) {
        if (serverData == null) {
            serverData = new ServerPingerData(rawIp == null || rawIp.isEmpty() ? "localhost" : rawIp, 0L);
            serverData.setPingToServer(-1L);
            serverData.setMotd("\u00a74Can't connect to server.");
            serverData.setVersion(Source.ABOUT_MC_PROTOCOL_VERSION);
            this.canReachServer = false;
        } else {
            this.serverIcon = new jy("servers/" + serverData.getIpAddress() + "/icon");
            this.dynamicTexture = (blz)this.mc.P().b(this.serverIcon);
            this.canReachServer = true;
        }
        this.serverData = serverData;
        this.serverData.setServerName(serverName);
    }

    public void drawEntry(int x, int y, int listWidth, int mouseX, int mouseY) {
        String s1;
        int l;
        boolean flag = this.isClientOutOfDate();
        boolean flag1 = this.isServerOutOfDate();
        boolean flag2 = flag || flag1;
        LabyModCore.getMinecraft().getFontRenderer().a(this.serverData.getServerName(), x + 32 + 3, y + 1, 0xFFFFFF);
        List<String> list = LabyMod.getInstance().getDrawUtils().listFormattedStringToWidth(this.serverData.getMotd(), listWidth - 32 - 2);
        for (int i = 0; i < Math.min(list.size(), 2); ++i) {
            LabyModCore.getMinecraft().getFontRenderer().a(list.get(i), x + 32 + 3, y + 12 + LabyModCore.getMinecraft().getFontRenderer().a * i, 0x808080);
        }
        String populationInfo = "\u00a77" + this.serverData.getCurrentPlayers() + "\u00a78/\u00a77" + this.serverData.getMaxPlayers();
        if (!this.canReachServer) {
            populationInfo = "\u00a77???";
        }
        String s2 = flag2 ? "\u00a74" + this.serverData.getGameVersion() : populationInfo;
        int j = LabyModCore.getMinecraft().getFontRenderer().a(s2);
        LabyModCore.getMinecraft().getFontRenderer().a(s2, x + listWidth - j - 15 - 2, y + 1, 0x808080);
        int k = 0;
        String s = null;
        if (flag2) {
            l = 5;
            s1 = flag ? "Client out of date!" : "Server out of date!";
            s = this.serverData.getPlayerList();
        } else if (this.serverData.getPingToServer() != -2L) {
            l = this.serverData.getPingToServer() < 0L ? 5 : (this.serverData.getPingToServer() < 150L ? 0 : (this.serverData.getPingToServer() < 300L ? 1 : (this.serverData.getPingToServer() < 600L ? 2 : (this.serverData.getPingToServer() < 1000L ? 3 : 4))));
            if (this.serverData.getPingToServer() < 0L) {
                s1 = "(no connection)";
            } else {
                s1 = this.serverData.getPingToServer() + "ms";
                s = this.serverData.getPlayerList();
            }
        } else {
            k = 1;
            l = (int)(ave.J() / 100L + 2L & 7L);
            if (l > 4) {
                l = 8 - l;
            }
            s1 = "Pinging...";
        }
        bfl.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.P().a(LabyModCore.getRenderImplementation().getIcons());
        avp.a((int)(x + listWidth - 15), (int)y, (float)(k * 10), (float)(176 + l * 8), (int)10, (int)8, (float)256.0f, (float)256.0f);
        if (this.serverData != null && this.serverData.getBase64EncodedIconData() != null && !Objects.equal((Object)this.serverData.getBase64EncodedIconData(), (Object)this.base64)) {
            this.base64 = this.serverData.getBase64EncodedIconData();
            this.prepareServerIcon();
        }
        if (this.dynamicTexture != null) {
            this.drawServerIcon(x, y, this.serverIcon);
        } else {
            this.drawServerIcon(x, y, UNKNOWN_SERVER);
        }
        int i1 = mouseX - x;
        int j1 = mouseY - y;
        if (s != null) {
            if (i1 >= listWidth - 15 && i1 <= listWidth - 5 && j1 >= 0 && j1 <= 8 && !s1.isEmpty()) {
                TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, 0L, s1.split("\n"));
            } else if (i1 >= listWidth - j - 15 - 2 && i1 <= listWidth - 15 - 2 && j1 >= 0 && j1 <= 8 && !s.isEmpty()) {
                TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, 0L, s.split("\n"));
            }
        }
    }

    public boolean isClientOutOfDate() {
        return this.serverData.getVersion() > Source.ABOUT_MC_PROTOCOL_VERSION;
    }

    public boolean isServerOutOfDate() {
        return this.serverData.getVersion() < Source.ABOUT_MC_PROTOCOL_VERSION;
    }

    public boolean drawJoinServerButton(int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY) {
        if (mouseX > x && mouseX < x + listWidth && mouseY > y && mouseY < y + slotHeight) {
            this.mc.P().a(SERVER_SELECTION_BUTTONS);
            avp.a((int)x, (int)y, (int)(x + 32), (int)(y + 32), (int)-1601138544);
            bfl.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int k1 = mouseX - x;
            if (k1 < 32 && k1 > 16) {
                avp.a((int)x, (int)y, (float)0.0f, (float)32.0f, (int)32, (int)32, (float)256.0f, (float)256.0f);
                return true;
            }
            avp.a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)32, (int)32, (float)256.0f, (float)256.0f);
        }
        return false;
    }

    public boolean drawSaveServerButton(int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY) {
        if (mouseX > x && mouseX < x + listWidth && mouseY > y && mouseY < y + slotHeight) {
            this.mc.P().a(SERVER_SELECTION_BUTTONS);
            bfl.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int k1 = mouseX - x;
            int l1 = mouseY - y;
            if (k1 < 16 && l1 > 16) {
                avp.a((int)x, (int)y, (float)64.0f, (float)32.0f, (int)32, (int)32, (float)256.0f, (float)256.0f);
                return true;
            }
            avp.a((int)x, (int)y, (float)64.0f, (float)0.0f, (int)32, (int)32, (float)256.0f, (float)256.0f);
        }
        return false;
    }

    protected void drawServerIcon(int posX, int posY, jy resourceLocation) {
        this.mc.P().a(resourceLocation);
        bfl.l();
        avp.a((int)posX, (int)posY, (float)0.0f, (float)0.0f, (int)32, (int)32, (float)32.0f, (float)32.0f);
        bfl.k();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareServerIcon() {
        if (this.serverData.getBase64EncodedIconData() == null) {
            this.mc.P().c(this.serverIcon);
            this.dynamicTexture = null;
        } else {
            BufferedImage bufferedimage;
            block8: {
                ByteBuf bytebuf = Unpooled.copiedBuffer((CharSequence)this.serverData.getBase64EncodedIconData(), (Charset)Charsets.UTF_8);
                ByteBuf bytebuf1 = Base64.decode((ByteBuf)bytebuf);
                try {
                    bufferedimage = bml.a((InputStream)new ByteBufInputStream(bytebuf1));
                    Validate.validState((bufferedimage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                    Validate.validState((bufferedimage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                    break block8;
                }
                catch (Throwable throwable) {
                    this.serverData.setBase64EncodedIconData(null);
                }
                finally {
                    bytebuf.release();
                    bytebuf1.release();
                }
                return;
            }
            if (this.dynamicTexture == null) {
                this.dynamicTexture = new blz(bufferedimage.getWidth(), bufferedimage.getHeight());
                this.mc.P().a(this.serverIcon, (bmk)this.dynamicTexture);
            }
            bufferedimage.getRGB(0, 0, bufferedimage.getWidth(), bufferedimage.getHeight(), this.dynamicTexture.e(), 0, bufferedimage.getWidth());
            this.dynamicTexture.d();
        }
    }

    public ServerInfoRenderer setIndex(int index) {
        this.index = index;
        return this;
    }

    public boolean canReachServer() {
        return this.canReachServer && this.serverData != null && !this.serverData.isPinging();
    }

    public ServerPingerData getServerData() {
        return this.serverData;
    }

    public jy getServerIcon() {
        return this.serverIcon;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public ServerData getLabymodServerData() {
        return this.labymodServerData;
    }

    public void setLabymodServerData(ServerData labymodServerData) {
        this.labymodServerData = labymodServerData;
    }

    public int getIndex() {
        return this.index;
    }
}

