/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.utils.manager;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.labymod.api.events.PluginMessageEvent;
import net.labymod.api.events.ServerMessageEvent;
import net.labymod.api.permissions.Permissions;
import net.labymod.core.LabyModCore;
import net.labymod.labyconnect.packets.PacketAddonDevelopment;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.utils.Consumer;
import net.labymod.utils.DrawUtils;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MarkerManager
implements PluginMessageEvent,
ServerMessageEvent,
Consumer<PacketAddonDevelopment> {
    private static final jy SOUND_PLACE_MARKER = new jy("note.snare");
    private static final jy SOUND_MARKER_NOTIFY = new jy("note.pling");
    private Map<UUID, Marker> markers = new HashMap<UUID, Marker>();
    private boolean enabled = true;
    private boolean sendMarkers = false;

    public MarkerManager() {
        LabyMod.getInstance().getLabyModAPI().getEventManager().register(this);
        LabyMod.getInstance().getLabyModAPI().getEventManager().register(this);
        LabyMod.getInstance().getLabyModAPI().getEventManager().registerOnAddonDevelopmentPacket(this);
        LabyMod.getInstance().getLabyModAPI().registerForgeListener(this);
    }

    @SubscribeEvent
    public void onRenderWorld(RenderWorldLastEvent event) {
        this.render(LabyMod.getInstance().getPartialTicks());
    }

    @Override
    public void receiveMessage(String channelName, em packetBuffer) {
        if (channelName.equals("minecraft:brand")) {
            this.enabled = true;
        }
    }

    @Override
    public void onServerMessage(String messageKey, JsonElement serverMessage) {
        if (!messageKey.equals("marker")) {
            return;
        }
        try {
            JsonObject object = serverMessage.getAsJsonObject();
            if (object.has("enabled")) {
                this.enabled = object.get("enabled").getAsBoolean();
            }
            if (object.has("send_markers")) {
                this.sendMarkers = object.get("send_markers").getAsBoolean();
            }
            if (object.has("add_marker")) {
                JsonObject markerObject = object.get("add_marker").getAsJsonObject();
                UUID sender = UUID.fromString(markerObject.get("sender").getAsString());
                int x = markerObject.get("x").getAsInt();
                int y = markerObject.get("y").getAsInt();
                int z = markerObject.get("z").getAsInt();
                boolean isOutside = markerObject.get("large").getAsBoolean();
                UUID target = markerObject.has("target") ? UUID.fromString(markerObject.get("target").getAsString()) : null;
                this.updateMarker(sender, x, y, z, isOutside, target);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void accept(PacketAddonDevelopment packet) {
        try {
            String key = packet.getKey();
            if (!key.equals("labymod:marker") || LabyModCore.getMinecraft().getWorld() == null || !LabyMod.getSettings().marker) {
                return;
            }
            UUID target = null;
            ByteBuf buffer = Unpooled.wrappedBuffer((byte[])packet.getData());
            int version = buffer.readInt();
            if (version != 0) {
                buffer.release();
                return;
            }
            int x = buffer.readInt();
            int y = buffer.readInt();
            int z = buffer.readInt();
            boolean isOutside = buffer.readBoolean();
            boolean markedEntity = buffer.readBoolean();
            if (markedEntity) {
                target = new UUID(buffer.readLong(), buffer.readLong());
            }
            buffer.release();
            bew clientPlayer = LabyModCore.getMinecraft().getPlayer();
            wn player = LabyModCore.getMinecraft().getWorld().b(packet.getSender());
            if (player == null || clientPlayer == null || LabyModCore.getMinecraft().getDistanceToEntitySqr((pk)player, clientPlayer) > 4096.0) {
                return;
            }
            this.updateMarker(packet.getSender(), x, y, z, isOutside, target);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateMarker(UUID uuid, int x, int y, int z, boolean isOutside, UUID target) {
        Marker prevMarker = this.markers.get(uuid);
        if (prevMarker == null || !prevMarker.isVisible()) {
            Marker marker = new Marker(x, y, z, System.currentTimeMillis(), isOutside, target, null);
            this.addMarker(uuid, marker);
            LabyModCore.getMinecraft().playSound(SOUND_MARKER_NOTIFY, 2.0f);
        } else {
            prevMarker.x = x;
            prevMarker.y = y;
            prevMarker.z = z;
            prevMarker.timestamp = System.currentTimeMillis();
            prevMarker.isOutside = isOutside;
            prevMarker.target = target;
            prevMarker.cachedEntity = null;
        }
    }

    public void setClientMarker() {
        try {
            bew player = LabyModCore.getMinecraft().getPlayer();
            UUID uuid = LabyMod.getInstance().getPlayerUUID();
            bdb world = LabyModCore.getMinecraft().getWorld();
            Vector3d targetPoint = this.getTargetPoint((adm)world, LabyModCore.getMinecraft().getLookVector(player), LabyModCore.getMinecraft().getPositionEyes(player, 0.0f), 100, 2.0);
            if (targetPoint == null) {
                return;
            }
            Vector3d targetLocation = this.getHighestPointAt((adm)world, targetPoint, 100);
            boolean isOutside = this.isOutside((adm)world, targetLocation, 20);
            UUID target = this.getTargetEntity((adm)world, targetLocation, 2);
            if (target != null && target.equals(uuid)) {
                target = null;
            }
            Marker marker = new Marker((int)Math.floor(targetLocation.x), (int)targetLocation.y, (int)Math.floor(targetLocation.z), System.currentTimeMillis(), isOutside, target, null);
            ArrayList<UUID> receivers = new ArrayList<UUID>();
            for (wn playerEntity : world.j) {
                UUID playerUUID = playerEntity.cd().getId();
                if (!LabyMod.getInstance().getLabyConnect().hasFriendOnline(playerUUID)) continue;
                receivers.add(playerUUID);
            }
            UUID[] uuidArray = new UUID[receivers.size()];
            receivers.toArray(uuidArray);
            this.addMarker(uuid, marker);
            LabyModCore.getMinecraft().playSound(SOUND_PLACE_MARKER, 2.0f);
            if (uuidArray.length != 0 && this.enabled) {
                ByteBuf buffer = Unpooled.buffer();
                buffer.writeInt(0);
                buffer.writeInt(marker.x);
                buffer.writeInt(marker.y);
                buffer.writeInt(marker.z);
                buffer.writeBoolean(marker.isOutside);
                buffer.writeBoolean(target != null);
                if (target != null) {
                    buffer.writeLong(target.getMostSignificantBits());
                    buffer.writeLong(target.getLeastSignificantBits());
                }
                LabyMod.getInstance().getLabyModAPI().sendAddonDevelopmentPacket(new PacketAddonDevelopment(uuid, uuidArray, "labymod:marker", buffer.array()));
                buffer.release();
            }
            if (this.sendMarkers) {
                JsonObject object = new JsonObject();
                object.addProperty("version", (Number)0);
                object.addProperty("x", (Number)marker.x);
                object.addProperty("y", (Number)marker.y);
                object.addProperty("z", (Number)marker.z);
                object.addProperty("large", Boolean.valueOf(marker.isOutside));
                if (marker.target != null) {
                    object.addProperty("target", marker.target.toString());
                }
                LabyMod.getInstance().getLabyModAPI().sendJsonMessageToServer("marker", (JsonElement)object);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private UUID getTargetEntity(adm world, Vector3d location, int range) {
        if (!Permissions.isAllowed(Permissions.Permission.ENTITY_MARKER)) {
            return null;
        }
        pk nearest = null;
        double nearestDistance = Double.MAX_VALUE;
        for (pk allEntity : world.f) {
            double distance = allEntity.e(location.x, location.y, location.z);
            if (!(distance < (double)(range * range)) || !(distance < nearestDistance) || allEntity == LabyModCore.getMinecraft().getPlayer()) continue;
            nearest = allEntity;
        }
        return nearest == null ? null : nearest.aK();
    }

    private boolean isOutside(adm world, Vector3d source, int distance) {
        Vector3d target = source;
        for (int i = 0; i < distance; ++i) {
            alz state = LabyModCore.getMinecraft().getBlockState(world, target.x, target.y + 0.5, target.z);
            if (LabyModCore.getMinecraft().isSolid(state)) {
                return false;
            }
            target = target.add(0.0, 1.0, 0.0);
        }
        return true;
    }

    private Vector3d getTargetPoint(adm world, Vector3d direction, Vector3d source, int distance, double stepsPerBlock) {
        Vector3d lookVector = direction.scale(1.0 / stepsPerBlock);
        Vector3d target = source;
        int max = (int)((double)distance * stepsPerBlock);
        for (int i = 0; i < max * 2; ++i) {
            alz state = LabyModCore.getMinecraft().getBlockState(world, target.x, target.y, target.z);
            if (LabyModCore.getMinecraft().isSolid(state) || this.getTargetEntity(world, target, 2) != null && i > 5) break;
            target = target.add(lookVector);
            if (i + 1 != max) continue;
            return null;
        }
        return target;
    }

    private Vector3d getHighestPointAt(adm world, Vector3d source, int distance) {
        Vector3d target = source;
        for (int i = 0; i < distance; ++i) {
            alz state = LabyModCore.getMinecraft().getBlockState(world, target.x, target.y + 0.5, target.z);
            if (!LabyModCore.getMinecraft().isSolid(state)) break;
            target = target.add(0.0, 1.0, 0.0);
        }
        return target;
    }

    public void addMarker(UUID uuid, Marker marker) {
        HashMap<UUID, Marker> markers = new HashMap<UUID, Marker>();
        this.markers.forEach((uuidEntry, markerEntry) -> {
            if (markerEntry.isVisible()) {
                markers.put((UUID)uuidEntry, (Marker)markerEntry);
            }
        });
        markers.put(uuid, marker);
        this.markers = markers;
    }

    public void render(float partialTicks) {
        if (!LabyMod.getSettings().marker) {
            return;
        }
        pk entity = ave.A().ac();
        double camX = entity.P + (entity.s - entity.P) * (double)partialTicks;
        double camY = entity.Q + (entity.t - entity.Q) * (double)partialTicks;
        double camZ = entity.R + (entity.u - entity.R) * (double)partialTicks;
        this.markers.forEach((uuid, marker) -> {
            if (marker.isVisible()) {
                marker.render((UUID)uuid, camX, camY, camZ, partialTicks);
            }
        });
    }

    public void renderOverlay(float partialTicks) {
        if (LabyMod.getSettings().marker) {
            this.markers.forEach((uuid, marker) -> {
                if (marker.isVisible()) {
                    marker.renderOverlay((UUID)uuid, partialTicks);
                }
            });
        }
    }

    public static double wrapAngleTo180_double(double value) {
        if ((value %= 360.0) >= 180.0) {
            value -= 360.0;
        }
        if (value < -180.0) {
            value += 360.0;
        }
        return value;
    }

    public static class Vector3d {
        public double x;
        public double y;
        public double z;

        public Vector3d(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Vector3d add(Vector3d vector) {
            return new Vector3d(this.x + vector.x, this.y + vector.y, this.z + vector.z);
        }

        public Vector3d add(double x, double y, double z) {
            return new Vector3d(this.x + x, this.y + y, this.z + z);
        }

        public Vector3d scale(double factor) {
            return new Vector3d(this.x * factor, this.y * factor, this.z * factor);
        }
    }

    public static class Marker {
        public int x;
        public int y;
        public int z;
        public long timestamp;
        public boolean isOutside;
        public UUID target;
        public pk cachedEntity;

        public boolean isVisible() {
            return this.timestamp + (long)(LabyMod.getSettings().markerDuration * 1000) > System.currentTimeMillis();
        }

        public void render(UUID uuid, double camX, double camY, double camZ, float partialTicks) {
            bdb world;
            double yShift = this.y - Math.round(this.y);
            double x = (double)this.x - camX + 0.5;
            double y = (double)this.y - camY - yShift + 1.0;
            double z = (double)this.z - camZ + 0.5;
            if (this.cachedEntity == null && this.target != null && (world = LabyModCore.getMinecraft().getWorld()) != null) {
                for (pk allEntity : world.f) {
                    if (!allEntity.aK().equals(this.target)) continue;
                    this.cachedEntity = allEntity;
                    break;
                }
            }
            if (this.cachedEntity != null && this.target != null) {
                double playerX = this.cachedEntity.p + (this.cachedEntity.s - this.cachedEntity.p) * (double)partialTicks;
                double playerY = this.cachedEntity.q + (this.cachedEntity.t - this.cachedEntity.q) * (double)partialTicks;
                double playerZ = this.cachedEntity.r + (this.cachedEntity.u - this.cachedEntity.r) * (double)partialTicks;
                x = playerX - camX;
                y = playerY - camY + (double)this.cachedEntity.K;
                z = playerZ - camZ;
            }
            long markerDuration = LabyMod.getSettings().markerDuration * 1000;
            long timeRemaining = markerDuration - (System.currentTimeMillis() - this.timestamp);
            long fadeInDuration = 300L;
            double distance = x * x + y * y + z * z;
            double fadeOut = Math.min(1.0, 1.0 / (double)markerDuration * (double)(timeRemaining * timeRemaining));
            double fadeIn = Math.cos((double)((float)Math.min(fadeInDuration, System.currentTimeMillis() - this.timestamp) / (float)fadeInDuration) * Math.PI / (double)1.3f - 2.0943951023931953 + 0.5);
            double transition = fadeIn * fadeOut;
            double scale = Math.max(0.5, Math.min(this.isOutside ? 4.0 : 2.0, distance / 100.0)) * transition;
            double offsetY = (1.0 + Math.max(0.0, Math.min(this.isOutside ? 10.0 : 2.0, distance / 100.0))) * transition;
            double lineHeight = offsetY - scale + (this.isOutside ? scale * 1.5 : scale / 2.0);
            bfl.E();
            bfl.b((double)x, (double)y, (double)z);
            bfl.p();
            bfl.c((float)1.0f, (float)1.0f, (float)1.0f);
            bfl.E();
            bfl.b((double)0.0, (double)lineHeight, (double)0.0);
            float yaw = ave.A().af().e;
            float pitch = LabyModCore.getMinecraft().getRenderViewEntity().z;
            bfl.b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
            bfl.b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
            bfl.b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            jy texture = LabyMod.getInstance().getDrawUtils().getPlayerSkinTextureCache().getSkinTexture(uuid);
            if (texture != null) {
                double frame = scale / 15.0;
                bfl.c((float)0.6f, (float)0.0f, (float)0.0f);
                ave.A().P().a(ModTextures.VOID);
                LabyMod.getInstance().getDrawUtils().drawTexture(-scale / 2.0 - frame, -scale / 2.0 - frame, 32.0, 32.0, 32.0, 32.0, scale + frame * 2.0, scale + frame * 2.0, 1.1f);
                bfl.b((double)0.0, (double)0.0, (double)-0.01);
                ave.A().P().a(texture);
                LabyMod.getInstance().getDrawUtils().drawTexture(-scale / 2.0, -scale / 2.0, 32.0, 32.0, 32.0, 32.0, scale, scale);
                bfl.b((double)0.0, (double)0.0, (double)-0.01);
                LabyMod.getInstance().getDrawUtils().drawTexture(-scale / 2.0, -scale / 2.0, 160.0, 32.0, 32.0, 32.0, scale, scale);
            }
            bfl.F();
            bfl.E();
            yaw = LabyModCore.getMinecraft().getRenderViewEntity().y;
            bfl.b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
            bfl.b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            bfl.b((double)0.0, (double)0.0, (double)0.01);
            double lineWidth = 0.2 * scale * 2.0;
            ave.A().P().a(ModTextures.MISC_MARKER_CIRCLE);
            LabyMod.getInstance().getDrawUtils().drawTexture(-lineWidth / 2.0, -lineHeight + scale / 2.0, 128.0, 0.0, 128.0, 256.0, lineWidth, lineHeight - scale / 2.0);
            bfl.F();
            bfl.E();
            bfl.b((double)0.0, (double)0.01, (double)0.0);
            bfl.b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            ave.A().P().a(ModTextures.MISC_MARKER_CIRCLE);
            LabyMod.getInstance().getDrawUtils().drawTexture(-0.5 * transition, -0.5 * transition, 0.0, 0.0, 128.0, 256.0, transition, transition);
            bfl.F();
            bfl.o();
            bfl.d();
            bfl.F();
        }

        public void renderOverlay(UUID uuid, float partialTicks) {
            bew player = LabyModCore.getMinecraft().getPlayer();
            if (player == null) {
                return;
            }
            double playerX = player.p + (player.s - player.p) * (double)partialTicks;
            double playerZ = player.r + (player.u - player.r) * (double)partialTicks;
            double xDiff = (double)this.x - playerX + 0.5;
            double zDiff = (double)this.z - playerZ + 0.5;
            double distanceXZ = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
            double yaw = Math.toDegrees(Math.acos(xDiff / distanceXZ));
            if (zDiff < 0.0) {
                yaw += Math.abs(180.0 - yaw) * 2.0;
            }
            if ((yaw -= 90.0) < 0.0) {
                yaw = 360.0 + yaw;
            }
            bfl.E();
            bfl.i();
            bfl.c((float)1.0f, (float)1.0f, (float)1.0f);
            double clientYaw = MarkerManager.wrapAngleTo180_double(player.y);
            double yawOffset = MarkerManager.wrapAngleTo180_double(clientYaw - yaw + 180.0);
            DrawUtils draw = LabyMod.getInstance().getDrawUtils();
            int x = (int)((double)(draw.getWidth() / 2) + (double)(draw.getWidth() / 180) * yawOffset);
            draw.drawPlayerHead(uuid, x, draw.getHeight() - 20, 16);
            float pause = (float)(Math.sin((double)System.currentTimeMillis() / 500.0) * 3.0);
            if (pause < 0.0f) {
                pause = 0.0f;
            }
            float bounce = (float)Math.abs(Math.cos((double)System.currentTimeMillis() / 100.0) * (double)(-pause));
            ave.A().P().a(ModTextures.BUTTON_EXCLAMATION);
            draw.drawTexture(x + 20 - 7, (float)(draw.getHeight() - 20) - bounce, 0.0, 0.0, 120.0, 255.0, 8.0, 16.0, 1.1f);
            bfl.d();
            bfl.l();
            bfl.F();
        }

        @ConstructorProperties(value={"x", "y", "z", "timestamp", "isOutside", "target", "cachedEntity"})
        public Marker(int x, int y, int z, long timestamp, boolean isOutside, UUID target, pk cachedEntity) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.timestamp = timestamp;
            this.isOutside = isOutside;
            this.target = target;
            this.cachedEntity = cachedEntity;
        }
    }
}

