/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.utils.credentials.linux;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import net.labymod.accountmanager.storage.StorageType;
import net.labymod.accountmanager.storage.credentials.CredentialsAccessor;
import net.labymod.utils.credentials.linux.GKLib;
import net.labymod.utils.credentials.linux.GKResult;
import net.labymod.utils.credentials.linux.GList;

public class LinuxCredentialsAccessor
implements CredentialsAccessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getValue(StorageType storageType, String id) {
        PointerByReference pref;
        String keyRing;
        GKLib gklib = GKLib.INSTANCE;
        PointerByReference keyring_ref = new PointerByReference();
        GKResult result = new GKResult(gklib, gklib.gnome_keyring_get_default_keyring_sync(keyring_ref));
        if (result.success()) {
            keyRing = keyring_ref.getValue().getString(0L);
            GKResult idResult = new GKResult(gklib, gklib.gnome_keyring_list_item_ids_sync(keyRing, pref = new PointerByReference()));
            if (!idResult.success()) return null;
        } else {
            result.error();
            return null;
        }
        Pointer p = pref.getValue();
        GList gkal = new GList(p);
        while (true) {
            long keyRingId = Pointer.nativeValue((Pointer)gkal.data);
            PointerByReference item_info_ref = new PointerByReference();
            Pointer item_info = null;
            try {
                GKResult resultItem = new GKResult(gklib, gklib.gnome_keyring_item_get_info_full_sync(keyRing, (int)keyRingId, 1, item_info_ref));
                if (resultItem.success()) {
                    item_info = item_info_ref.getValue();
                    String display = gklib.gnome_keyring_item_info_get_display_name(item_info);
                    String secret = gklib.gnome_keyring_item_info_get_secret(item_info);
                    if (display.equals(id)) {
                        String string = secret;
                        if (item_info == null) return string;
                        gklib.gnome_keyring_item_info_free(item_info);
                        return string;
                    }
                } else {
                    resultItem.error();
                }
                if (item_info != null) {
                    gklib.gnome_keyring_item_info_free(item_info);
                }
            }
            catch (Throwable throwable) {
                if (item_info == null) throw throwable;
                gklib.gnome_keyring_item_info_free(item_info);
                throw throwable;
            }
            if (gkal.next == Pointer.NULL) return null;
            gkal = new GList(gkal.next);
        }
    }

    @Override
    public void setValue(StorageType storageType, String s, String s1) throws Exception {
        throw new UnsupportedOperationException("Not supported on Linux");
    }
}

