/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.mojang.util.UUIDTypeAdapter;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.HttpsURLConnection;
import net.labymod.accountmanager.utils.CertificateLoader;
import net.labymod.ingamechat.namehistory.NameHistory;
import net.labymod.utils.Consumer;

public class UUIDFetcher {
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    public static final long FEBRUARY_2015 = 1422748800000L;
    private static Gson gson = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).create();
    private static final String UUID_URL = "https://api.mojang.com/users/profiles/minecraft/%s?at=%d";
    private static final String NAME_URL = "https://laby.net/api/user/%s/get-names";
    private static final String DATE_URL = "https://api.minecraftservices.com/minecraft/profile/namechange";
    private static Map<String, UUID> uuidCache = new HashMap<String, UUID>();
    private static Map<UUID, String> nameCache = new HashMap<UUID, String>();
    private static ExecutorService pool = Executors.newCachedThreadPool();
    public String username;
    public UUID id;
    public long changedToAt;
    @SerializedName(value="changed_at")
    private String changedAt;
    public boolean hidden;

    public static void getUUID(final String name, final Consumer<UUID> action) {
        pool.execute(new Runnable(){

            @Override
            public void run() {
                action.accept(UUIDFetcher.getUUID(name));
            }
        });
    }

    public static UUID getUUID(String name) {
        return UUIDFetcher.getUUIDAt(name, System.currentTimeMillis());
    }

    public static void getUUIDAt(final String name, final long timestamp, final Consumer<UUID> action) {
        pool.execute(new Runnable(){

            @Override
            public void run() {
                action.accept(UUIDFetcher.getUUIDAt(name, timestamp));
            }
        });
    }

    public static void getDate(final String token, final Consumer<String> action) {
        pool.execute(new Runnable(){

            @Override
            public void run() {
                action.accept(UUIDFetcher.getDate(token));
            }
        });
    }

    public static String getDate(String token) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(DATE_URL).openConnection();
            connection.setReadTimeout(5000);
            connection.addRequestProperty("Authorization", "Bearer " + token);
            JsonObject data = (JsonObject)gson.fromJson((Reader)new BufferedReader(new InputStreamReader(connection.getInputStream())), JsonObject.class);
            return data.get("createdAt").getAsString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static UUID getUUIDAt(String name, long timestamp) {
        if (uuidCache.containsKey(name = name.toLowerCase())) {
            return uuidCache.get(name);
        }
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(String.format(UUID_URL, name, timestamp / 1000L)).openConnection();
            connection.setReadTimeout(5000);
            UUIDFetcher data = (UUIDFetcher)gson.fromJson((Reader)new BufferedReader(new InputStreamReader(connection.getInputStream())), UUIDFetcher.class);
            if (data == null) {
                return null;
            }
            uuidCache.put(name, data.id);
            nameCache.put(data.id, data.username);
            return data.id;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getCorrectUsername(String name, long timestamp) {
        if (uuidCache.containsKey(name = name.toLowerCase()) && nameCache.containsKey(uuidCache.get(name))) {
            return nameCache.get(uuidCache.get(name));
        }
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(String.format(UUID_URL, name, timestamp / 1000L)).openConnection();
            connection.setReadTimeout(5000);
            UUIDFetcher data = (UUIDFetcher)gson.fromJson((Reader)new BufferedReader(new InputStreamReader(connection.getInputStream())), UUIDFetcher.class);
            if (data == null) {
                return null;
            }
            uuidCache.put(name, data.id);
            nameCache.put(data.id, data.username);
            return data.username;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void getName(final UUID uuid, final Consumer<String> action) {
        pool.execute(new Runnable(){

            @Override
            public void run() {
                action.accept(UUIDFetcher.getName(uuid));
            }
        });
    }

    public static void getCorrectUsername(final String name, final Consumer<String> action) {
        pool.execute(new Runnable(){

            @Override
            public void run() {
                action.accept(UUIDFetcher.getCorrectUsername(name, System.currentTimeMillis()));
            }
        });
    }

    public static String getName(UUID uuid) {
        if (nameCache.containsKey(uuid)) {
            return nameCache.get(uuid);
        }
        try {
            HttpsURLConnection connection = (HttpsURLConnection)new URL(String.format(NAME_URL, UUIDTypeAdapter.fromUUID((UUID)uuid))).openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:49.0) Gecko/20100101 Firefox/49.0");
            connection.setReadTimeout(5000);
            connection.setSSLSocketFactory(CertificateLoader.getSocketFactory());
            UUIDFetcher[] nameHistory = (UUIDFetcher[])gson.fromJson((Reader)new BufferedReader(new InputStreamReader(connection.getInputStream())), UUIDFetcher[].class);
            UUIDFetcher currentNameData = nameHistory[nameHistory.length - 1];
            uuidCache.put(currentNameData.username.toLowerCase(), uuid);
            nameCache.put(uuid, currentNameData.username);
            return currentNameData.username;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static NameHistory getHistory(UUID uuid) {
        try {
            UUIDFetcher[] nameHistory;
            HttpsURLConnection connection = (HttpsURLConnection)new URL(String.format(NAME_URL, UUIDTypeAdapter.fromUUID((UUID)uuid))).openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:49.0) Gecko/20100101 Firefox/49.0");
            connection.setReadTimeout(5000);
            connection.setSSLSocketFactory(CertificateLoader.getSocketFactory());
            for (UUIDFetcher uuidFetcher : nameHistory = (UUIDFetcher[])gson.fromJson((Reader)new BufferedReader(new InputStreamReader(connection.getInputStream())), UUIDFetcher[].class)) {
                uuidFetcher.changedToAt = uuidFetcher.changedAt == null || uuidFetcher.changedAt.length() == 4 ? 0L : FORMAT.parse(uuidFetcher.changedAt).getTime();
            }
            return new NameHistory(uuid, nameHistory);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

