/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.utils;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.labymod.core.LabyModCore;
import net.labymod.core.WorldRendererAdapter;
import net.labymod.main.LabyMod;
import net.labymod.utils.texture.PlayerSkinTextureCache;
import org.lwjgl.opengl.GL11;

public class DrawUtils
extends avp {
    private ave mc;
    public avn fontRenderer;
    private avr scaledResolution;
    private final bbz humanoidHead = new bbi();
    private PlayerSkinTextureCache playerSkinTextureCache = new PlayerSkinTextureCache();

    public DrawUtils() {
        this.mc = ave.A();
        this.scaledResolution = new avr(this.mc);
        this.fontRenderer = LabyModCore.getCoreAdapter() == null ? null : LabyModCore.getMinecraft().getFontRenderer();
    }

    public avn getFontRenderer() {
        return this.fontRenderer;
    }

    public void setFontRenderer(avn fontRenderer) {
        this.fontRenderer = fontRenderer;
    }

    public void bindTexture(jy resourceLocation) {
        ave.A().P().a(resourceLocation);
    }

    public PlayerSkinTextureCache getPlayerSkinTextureCache() {
        return this.playerSkinTextureCache;
    }

    public void bindTexture(String resourceLocation) {
        this.bindTexture(new jy(resourceLocation));
    }

    public double getCustomScaling() {
        double factor = 1.0 + LabyMod.getSettings().moduleEditorZoom * 0.03;
        while ((double)ave.A().d / factor < 320.0) {
            factor -= 0.1;
        }
        while ((double)ave.A().e / factor < 240.0) {
            factor -= 0.1;
        }
        return factor;
    }

    public int getWidth() {
        return this.scaledResolution.a();
    }

    public int getHeight() {
        return this.scaledResolution.b();
    }

    public void setScaledResolution(avr scaledResolution) {
        this.scaledResolution = scaledResolution;
    }

    public avr getScaledResolution() {
        return this.scaledResolution;
    }

    public void drawString(String text, double x, double y) {
        this.fontRenderer.a(text, (float)x, (float)y, 0xFFFFFF, true);
    }

    public void drawStringWithShadow(String text, double x, double y, int color) {
        LabyModCore.getMinecraft().getFontRenderer().a(text, (float)x, (float)y, color);
    }

    public void drawRightString(String text, double x, double y) {
        this.drawString(text, x - (double)this.getStringWidth(text), y);
    }

    public void drawRightStringWithShadow(String text, int x, int y, int color) {
        LabyModCore.getMinecraft().getFontRenderer().a(text, (float)(x - this.getStringWidth(text)), (float)y, color);
    }

    public void drawCenteredString(String text, double x, double y) {
        this.drawString(text, x - (double)(this.getStringWidth(text) / 2), y);
    }

    public void drawString(String text, double x, double y, double size) {
        GL11.glPushMatrix();
        GL11.glScaled((double)size, (double)size, (double)size);
        this.drawString(text, x / size, y / size);
        GL11.glPopMatrix();
    }

    public void drawCenteredString(String text, double x, double y, double size) {
        GL11.glPushMatrix();
        GL11.glScaled((double)size, (double)size, (double)size);
        this.drawCenteredString(text, x / size, y / size);
        GL11.glPopMatrix();
    }

    public void drawRightString(String text, double x, double y, double size) {
        GL11.glPushMatrix();
        GL11.glScaled((double)size, (double)size, (double)size);
        this.drawString(text, x / size - (double)this.getStringWidth(text), y / size);
        GL11.glPopMatrix();
    }

    public void drawItem(zx item, double xPosition, double yPosition, String value) {
        avc.c();
        bfl.o();
        if (item.t()) {
            bfl.j();
            this.renderItemIntoGUI(item, xPosition, yPosition);
            bfl.i();
        } else {
            this.renderItemIntoGUI(item, xPosition, yPosition);
        }
        this.renderItemOverlayIntoGUI(item, xPosition, yPosition, value);
        bfl.i();
        bfl.f();
    }

    public void renderItemIntoGUI(zx stack, double x, double y) {
        LabyModCore.getRenderImplementation().renderItemIntoGUI(stack, x, y);
    }

    private void renderItemOverlayIntoGUI(zx stack, double xPosition, double yPosition, String text) {
        LabyModCore.getRenderImplementation().renderItemOverlayIntoGUI(stack, xPosition, yPosition, text);
    }

    public int getStringWidth(String text) {
        return this.fontRenderer.a(text);
    }

    public void drawRect(double left, double top, double right, double bottom, int color) {
        if (left < right) {
            double i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            double j = top;
            top = bottom;
            bottom = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        bfx tessellator = bfx.a();
        WorldRendererAdapter worldrenderer = LabyModCore.getWorldRenderer();
        bfl.l();
        bfl.x();
        bfl.a((int)770, (int)771, (int)1, (int)0);
        bfl.c((float)f, (float)f1, (float)f2, (float)f3);
        worldrenderer.begin(7, bms.e);
        worldrenderer.pos(left, bottom, 0.0).endVertex();
        worldrenderer.pos(right, bottom, 0.0).endVertex();
        worldrenderer.pos(right, top, 0.0).endVertex();
        worldrenderer.pos(left, top, 0.0).endVertex();
        tessellator.b();
        bfl.w();
        bfl.k();
    }

    public boolean drawRect(int mouseX, int mouseY, double left, double top, double right, double bottom, int color, int hoverColor) {
        boolean hover = (double)mouseX > left && (double)mouseX < right && (double)mouseY > top && (double)mouseY < bottom;
        this.drawRect(left, top, right, bottom, hover ? hoverColor : color);
        return hover;
    }

    public boolean drawRect(int mouseX, int mouseY, String displayString, double left, double top, double right, double bottom, int color, int hoverColor) {
        boolean hover = (double)mouseX > left && (double)mouseX < right && (double)mouseY > top && (double)mouseY < bottom;
        this.drawRect(left, top, right, bottom, hover ? hoverColor : color);
        this.drawCenteredString(displayString, left + (right - left) / 2.0, top + (bottom - top) / 2.0 - 4.0);
        return hover;
    }

    public void drawRectangle(int left, int top, int right, int bottom, int color) {
        DrawUtils.a((int)left, (int)top, (int)right, (int)bottom, (int)color);
    }

    public void drawGradientShadowTop(double y, double left, double right) {
        bfx tessellator = bfx.a();
        WorldRendererAdapter worldrenderer = LabyModCore.getWorldRenderer();
        int i1 = 4;
        bfl.l();
        bfl.a((int)770, (int)771, (int)0, (int)1);
        bfl.c();
        bfl.j((int)7425);
        bfl.w();
        this.mc.P().a(LabyModCore.getRenderImplementation().getOptionsBackground());
        worldrenderer.begin(7, bms.i);
        worldrenderer.pos(left, y + (double)i1, 0.0).tex(0.0, 1.0).color(0, 0, 0, 0).endVertex();
        worldrenderer.pos(right, y + (double)i1, 0.0).tex(1.0, 1.0).color(0, 0, 0, 0).endVertex();
        worldrenderer.pos(right, y, 0.0).tex(1.0, 0.0).color(0, 0, 0, 255).endVertex();
        worldrenderer.pos(left, y, 0.0).tex(0.0, 0.0).color(0, 0, 0, 255).endVertex();
        tessellator.b();
        bfl.j((int)7424);
        bfl.d();
        bfl.k();
    }

    public void drawGradientShadowBottom(double y, double left, double right) {
        bfx tessellator = bfx.a();
        WorldRendererAdapter worldrenderer = LabyModCore.getWorldRenderer();
        int i1 = 4;
        bfl.l();
        bfl.a((int)770, (int)771, (int)0, (int)1);
        bfl.c();
        bfl.j((int)7425);
        bfl.w();
        this.mc.P().a(LabyModCore.getRenderImplementation().getOptionsBackground());
        worldrenderer.begin(7, bms.i);
        worldrenderer.pos(left, y, 0.0).tex(0.0, 1.0).color(0, 0, 0, 255).endVertex();
        worldrenderer.pos(right, y, 0.0).tex(1.0, 1.0).color(0, 0, 0, 255).endVertex();
        worldrenderer.pos(right, y - (double)i1, 0.0).tex(1.0, 0.0).color(0, 0, 0, 0).endVertex();
        worldrenderer.pos(left, y - (double)i1, 0.0).tex(0.0, 0.0).color(0, 0, 0, 0).endVertex();
        tessellator.b();
        bfl.j((int)7424);
        bfl.d();
        bfl.k();
    }

    public void drawGradientShadowLeft(double x, double top, double bottom) {
        bfx tessellator = bfx.a();
        WorldRendererAdapter worldrenderer = LabyModCore.getWorldRenderer();
        int i1 = 4;
        bfl.l();
        bfl.a((int)770, (int)771, (int)0, (int)1);
        bfl.c();
        bfl.j((int)7425);
        bfl.w();
        this.mc.P().a(LabyModCore.getRenderImplementation().getOptionsBackground());
        worldrenderer.begin(7, bms.i);
        worldrenderer.pos(x + (double)i1, bottom, 0.0).tex(1.0, 0.0).color(0, 0, 0, 0).endVertex();
        worldrenderer.pos(x + (double)i1, top, 0.0).tex(1.0, 1.0).color(0, 0, 0, 0).endVertex();
        worldrenderer.pos(x, top, 0.0).tex(0.0, 1.0).color(0, 0, 0, 255).endVertex();
        worldrenderer.pos(x, bottom, 0.0).tex(0.0, 0.0).color(0, 0, 0, 255).endVertex();
        tessellator.b();
        bfl.j((int)7424);
        bfl.d();
        bfl.k();
    }

    public void drawGradientShadowRight(double x, double top, double bottom) {
        bfx tessellator = bfx.a();
        WorldRendererAdapter worldrenderer = LabyModCore.getWorldRenderer();
        int i1 = 4;
        bfl.l();
        bfl.a((int)770, (int)771, (int)0, (int)1);
        bfl.c();
        bfl.j((int)7425);
        bfl.w();
        this.mc.P().a(LabyModCore.getRenderImplementation().getOptionsBackground());
        worldrenderer.begin(7, bms.i);
        worldrenderer.pos(x, bottom, 0.0).tex(1.0, 0.0).color(0, 0, 0, 255).endVertex();
        worldrenderer.pos(x, top, 0.0).tex(1.0, 1.0).color(0, 0, 0, 255).endVertex();
        worldrenderer.pos(x - (double)i1, top, 0.0).tex(0.0, 1.0).color(0, 0, 0, 0).endVertex();
        worldrenderer.pos(x - (double)i1, bottom, 0.0).tex(0.0, 0.0).color(0, 0, 0, 0).endVertex();
        tessellator.b();
        bfl.j((int)7424);
        bfl.d();
        bfl.k();
    }

    public void drawIngameBackground() {
        this.a(0, 0, this.getWidth(), this.getHeight(), -1072689136, -804253680);
    }

    public void drawAutoDimmedBackground(double d) {
        if (LabyMod.getInstance().isInGame()) {
            this.drawIngameBackground();
        } else {
            this.drawDimmedBackground((int)d);
        }
    }

    public void drawAutoDimmedBackground(int left, int top, int right, int bottom) {
        if (LabyMod.getInstance().isInGame()) {
            this.a(left, top, right, bottom, -1072689136, -804253680);
        } else {
            this.drawDimmedOverlayBackground(left, top, right, bottom);
        }
    }

    public void drawBackground(int tint) {
        this.drawBackground(tint, 0.0, 64);
    }

    public void drawDimmedBackground(int scroll) {
        this.drawBackground(0, -scroll, 32);
    }

    public void drawBackground(int tint, double scrolling, int brightness) {
        bfl.f();
        bfl.n();
        bfx tessellator = bfx.a();
        WorldRendererAdapter worldrenderer = LabyModCore.getWorldRenderer();
        this.mc.P().a(LabyModCore.getRenderImplementation().getOptionsBackground());
        bfl.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        worldrenderer.begin(7, bms.i);
        worldrenderer.pos(0.0, this.getHeight(), 0.0).tex(0.0, ((double)this.getHeight() + scrolling) / 32.0 + (double)tint).color(brightness, brightness, brightness, 255).endVertex();
        worldrenderer.pos(this.getWidth(), this.getHeight(), 0.0).tex((float)this.getWidth() / 32.0f, ((double)this.getHeight() + scrolling) / 32.0 + (double)tint).color(brightness, brightness, brightness, 255).endVertex();
        worldrenderer.pos(this.getWidth(), 0.0, 0.0).tex((float)this.getWidth() / 32.0f, (double)tint + scrolling / 32.0).color(brightness, brightness, brightness, 255).endVertex();
        worldrenderer.pos(0.0, 0.0, 0.0).tex(0.0, (double)tint + scrolling / 32.0).color(brightness, brightness, brightness, 255).endVertex();
        tessellator.b();
    }

    public void drawOverlayBackground(int startY, int endY) {
        int endAlpha = 255;
        int startAlpha = 255;
        bfx tessellator = bfx.a();
        WorldRendererAdapter worldrenderer = LabyModCore.getWorldRenderer();
        this.mc.P().a(LabyModCore.getRenderImplementation().getOptionsBackground());
        bfl.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        worldrenderer.begin(7, bms.i);
        worldrenderer.pos(0.0, endY, 0.0).tex(0.0, (float)endY / 32.0f).color(64, 64, 64, endAlpha).endVertex();
        worldrenderer.pos(0 + this.getWidth(), endY, 0.0).tex((float)this.getWidth() / 32.0f, (float)endY / 32.0f).color(64, 64, 64, endAlpha).endVertex();
        worldrenderer.pos(0 + this.getWidth(), startY, 0.0).tex((float)this.getWidth() / 32.0f, (float)startY / 32.0f).color(64, 64, 64, startAlpha).endVertex();
        worldrenderer.pos(0.0, startY, 0.0).tex(0.0, (float)startY / 32.0f).color(64, 64, 64, startAlpha).endVertex();
        tessellator.b();
    }

    public void drawDimmedOverlayBackground(int left, int top, int right, int bottom) {
        bfl.f();
        bfl.n();
        bfx tessellator = bfx.a();
        WorldRendererAdapter worldrenderer = LabyModCore.getWorldRenderer();
        this.mc.P().a(LabyModCore.getRenderImplementation().getOptionsBackground());
        bfl.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        worldrenderer.begin(7, bms.i);
        worldrenderer.pos(left, bottom, 0.0).tex((float)left / f, (float)bottom / f).color(32, 32, 32, 255).endVertex();
        worldrenderer.pos(right, bottom, 0.0).tex((float)right / f, (float)bottom / f).color(32, 32, 32, 255).endVertex();
        worldrenderer.pos(right, top, 0.0).tex((float)right / f, (float)top / f).color(32, 32, 32, 255).endVertex();
        worldrenderer.pos(left, top, 0.0).tex((float)left / f, (float)top / f).color(32, 32, 32, 255).endVertex();
        tessellator.b();
        bfl.l();
        bfl.a((int)770, (int)771, (int)0, (int)1);
        bfl.c();
        bfl.j((int)7425);
        bfl.i();
    }

    public void drawOverlayBackground(int startX, int startY, int width, int endY) {
        this.drawOverlayBackground(startX, startY, width, endY, 64);
    }

    public void drawOverlayBackground(int startX, int startY, int width, int endY, int brightness) {
        int endAlpha = 255;
        int startAlpha = 255;
        bfx tessellator = bfx.a();
        WorldRendererAdapter worldrenderer = LabyModCore.getWorldRenderer();
        this.mc.P().a(LabyModCore.getRenderImplementation().getOptionsBackground());
        bfl.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        worldrenderer.begin(7, bms.i);
        worldrenderer.pos(startX, endY, 0.0).tex(0.0, (float)endY / 32.0f).color(brightness, brightness, brightness, endAlpha).endVertex();
        worldrenderer.pos(startX + width, endY, 0.0).tex((float)width / 32.0f, (float)endY / 32.0f).color(brightness, brightness, brightness, endAlpha).endVertex();
        worldrenderer.pos(startX + width, startY, 0.0).tex((float)width / 32.0f, (float)startY / 32.0f).color(brightness, brightness, brightness, startAlpha).endVertex();
        worldrenderer.pos(startX, startY, 0.0).tex(0.0, (float)startY / 32.0f).color(brightness, brightness, brightness, startAlpha).endVertex();
        tessellator.b();
    }

    public void drawTexturedModalRect(double x, double y, double textureX, double textureY, double width, double height) {
        this.b((int)x, (int)y, (int)textureX, (int)textureY, (int)width, (int)height);
    }

    public void drawTexturedModalRect(double left, double top, double right, double bottom) {
        double textureX = 0.0;
        double textureY = 0.0;
        double x = left;
        double y = top;
        double width = right - left;
        double height = bottom - top;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        bfx tessellator = bfx.a();
        WorldRendererAdapter worldrenderer = LabyModCore.getWorldRenderer();
        worldrenderer.begin(7, bms.g);
        worldrenderer.pos(x + 0.0, y + height, this.e).tex((float)(textureX + 0.0) * f, (float)(textureY + height) * f1).endVertex();
        worldrenderer.pos(x + width, y + height, this.e).tex((float)(textureX + width) * f, (float)(textureY + height) * f1).endVertex();
        worldrenderer.pos(x + width, y + 0.0, this.e).tex((float)(textureX + width) * f, (float)(textureY + 0.0) * f1).endVertex();
        worldrenderer.pos(x + 0.0, y + 0.0, this.e).tex((float)(textureX + 0.0) * f, (float)(textureY + 0.0) * f1).endVertex();
        tessellator.b();
    }

    public void drawTexture(double x, double y, double imageWidth, double imageHeight, double maxWidth, double maxHeight, float alpha) {
        GL11.glPushMatrix();
        double sizeWidth = maxWidth / imageWidth;
        double sizeHeight = maxHeight / imageHeight;
        GL11.glScaled((double)sizeWidth, (double)sizeHeight, (double)0.0);
        if (alpha <= 1.0f) {
            bfl.d();
            bfl.l();
            bfl.c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        }
        this.drawTexturedModalRect(x / sizeWidth, y / sizeHeight, x / sizeWidth + imageWidth, y / sizeHeight + imageHeight);
        if (alpha <= 1.0f) {
            bfl.c();
            bfl.k();
        }
        GL11.glPopMatrix();
    }

    public void drawRawTexture(double x, double y, double imageWidth, double imageHeight, double maxWidth, double maxHeight) {
        GL11.glPushMatrix();
        double sizeWidth = maxWidth / imageWidth;
        double sizeHeight = maxHeight / imageHeight;
        GL11.glScaled((double)sizeWidth, (double)sizeHeight, (double)0.0);
        this.drawTexturedModalRect(x / sizeWidth, y / sizeHeight, x / sizeWidth + imageWidth, y / sizeHeight + imageHeight);
        GL11.glPopMatrix();
    }

    public void drawTexture(double x, double y, double imageWidth, double imageHeight, double maxWidth, double maxHeight) {
        this.drawTexture(x, y, imageWidth, imageHeight, maxWidth, maxHeight, 1.0f);
    }

    public void drawTexture(double x, double y, double texturePosX, double texturePosY, double imageWidth, double imageHeight, double maxWidth, double maxHeight, float alpha) {
        GL11.glPushMatrix();
        double sizeWidth = maxWidth / imageWidth;
        double sizeHeight = maxHeight / imageHeight;
        GL11.glScaled((double)sizeWidth, (double)sizeHeight, (double)0.0);
        if (alpha <= 1.0f) {
            bfl.d();
            bfl.l();
            bfl.c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        }
        this.drawUVTexture(x / sizeWidth, y / sizeHeight, texturePosX, texturePosY, x / sizeWidth + imageWidth - x / sizeWidth, y / sizeHeight + imageHeight - y / sizeHeight);
        if (alpha <= 1.0f) {
            bfl.c();
            bfl.k();
        }
        GL11.glPopMatrix();
    }

    public void drawTexture(double x, double y, double texturePosX, double texturePosY, double imageWidth, double imageHeight, double maxWidth, double maxHeight) {
        this.drawTexture(x, y, texturePosX, texturePosY, imageWidth, imageHeight, maxWidth, maxHeight, 1.0f);
    }

    private void drawUVTexture(double x, double y, double textureX, double textureY, double width, double height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        bfx tessellator = bfx.a();
        WorldRendererAdapter worldrenderer = LabyModCore.getWorldRenderer();
        worldrenderer.begin(7, bms.g);
        worldrenderer.pos(x + 0.0, y + height, this.e).tex((float)(textureX + 0.0) * f, (float)(textureY + height) * f1).endVertex();
        worldrenderer.pos(x + width, y + height, this.e).tex((float)(textureX + width) * f, (float)(textureY + height) * f1).endVertex();
        worldrenderer.pos(x + width, y + 0.0, this.e).tex((float)(textureX + width) * f, (float)(textureY + 0.0) * f1).endVertex();
        worldrenderer.pos(x + 0.0, y + 0.0, this.e).tex((float)(textureX + 0.0) * f, (float)(textureY + 0.0) * f1).endVertex();
        tessellator.b();
    }

    public static void drawEntityOnScreen(int x, int y, int size, float mouseX, float mouseY, int rotationX, int rotationY, int rotationZ, pr entity) {
        bfl.g();
        bfl.E();
        bfl.b((float)x, (float)y, (float)100.0f);
        bfl.a((float)((float)(-size) - 30.0f), (float)((float)size + 30.0f), (float)size);
        bfl.b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float var5 = entity.aJ;
        float var6 = entity.aI;
        float var7 = entity.y;
        float var8 = entity.z;
        float var9 = entity.aL;
        float var10 = entity.aK;
        bfl.b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        avc.b();
        bfl.b((float)(-135.0f + (float)rotationX), (float)0.0f, (float)1.0f, (float)0.0f);
        bfl.b((float)rotationY, (float)1.0f, (float)0.0f, (float)0.0f);
        bfl.b((float)rotationZ, (float)0.0f, (float)0.0f, (float)1.0f);
        bfl.b((float)(-((float)Math.atan(mouseY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        entity.aI = (float)Math.atan(mouseX / 40.0f) * 20.0f;
        entity.y = (float)Math.atan(mouseX / 40.0f) * 40.0f;
        entity.z = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        entity.aK = entity.y;
        entity.aL = entity.y;
        entity.aJ = entity.aI;
        bfl.b((float)0.0f, (float)0.0f, (float)0.0f);
        biu var11 = ave.A().af();
        var11.a(180.0f);
        var11.a(false);
        LabyModCore.getRenderImplementation().renderEntity(var11, (pk)entity, 0.0, rotationY == 0 ? 0.0 : -1.0, 0.0, 0.0f, 1.0f, false);
        var11.a(true);
        entity.aI = var6;
        entity.y = var7;
        entity.z = var8;
        entity.aJ = var5;
        entity.aL = var9;
        entity.aK = var10;
        bfl.F();
        avc.a();
        bfl.C();
        bfl.g((int)bqs.r);
        bfl.x();
        bfl.g((int)bqs.q);
    }

    public String trimStringToWidth(String text, int width) {
        if (text == null) {
            return text;
        }
        return this.fontRenderer.a(text, width, false);
    }

    public List<String> listFormattedStringToWidth(String str, int wrapWidth) {
        if (wrapWidth < 10) {
            wrapWidth = 10;
        }
        return this.fontRenderer.c(str, wrapWidth);
    }

    public List<String> listFormattedStringToWidth(String str, int wrapWidth, int maxLines) {
        List<String> list = this.listFormattedStringToWidth(str, wrapWidth);
        if (list.size() < maxLines) {
            return list;
        }
        ArrayList<String> output = new ArrayList<String>();
        int count = 0;
        for (String line : list) {
            output.add(line);
            if (++count < maxLines) continue;
            break;
        }
        return output;
    }

    public void drawHoveringText(int x, int y, String ... textLines) {
        if (textLines.length != 0) {
            bfl.C();
            avc.a();
            bfl.f();
            bfl.i();
            int i = 0;
            for (String s : textLines) {
                int j = this.fontRenderer.a(s);
                if (j <= i) continue;
                i = j;
            }
            int l1 = x + 7;
            int i2 = y - 12;
            int k = 8;
            if (textLines.length > 1) {
                k += 2 + (textLines.length - 1) * 10;
            }
            if (i2 < 5) {
                i2 = 5;
            }
            if (l1 + i > this.getWidth()) {
                l1 -= 12 + i;
            }
            if (i2 + k + 6 > this.getHeight()) {
                i2 = this.getHeight() - k - 6;
            }
            this.e = 300.0f;
            int l = -267386864;
            this.a(l1 - 3, i2 - 4, l1 + i + 3, i2 - 3, l, l);
            this.a(l1 - 3, i2 + k + 3, l1 + i + 3, i2 + k + 4, l, l);
            this.a(l1 - 3, i2 - 3, l1 + i + 3, i2 + k + 3, l, l);
            this.a(l1 - 4, i2 - 3, l1 - 3, i2 + k + 3, l, l);
            this.a(l1 + i + 3, i2 - 3, l1 + i + 4, i2 + k + 3, l, l);
            int i1 = 0x505000FF;
            int j1 = (i1 & 0xFEFEFE) >> 1 | i1 & 0xFF000000;
            this.a(l1 - 3, i2 - 3 + 1, l1 - 3 + 1, i2 + k + 3 - 1, i1, j1);
            this.a(l1 + i + 2, i2 - 3 + 1, l1 + i + 3, i2 + k + 3 - 1, i1, j1);
            this.a(l1 - 3, i2 - 3, l1 + i + 3, i2 - 3 + 1, i1, i1);
            this.a(l1 - 3, i2 + k + 2, l1 + i + 3, i2 + k + 3, j1, j1);
            for (int k1 = 0; k1 < textLines.length; ++k1) {
                String s1 = textLines[k1];
                this.fontRenderer.a(s1, (float)l1, (float)i2, -1);
                if (k1 == 0) {
                    i2 += 2;
                }
                i2 += 10;
            }
            this.e = 0.0f;
        }
    }

    public void drawHoveringTextBoxField(int x, int y, int width, int height) {
        this.e = 300.0f;
        int color1 = -267386864;
        this.a(x - 3, y - 4, x + width + 3, y - 3, color1, color1);
        this.a(x - 3, y + height + 3, x + width + 3, y + height + 4, color1, color1);
        this.a(x - 3, y - 3, x + width + 3, y + height + 3, color1, color1);
        this.a(x - 4, y - 3, x - 3, y + height + 3, color1, color1);
        this.a(x + width + 3, y - 3, x + width + 4, y + height + 3, color1, color1);
        int color2 = 0x505000FF;
        int color3 = (color2 & 0xFEFEFE) >> 1 | color2 & 0xFF000000;
        this.a(x - 3, y - 3 + 1, x - 3 + 1, y + height + 3 - 1, color2, color3);
        this.a(x + width + 2, y - 3 + 1, x + width + 3, y + height + 3 - 1, color2, color3);
        this.a(x - 3, y - 3, x + width + 3, y - 3 + 1, color2, color2);
        this.a(x - 3, y + height + 2, x + width + 3, y + height + 3, color3, color3);
        this.e = 0.0f;
        bfl.i();
    }

    public void drawPlayerHead(jy resourceLocation, int x, int y, int size) {
        if (resourceLocation == null) {
            resourceLocation = bmz.a((UUID)UUID.randomUUID());
        }
        bfl.d();
        ave.A().P().a(resourceLocation);
        DrawUtils.a((int)x, (int)y, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)size, (int)size, (float)64.0f, (float)64.0f);
        DrawUtils.a((int)x, (int)y, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)size, (int)size, (float)64.0f, (float)64.0f);
    }

    public void drawPlayerHead(GameProfile gameProfile, int x, int y, int size) {
        jy resourceLocation = this.playerSkinTextureCache.getSkinTexture(gameProfile);
        this.drawPlayerHead(resourceLocation, x, y, size);
    }

    public void drawPlayerHead(String username, int x, int y, int size) {
        jy resourceLocation = this.playerSkinTextureCache.getSkinTexture(username);
        this.drawPlayerHead(resourceLocation, x, y, size);
    }

    public void drawPlayerHead(UUID uuid, int x, int y, int size) {
        jy resourceLocation = this.playerSkinTextureCache.getSkinTexture(uuid);
        this.drawPlayerHead(resourceLocation, x, y, size);
    }

    @Deprecated
    public void drawMinotarHead(GameProfile gameProfile, int x, int y, int size) {
        this.drawPlayerHead(gameProfile, x, y, size);
    }

    public void drawRectBorder(double left, double top, double right, double bottom, int color, double thickness) {
        this.drawRect(left + thickness, top, right - thickness, top + thickness, color);
        this.drawRect(right - thickness, top, right, bottom, color);
        this.drawRect(left + thickness, bottom - thickness, right - thickness, bottom, color);
        this.drawRect(left, top, left + thickness, bottom, color);
    }

    public void drawImageUrl(String url, double x, double y, double imageWidth, double imageHeight, double maxWidth, double maxHeight) {
        this.drawDynamicImageUrl(url, url, x, y, imageWidth, imageHeight, maxWidth, maxHeight);
    }

    public void drawDynamicImageUrl(String identifier, String url, double x, double y, double imageWidth, double imageHeight, double maxWidth, double maxHeight) {
        jy resourceLocation = LabyMod.getInstance().getDynamicTextureManager().getTexture(identifier, url);
        ave.A().P().a(resourceLocation);
        LabyMod.getInstance().getDrawUtils().drawTexture(x, y, imageWidth, imageHeight, maxWidth, maxHeight);
    }

    public void renderSkull(GameProfile gameProfile) {
        bbz modelbase = this.humanoidHead;
        jy resourceSkin = this.playerSkinTextureCache.getSkinTexture(gameProfile);
        if (resourceSkin != null) {
            ave.A().P().a(resourceSkin);
            bfl.E();
            bfl.p();
            bfl.B();
            bfl.d();
            bfl.a((float)-1.0f, (float)1.0f, (float)1.0f);
            bfl.b((float)0.0f, (float)0.2f, (float)0.0f);
            modelbase.a(null, 0.0f, 0.0f, 0.0f, 180.0f, 0.0f, 0.0625f);
            bfl.F();
        }
    }
}

