/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.sticker;

import com.google.common.util.concurrent.FutureCallback;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import net.labymod.api.EventManager;
import net.labymod.api.events.ServerMessageEvent;
import net.labymod.core.LabyModCore;
import net.labymod.labyconnect.packets.PacketActionPlayResponse;
import net.labymod.main.LabyMod;
import net.labymod.support.util.Debug;
import net.labymod.user.User;
import net.labymod.user.UserManager;
import net.labymod.user.gui.StickerSelectorGui;
import net.labymod.user.sticker.data.Sticker;
import net.labymod.user.sticker.data.StickerData;
import net.labymod.user.sticker.data.StickerPack;
import net.labymod.utils.ModColor;
import net.labymod.utils.request.DownloadServerRequest;
import net.labymod.utils.request.RequestException;
import net.labymod.utils.request.ServerResponse;

public class StickerRegistry
implements ServerMessageEvent {
    public static final long STICKER_DURATION = 4000L;
    private StickerSelectorGui stickerSelectorGui = new StickerSelectorGui();
    protected StickerData stickerData;

    public void init() {
        EventManager eventManager = LabyMod.getInstance().getEventManager();
        eventManager.register(this);
        this.loadPacks();
    }

    public void loadPacks() {
        DownloadServerRequest.getStringAsync("https://dl.labymod.net/stickers.json", new ServerResponse<String>(){

            @Override
            public void success(String json) {
                StickerRegistry.this.stickerData = (StickerData)new Gson().fromJson(json, StickerData.class);
            }

            @Override
            public void failed(RequestException exception) {
                exception.printStackTrace();
                Debug.log(Debug.EnumDebugMode.EMOTE, "Stickerdata response code is " + exception.getCode());
            }
        });
    }

    @Override
    public void onServerMessage(String messageKey, JsonElement serverMessage) {
        if (!messageKey.equals("sticker_api")) {
            return;
        }
        JsonArray array = serverMessage.getAsJsonArray();
        for (int i = 0; i < array.size(); ++i) {
            JsonObject object = array.get(i).getAsJsonObject();
            if (!object.has("uuid") || !object.has("sticker_id")) continue;
            UUID uuid = UUID.fromString(object.get("uuid").getAsString());
            short stickerId = object.get("sticker_id").getAsShort();
            UserManager userManager = LabyMod.getInstance().getUserManager();
            this.handleSticker(userManager.getUser(uuid), stickerId);
        }
    }

    public void playSticker(User user, final short stickerId) {
        if (LabyModCore.getMinecraft().getPlayer() == null || !LabyMod.getSettings().stickers) {
            Debug.log(Debug.EnumDebugMode.STICKER, "Playing sticker canceled because sticker are disabled or player is null.");
            return;
        }
        if (!LabyMod.getInstance().getLabyConnect().isOnline()) {
            LabyMod.getInstance().displayMessageInChat(ModColor.cl('c') + LabyMod.getMessage("sticker_error_not_connected", new Object[0]));
            Debug.log(Debug.EnumDebugMode.STICKER, "Playing sticker canceled because player is not connected to labymod chat!");
            return;
        }
        byte[] stickerIdBytes = this.shortToBytes(stickerId);
        Debug.log(Debug.EnumDebugMode.STICKER, "Request labymod chat to play sticker id " + stickerId);
        LabyMod.getInstance().getUserManager().requestAction((short)3, stickerIdBytes, new FutureCallback<PacketActionPlayResponse>(){

            public void onSuccess(PacketActionPlayResponse responsePacket) {
                if (responsePacket == null || !responsePacket.isAllowed()) {
                    Debug.log(Debug.EnumDebugMode.LABYMOD_CHAT, responsePacket == null ? "Response timed out" : "Response packet: " + responsePacket.getReason());
                    if (stickerId != -1) {
                        String message = null;
                        message = responsePacket == null ? LabyMod.getMessage("sticker_no_response", new Object[0]) : (responsePacket.getReason().startsWith("illegal sticker use") ? LabyMod.getMessage("sticker_error_illegal_sticker", new Object[0]) : responsePacket.getReason());
                        LabyMod.getInstance().displayMessageInChat(ModColor.cl('c') + message);
                    }
                    return;
                }
            }

            public void onFailure(Throwable throwable) {
                throwable.printStackTrace();
                LabyMod.getInstance().displayMessageInChat(ModColor.cl('c') + "Error: " + throwable.getMessage());
            }
        });
    }

    public Sticker getSticker(short id) {
        for (StickerPack stickerPack : this.stickerData.getPacks()) {
            for (Sticker sticker : stickerPack.getStickers()) {
                if (sticker.getId() != id) continue;
                return sticker;
            }
        }
        return null;
    }

    public void handleSticker(User user, short id) {
        user.setPlayingSticker(id);
        if (id != -1) {
            user.setStickerStartedPlaying(System.currentTimeMillis());
        }
    }

    public void stopSticker(User user) {
        this.handleSticker(user, (short)-1);
    }

    public short bytesToShort(byte[] bytes) {
        return ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getShort();
    }

    public byte[] shortToBytes(short value) {
        byte[] bytes = new byte[2];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).putShort(value);
        return bytes;
    }

    public StickerSelectorGui getStickerSelectorGui() {
        return this.stickerSelectorGui;
    }

    public StickerData getStickerData() {
        return this.stickerData;
    }
}

