/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.gui;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.labymod.core.LabyModCore;
import net.labymod.gui.elements.ModTextField;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.splash.SplashLoader;
import net.labymod.splash.dailyemotes.DailyEmote;
import net.labymod.user.User;
import net.labymod.user.UserManager;
import net.labymod.user.emote.EmoteRegistry;
import net.labymod.user.emote.EmoteRenderer;
import net.labymod.user.emote.keys.EmoteKeyFrame;
import net.labymod.user.emote.keys.EmotePose;
import net.labymod.user.emote.keys.provider.KeyFrameStorage;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class EmoteSelectorGui
extends avp {
    private static final int ANIMATION_SPEED = 100;
    private static Field fieldPressTime;
    private static Field fieldLeftClickCounter;
    private static long emoteCooldownEnd;
    private long lastOpened;
    private int selectedItemIndex;
    private boolean open = false;
    private float lockedYaw = 0.0f;
    private float lockedPitch = 0.0f;
    private boolean prevCrosshairState;
    private short lastHoveredEmoteId = (short)-1;
    private boolean emotesLocked = false;
    private boolean emotesOnCooldown = false;
    private int page = 0;
    private int acceptedPage = 0;
    private int animationState = 0;
    private long pageAnimation = 0L;
    private int scrollSelectedEmote = -1;
    private List<Short> filteredEmotes;
    private boolean searchOpened = false;
    private boolean dailyEmotes = false;
    private int searchMouseX;
    private int searchMouseY;

    public void open() {
        if (this.open || ave.A().t.aA) {
            return;
        }
        bew player = LabyModCore.getMinecraft().getPlayer();
        if (player == null) {
            return;
        }
        if (fieldLeftClickCounter == null) {
            try {
                fieldLeftClickCounter = ReflectionHelper.findField(ave.class, LabyModCore.getMappingAdapter().getLeftClickCounterMappings());
                fieldLeftClickCounter.setAccessible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.page = 0;
        this.open = true;
        this.selectedItemIndex = LabyModCore.getMinecraft().getPlayer().bi.c;
        this.scrollSelectedEmote = -1;
        this.lockedYaw = player.y;
        this.lockedPitch = player.z;
        this.prevCrosshairState = LabyMod.getInstance().getLabyModAPI().isCrosshairHidden();
        LabyMod.getInstance().getLabyModAPI().setCrosshairHidden(true);
        if (fieldPressTime == null) {
            try {
                fieldPressTime = ReflectionHelper.findField(avb.class, LabyModCore.getMappingAdapter().getPressTimeMappings());
                fieldPressTime.setAccessible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.dailyEmotes = this.hasDailyEmotes(player);
        if (this.isEmotePlaying(player)) {
            this.emotesLocked = true;
        }
        UserManager userManager = LabyMod.getInstance().getUserManager();
        if (System.currentTimeMillis() - this.lastOpened < 300L && userManager.getGroupManager().hasPermissionOf(userManager.getUser(player.aK()), (short)10)) {
            ave.A().a((axu)new SearchGui(this));
            this.searchOpened = true;
            this.animationState = 0;
        } else {
            this.searchOpened = false;
        }
        this.lastOpened = System.currentTimeMillis();
        this.filter("");
    }

    public void close() {
        if (!this.open) {
            return;
        }
        this.open = false;
        LabyMod.getInstance().getLabyModAPI().setCrosshairHidden(this.prevCrosshairState);
        this.updateScrollLock(false);
        bew player = LabyModCore.getMinecraft().getPlayer();
        if (player == null) {
            return;
        }
        player.y = this.lockedYaw;
        player.z = this.lockedPitch;
        if (this.lastHoveredEmoteId != -1) {
            emoteCooldownEnd = System.currentTimeMillis() + 5000L;
            LabyMod.getInstance().getEmoteRegistry().playEmote(this.lastHoveredEmoteId);
        }
    }

    public void pointSearchMouse(int mouseX, int mouseY) {
        this.searchMouseX = mouseX;
        this.searchMouseY = mouseY;
    }

    public void filter(String searchString) {
        bew player = LabyModCore.getMinecraft().getPlayer();
        User user = LabyMod.getInstance().getUserManager().getUser(player.aK());
        if (searchString.isEmpty()) {
            this.filteredEmotes = user.getEmotes();
        } else {
            searchString = searchString.toLowerCase();
            Map<Short, KeyFrameStorage> sources = LabyMod.getInstance().getEmoteRegistry().getEmoteSources();
            ArrayList<Short> filteredEmotes = new ArrayList<Short>();
            for (Short id : user.getEmotes()) {
                KeyFrameStorage storage = sources.get(id);
                if (storage == null || !storage.getName().toLowerCase().contains(searchString)) continue;
                filteredEmotes.add(id);
            }
            this.filteredEmotes = filteredEmotes;
        }
    }

    private boolean hasDailyEmotes(bew player) {
        UserManager userManager = LabyMod.getInstance().getUserManager();
        User user = userManager.getUser(player.aK());
        if (SplashLoader.getLoader() == null || SplashLoader.getLoader().getEntries() == null) {
            return false;
        }
        DailyEmote[] dailyEmotes = SplashLoader.getLoader().getEntries().getDailyEmotes();
        return dailyEmotes != null && dailyEmotes.length != 0 && user.isDailyEmoteFlat();
    }

    private boolean isEmotePlaying(bew player) {
        EmoteRenderer renderer = LabyMod.getInstance().getEmoteRegistry().getEmoteRendererFor((bet)player);
        return renderer != null && renderer.isVisible() && !renderer.isStream();
    }

    public void render() {
        long timePassed;
        if (!this.open) {
            return;
        }
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        bew player = LabyModCore.getMinecraft().getPlayer();
        if (player == null || player.aK() == null || player.au != 0) {
            this.close();
            return;
        }
        try {
            if (fieldLeftClickCounter != null) {
                fieldLeftClickCounter.setInt(ave.A(), 2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.emotesLocked && !this.isEmotePlaying(player)) {
            this.emotesLocked = false;
        }
        double radiusMouseBorder = (double)draw.getHeight() / 4.0 / 3.0;
        double midX = (double)draw.getWidth() / 2.0;
        double midY = (double)draw.getHeight() / 2.0;
        double lockedX = this.lockedYaw;
        double lockedY = this.lockedPitch;
        if (lockedY + radiusMouseBorder > 90.0) {
            lockedY = (float)(90.0 - radiusMouseBorder);
        }
        if (lockedY - radiusMouseBorder < -90.0) {
            lockedY = (float)(-90.0 + radiusMouseBorder);
        }
        if ((timePassed = System.currentTimeMillis() - this.lastOpened) > 2000L) {
            timePassed = 2000L;
        }
        double radius = (double)draw.getHeight() / 4.0 - Math.exp((double)(-timePassed) / 100.0) * 10.0;
        double offsetX = lockedX - (double)player.y;
        double offsetY = lockedY - (double)player.z;
        double distance = Math.sqrt(offsetX * offsetX + offsetY * offsetY);
        double cursorX = midX - offsetX * 1.5;
        double cursorY = midY - offsetY * 1.5;
        if (this.searchOpened) {
            cursorX = this.searchMouseX;
            cursorY = this.searchMouseY;
            offsetX = this.searchMouseX - draw.getWidth() / 2;
            offsetY = this.searchMouseY - draw.getHeight() / 2;
            distance = Math.sqrt(offsetX * offsetX + offsetY * offsetY);
        }
        bfl.E();
        if (ave.A().t.aB == 0 && !this.searchOpened) {
            midX += offsetX;
            midY += offsetY;
        }
        int totalEmotes = this.filteredEmotes.size();
        int amount = 6;
        int emoteIndex = this.page * amount;
        int maxPages = (int)Math.ceil((double)totalEmotes / (double)amount);
        boolean cooldown = this.emotesOnCooldown ? emoteCooldownEnd > System.currentTimeMillis() : false;
        boolean emotesEnabled = LabyMod.getSettings().emotes;
        String localeKey = emotesEnabled ? (this.emotesLocked ? "emote_status_already_playing" : (totalEmotes == 0 ? (this.searchOpened ? "emote_status_not_found" : "emote_status_no_emotes") : (cooldown ? "emote_status_cooldown" : "emote_status_select"))) : "emote_status_disabled";
        String title = (this.emotesLocked || !emotesEnabled ? ModColor.cl('c') : "") + LabyMod.getMessage(localeKey, new Object[0]);
        draw.drawCenteredString(title, midX, midY - radius - 5.0);
        if (this.page == -1) {
            draw.drawCenteredString(ModColor.cl('b') + ModColor.cl('o') + "labymod.net/shop", midX, midY + radius + 6.0);
            draw.drawCenteredString(ModColor.cl('6') + LabyMod.getMessage("emote_daily", new Object[0]), midX, midY + radius - 5.0, 0.7);
        } else {
            if (totalEmotes == 0) {
                draw.drawCenteredString(ModColor.cl('b') + ModColor.cl('o') + "labymod.net/shop", midX, midY + radius - 5.0);
            } else if (maxPages > 1 && !this.searchOpened) {
                String keyName = "?";
                try {
                    keyName = Keyboard.getKeyName((int)LabyMod.getSettings().keyEmote).toLowerCase();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                draw.drawCenteredString(LabyMod.getMessage("emote_selector_page", this.page + 1, maxPages), midX, midY + radius - 5.0, 0.7);
                draw.drawCenteredString(ModColor.cl('7') + LabyMod.getMessage("emote_doubletap", keyName), midX, midY + radius + 6.0, 0.7);
            }
            if (maxPages == 1 && !this.searchOpened && this.dailyEmotes) {
                draw.drawCenteredString(LabyMod.getMessage("emote_own", new Object[0]), midX, midY + radius - 5.0, 0.7);
            }
        }
        if (!this.searchOpened) {
            double scale;
            double arrowWidth = 9.0;
            double arrowHeight = 6.0;
            double arrowAnimation = Math.abs(Math.sin((double)(System.currentTimeMillis() - this.pageAnimation) / (Math.PI * 9)) / 2.0);
            if (this.acceptedPage > (this.dailyEmotes ? -1 : 0)) {
                if (this.acceptedPage <= 0) {
                    GL11.glColor4f((float)1.0f, (float)0.7f, (float)0.0f, (float)1.0f);
                } else {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                scale = this.animationState == -1 ? arrowAnimation + 1.0 : 1.0;
                ave.A().P().a(ModTextures.MISC_ARROW);
                draw.drawTexture(midX - arrowWidth * scale / 2.0 - radius / 2.0, midY + radius - 2.0 - arrowHeight * scale / 2.0, 0.0, 0.0, 127.5, 255.0, arrowWidth * scale, arrowHeight * scale, 1.1f);
                ave.A().P().a(ModTextures.MISC_MOUSE);
                draw.drawTexture(midX - arrowWidth * scale / 2.0 - radius / 2.0 + 10.0 + 2.0, midY + radius - 4.0 - arrowHeight * scale / 2.0, 127.0, 0.0, 127.0, 255.0, 7.0 * scale, 10.0 * scale, 1.1f);
            }
            if (this.acceptedPage < maxPages - 1) {
                scale = this.animationState == 1 ? arrowAnimation + 1.0 : 1.0;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ave.A().P().a(ModTextures.MISC_ARROW);
                draw.drawTexture(midX - arrowWidth * scale / 2.0 + radius / 2.0, midY + radius - 2.0 - arrowHeight * scale / 2.0, 127.5, 0.0, 127.5, 255.0, arrowWidth * scale, arrowHeight * scale, 1.1f);
                ave.A().P().a(ModTextures.MISC_MOUSE);
                draw.drawTexture(midX - arrowWidth * scale / 2.0 + radius / 2.0 - 10.0, midY + radius - 4.0 - arrowHeight * scale / 2.0, 0.0, 0.0, 127.0, 255.0, 7.0 * scale, 10.0 * scale, 1.1f);
            }
        }
        bfl.d();
        bfl.l();
        this.lastHoveredEmoteId = (short)-1;
        if (this.animationState != 0) {
            double animation = (double)(System.currentTimeMillis() - this.pageAnimation) * 0.01 * radius;
            double speed = 1.0 * radius;
            midX = this.animationState == 1 || this.animationState == -1 ? (this.animationState == -1 ? (midX += animation) : (midX -= animation)) : (this.animationState == 2 ? (midX += speed - animation) : (midX -= speed - animation));
        }
        Map<Short, KeyFrameStorage> sources = LabyMod.getInstance().getEmoteRegistry().getEmoteSources();
        if (this.page == -1) {
            DailyEmote[] dailyEmotes = SplashLoader.getLoader().getEntries().getDailyEmotes();
            emoteIndex = 0;
            for (int index = amount; index >= 1; --index) {
                DailyEmote dailyEmote = emoteIndex >= dailyEmotes.length ? null : dailyEmotes[emoteIndex];
                KeyFrameStorage emote = dailyEmote == null ? null : sources.get(dailyEmote.getId());
                this.drawUnit(midX, midY, radius, amount, index, cursorX, cursorY, distance, emote, player);
                ++emoteIndex;
            }
        } else {
            for (int index = amount - 1; index >= 0; --index) {
                Short emoteId = emoteIndex >= totalEmotes ? null : this.filteredEmotes.get(emoteIndex);
                KeyFrameStorage emote = emoteId == null ? null : sources.get((short)emoteId);
                this.drawUnit(midX, midY, radius, amount, index, cursorX, cursorY, distance, emote, player);
                ++emoteIndex;
            }
        }
        bfl.c();
        bfl.k();
        bfl.F();
        if (offsetX == 0.0 && offsetY == 0.0) {
            cursorX = (int)cursorX;
            cursorY = (int)cursorY;
        }
        if (!this.searchOpened) {
            draw.drawRect(cursorX, cursorY - 4.0, cursorX + 1.0, cursorY + 5.0, Integer.MAX_VALUE);
            draw.drawRect(cursorX - 4.0, cursorY, cursorX + 5.0, cursorY + 1.0, Integer.MAX_VALUE);
            this.handleMouseInput(maxPages - 1);
        }
    }

    private void handleMouseInput(int maxPages) {
        boolean moveDown;
        double scroll = Mouse.getDWheel();
        boolean moveUp = scroll > 0.0;
        boolean bl = moveDown = scroll < 0.0;
        if (moveUp || moveDown) {
            int value = this.scrollSelectedEmote + (moveUp ? 1 : -1);
            this.scrollSelectedEmote = value < 0 ? 5 : value % 6;
        }
        try {
            int amount = 6;
            for (int i = 0; i < amount; ++i) {
                int code = ave.A().t.aw[i].i();
                if (code < 0 || !Keyboard.isKeyDown((int)code)) continue;
                this.scrollSelectedEmote = amount - 1 - i;
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
        if (this.acceptedPage == this.page && this.animationState == 0) {
            if (Mouse.isButtonDown((int)0) && this.page > (this.dailyEmotes ? -1 : 0)) {
                --this.page;
                this.animationState = -1;
                this.pageAnimation = System.currentTimeMillis();
            }
            if (Mouse.isButtonDown((int)1) && this.page < maxPages) {
                ++this.page;
                this.animationState = 1;
                this.pageAnimation = System.currentTimeMillis();
            }
        } else if (!Mouse.isButtonDown((int)0) && !Mouse.isButtonDown((int)1) && this.animationState != -1 && this.animationState != 1) {
            this.acceptedPage = this.page;
        }
        if ((this.animationState == -1 || this.animationState == 1) && this.pageAnimation + 100L < System.currentTimeMillis()) {
            this.animationState *= 2;
            this.pageAnimation = System.currentTimeMillis();
        }
        if ((this.animationState == -2 || this.animationState == 2) && this.pageAnimation + 100L < System.currentTimeMillis()) {
            this.animationState = 0;
            this.pageAnimation = System.currentTimeMillis();
        }
    }

    private void drawUnit(double midX, double midY, double radius, int amount, int index, double cursorX, double cursorY, double distance, KeyFrameStorage emote, bew player) {
        double middleOutsideY;
        double middleOutsideX;
        boolean cooldown;
        boolean validEmote;
        double tau = Math.PI * 2;
        double unitGap = 0.02;
        double idleGap = 1.0;
        double shift = tau / 3.0 + Math.PI;
        double outsideX = midX + radius * Math.cos((double)index * tau / (double)amount + unitGap + shift);
        double outsideY = midY + radius * Math.sin((double)index * tau / (double)amount + unitGap + shift);
        double outsideXNext = midX + radius * Math.cos((double)(index + 1) * tau / (double)amount - unitGap + shift);
        double outsideYNext = midY + radius * Math.sin((double)(index + 1) * tau / (double)amount - unitGap + shift);
        double radiusInside = radius / 5.0;
        double insideX = midX + radiusInside * Math.cos((double)index * tau / (double)amount + unitGap + shift);
        double insideY = midY + radiusInside * Math.sin((double)index * tau / (double)amount + unitGap + shift);
        double insideXNext = midX + radiusInside * Math.cos((double)(index + 1) * tau / (double)amount - unitGap + shift);
        double insideYNext = midY + radiusInside * Math.sin((double)(index + 1) * tau / (double)amount - unitGap + shift);
        double idleRadius = radius / 5.0 - idleGap;
        double idleX = midX + idleRadius * Math.cos((double)index * tau / (double)amount + shift);
        double idleY = midY + idleRadius * Math.sin((double)index * tau / (double)amount + shift);
        double idleXNext = midX + idleRadius * Math.cos((double)(index + 1) * tau / (double)amount + shift);
        double idleYNext = midY + idleRadius * Math.sin((double)(index + 1) * tau / (double)amount + shift);
        double staticMidX = LabyMod.getInstance().getDrawUtils().getWidth() / 2;
        double switchPageBrightness = this.animationState == 0 ? 1.0 : 1.0 - 1.0 / radius * Math.abs(staticMidX - midX);
        boolean bl = validEmote = LabyMod.getSettings().emotes && !this.emotesLocked && emote != null;
        boolean scrollSelected = this.scrollSelectedEmote != -1 && this.scrollSelectedEmote == index - (this.page == -1 ? 1 : 0);
        boolean hoverOutside = validEmote && (this.isInside(cursorX, cursorY, outsideX, outsideY, midX, midY, outsideXNext, outsideYNext) && Math.abs(distance) > 6.0 || scrollSelected && Math.abs(distance) < 6.0);
        double outsideBrightness = (hoverOutside ? 0.5 : 0.1) * switchPageBrightness;
        double outsideAlpha = (hoverOutside ? 0.6 : 0.5) * switchPageBrightness;
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        GL11.glLineWidth((float)2.0f);
        ave.A().P().a(ModTextures.VOID);
        bfl.d();
        bfl.l();
        GL11.glBegin((int)7);
        GL11.glColor4d((double)outsideBrightness, (double)outsideBrightness, (double)outsideBrightness, (double)outsideAlpha);
        GL11.glVertex3d((double)insideX, (double)insideY, (double)0.0);
        GL11.glVertex3d((double)insideXNext, (double)insideYNext, (double)0.0);
        GL11.glVertex3d((double)outsideXNext, (double)outsideYNext, (double)0.0);
        GL11.glVertex3d((double)outsideX, (double)outsideY, (double)0.0);
        GL11.glEnd();
        GL11.glBegin((int)2);
        GL11.glColor4d((double)0.0, (double)0.0, (double)0.0, (double)(0.5 * switchPageBrightness));
        GL11.glVertex3d((double)insideX, (double)insideY, (double)0.0);
        GL11.glVertex3d((double)insideXNext, (double)insideYNext, (double)0.0);
        GL11.glVertex3d((double)outsideXNext, (double)outsideYNext, (double)0.0);
        GL11.glVertex3d((double)outsideX, (double)outsideY, (double)0.0);
        GL11.glEnd();
        GL11.glBegin((int)4);
        GL11.glColor4d((double)0.3, (double)0.3, (double)0.3, (double)(0.5 * switchPageBrightness));
        GL11.glVertex3d((double)idleXNext, (double)idleYNext, (double)0.0);
        GL11.glVertex3d((double)idleX, (double)idleY, (double)0.0);
        GL11.glVertex3d((double)midX, (double)midY, (double)0.0);
        GL11.glEnd();
        GL11.glBegin((int)1);
        GL11.glColor4d((double)0.2, (double)0.2, (double)0.2, (double)(0.9 * switchPageBrightness));
        GL11.glVertex3d((double)idleXNext, (double)idleYNext, (double)0.0);
        GL11.glVertex3d((double)idleX, (double)idleY, (double)0.0);
        GL11.glEnd();
        boolean bl2 = this.emotesOnCooldown ? emoteCooldownEnd > System.currentTimeMillis() : (cooldown = false);
        if (emote != null && !this.emotesLocked && !cooldown) {
            EmoteRegistry registry = LabyMod.getInstance().getEmoteRegistry();
            EmoteRenderer emoteRenderer = registry.getEmoteRendererFor((bet)player);
            if (hoverOutside) {
                boolean moving;
                boolean bl3 = moving = player.p != player.s || player.q != player.t || player.r != player.u;
                if (moving) {
                    block0: for (EmoteKeyFrame keyframe : emote.getKeyframes()) {
                        if (keyframe == null) continue;
                        for (EmotePose emotePose : keyframe.getEmotePoses()) {
                            if (emotePose == null || !emotePose.isBlockMovement()) continue;
                            hoverOutside = false;
                            continue block0;
                        }
                    }
                }
            }
            if (hoverOutside) {
                if ((emoteRenderer == null || emoteRenderer.isStream()) && (emoteRenderer = registry.handleEmote(player.aK(), emote.getId())) != null) {
                    emoteRenderer.setVisible(false);
                }
                this.lastHoveredEmoteId = emote.getId();
            } else if (emoteRenderer != null && emoteRenderer.getEmoteId() == emote.getId()) {
                registry.handleEmote(player.aK(), (short)-1);
                emoteRenderer = null;
            }
            double emoteRadius = radius / 1.7;
            double middleOutsideX2 = midX + emoteRadius * Math.cos(((double)index + 0.5) * tau / (double)amount + shift);
            double middleOutsideY2 = midY + emoteRadius * Math.sin(((double)index + 0.5) * tau / (double)amount + shift);
            if (emoteRenderer != null && emoteRenderer.getEmoteId() == emote.getId()) {
                emoteRenderer.setVisible(true);
            }
            double size = radius / 70.0;
            if (switchPageBrightness < 0.5) {
                size = 0.0;
            }
            bfl.E();
            bfl.a((double)size, (double)size, (double)size);
            EmoteSelectorGui.drawEntityOnScreen(player, middleOutsideX2 / size, middleOutsideY2 / size + 8.0, 13.0, middleOutsideX2 - cursorX, middleOutsideY2 - cursorY, hoverOutside);
            bfl.F();
            if (emoteRenderer != null && emoteRenderer.getEmoteId() == emote.getId()) {
                emoteRenderer.setVisible(false);
            }
        }
        if (emote != null && (this.emotesLocked || cooldown)) {
            double emoteRadius = radius / 1.7;
            middleOutsideX = midX + emoteRadius * Math.cos(((double)index + 0.5) * tau / (double)amount + shift);
            middleOutsideY = midY + emoteRadius * Math.sin(((double)index + 0.5) * tau / (double)amount + shift);
            double size = radius / 4.0;
            bfl.c((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ave.A().P().a(ModTextures.MISC_BLOCKED);
            LabyMod.getInstance().getDrawUtils().drawTexture(middleOutsideX - size / 2.0, middleOutsideY - size / 2.0, 255.0, 255.0, size, size);
        }
        if (emote != null) {
            double emoteRadius = radius / 1.7;
            middleOutsideX = midX + emoteRadius * Math.cos(((double)index + 0.5) * tau / (double)amount + shift);
            middleOutsideY = midY + emoteRadius * Math.sin(((double)index + 0.5) * tau / (double)amount + shift);
            DrawUtils draw = LabyMod.getInstance().getDrawUtils();
            double fontSize = 0.5;
            String prefix = this.page == -1 ? ModColor.cl('6') : "";
            List<String> lines = draw.listFormattedStringToWidth(prefix + emote.getName(), (int)(idleRadius * 2.0 / fontSize), 2);
            int lineY = 0;
            for (String line : lines) {
                draw.drawCenteredString(line, middleOutsideX, middleOutsideY + (double)lineY + emoteRadius / 4.0, radius / 70.0 * fontSize * switchPageBrightness);
                lineY += 6;
            }
        }
    }

    private void updateScrollLock(boolean locked) {
        avh gameSettings = ave.A().t;
        if (gameSettings == null) {
            return;
        }
        avb keyBinding = gameSettings.aw[this.selectedItemIndex];
        if (keyBinding == null) {
            return;
        }
        int keyCode = keyBinding.i();
        avb.a((int)keyCode, (boolean)locked);
        if (locked) {
            avb.a((int)keyCode);
        } else {
            try {
                if (fieldPressTime != null) {
                    fieldPressTime.setInt(keyBinding, 0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void lockMouseMovementInCircle() {
        float newY;
        double distanceY;
        float newX;
        double distanceX;
        double distance;
        if (!this.open) {
            return;
        }
        bew player = LabyModCore.getMinecraft().getPlayer();
        if (player == null) {
            return;
        }
        double radius = (double)LabyMod.getInstance().getDrawUtils().getHeight() / 4.0 / 3.0;
        float centerX = this.lockedYaw;
        float centerY = this.lockedPitch;
        if ((double)centerY + radius > 90.0) {
            centerY = (float)(90.0 - radius);
        }
        if ((double)centerY - radius < -90.0) {
            centerY = (float)(-90.0 + radius);
        }
        if ((distance = Math.sqrt((distanceX = (double)(centerX - (newX = player.y))) * distanceX + (distanceY = (double)(centerY - (newY = player.z))) * distanceY)) > radius) {
            double fromOriginToObjectX = newX - centerX;
            double fromOriginToObjectY = newY - centerY;
            double multiplier = radius / distance;
            centerX = (float)((double)centerX + (fromOriginToObjectX *= multiplier));
            centerY = (float)((double)centerY + (fromOriginToObjectY *= multiplier));
            player.y = centerX;
            player.A = centerX;
            player.z = centerY;
            player.B = centerY;
        }
        this.updateScrollLock(true);
    }

    public static void drawEntityOnScreen(bew entity, double x, double y, double size, double mouseX, double mouseY, boolean hover) {
        bfl.E();
        bfl.g();
        bfl.b((double)x, (double)y, (double)0.0);
        bfl.a((double)(-size), (double)size, (double)size);
        bfl.b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float var6 = entity.aI;
        float var7 = entity.y;
        float var8 = entity.z;
        float var9 = entity.aL;
        float var10 = entity.aK;
        avc.b();
        bfl.z();
        bfl.f();
        if (hover) {
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        } else {
            GL11.glColor4d((double)0.5, (double)0.5, (double)0.5, (double)1.0);
        }
        entity.aI = (float)Math.atan(mouseX / 40.0) * 20.0f;
        entity.y = (float)Math.atan(mouseX / 40.0) * 40.0f;
        entity.z = -((float)Math.atan(mouseY / 40.0)) * 20.0f;
        entity.aK = entity.y;
        entity.aL = entity.y;
        double lastTickPosX = entity.P;
        double lastTickPosY = entity.Q;
        double lastTickPosZ = entity.R;
        double posX = entity.s;
        double posY = entity.t;
        double posZ = entity.u;
        double prevPosX = entity.p;
        double prevPosY = entity.q;
        double prevPosZ = entity.r;
        double chasingPosX = entity.bt;
        double chasingPosY = entity.bu;
        double chasingPosZ = entity.bv;
        double prevChasingPosX = entity.bq;
        double prevChasingPosY = entity.br;
        double prevChasingPosZ = entity.bs;
        entity.P = 0.0;
        entity.Q = 0.0;
        entity.R = 0.0;
        entity.s = 0.0;
        entity.t = 0.0;
        entity.u = 0.0;
        entity.p = 0.0;
        entity.q = 0.0;
        entity.r = 0.0;
        entity.bt = 0.0;
        entity.bu = 0.0;
        entity.bv = 0.0;
        entity.bq = 0.0;
        entity.br = 0.0;
        entity.bs = 0.0;
        bfl.b((float)0.0f, (float)0.0f, (float)10.0f);
        biu renderManager = ave.A().af();
        renderManager.a(90.0f);
        LabyModCore.getRenderImplementation().renderEntity(renderManager, (pk)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        entity.P = lastTickPosX;
        entity.Q = lastTickPosY;
        entity.R = lastTickPosZ;
        entity.s = posX;
        entity.t = posY;
        entity.u = posZ;
        entity.p = prevPosX;
        entity.q = prevPosY;
        entity.r = prevPosZ;
        entity.bt = chasingPosX;
        entity.bu = chasingPosY;
        entity.bv = chasingPosZ;
        entity.bq = prevChasingPosX;
        entity.br = prevChasingPosY;
        entity.bs = prevChasingPosZ;
        entity.aI = var6;
        entity.y = var7;
        entity.z = var8;
        entity.aL = var9;
        entity.aK = var10;
        avc.a();
        bfl.C();
        bfl.g((int)bqs.r);
        bfl.x();
        bfl.g((int)bqs.q);
        bfl.F();
    }

    private double sign(double px1, double py1, double px2, double py2, double px3, double py3) {
        return (px1 - px3) * (py2 - py3) - (px2 - px3) * (py1 - py3);
    }

    private boolean isInside(double pointX, double pointY, double px1, double py1, double px2, double py2, double px3, double py3) {
        boolean b1 = this.sign(pointX, pointY, px1, py1, px2, py2) < 0.0;
        boolean b2 = this.sign(pointX, pointY, px2, py2, px3, py3) < 0.0;
        boolean b3 = this.sign(pointX, pointY, px3, py3, px1, py1) < 0.0;
        return b1 == b2 && b2 == b3;
    }

    public boolean isOpen() {
        return this.open;
    }

    static {
        emoteCooldownEnd = 0L;
    }

    public static class SearchGui
    extends axu {
        private EmoteSelectorGui emoteSelectorGui;
        private ModTextField textField;

        public SearchGui(EmoteSelectorGui emoteSelectorGui) {
            this.emoteSelectorGui = emoteSelectorGui;
        }

        public void b() {
            super.b();
            this.textField = new ModTextField(0, LabyModCore.getMinecraft().getFontRenderer(), this.l / 2 - 50, this.m / 4 - 30, 100, 20);
            this.textField.setFocused(true);
            this.textField.setBlackBox(false);
        }

        public void a(int mouseX, int mouseY, float partialTicks) {
            super.a(mouseX, mouseY, partialTicks);
            this.textField.drawTextBox();
            this.emoteSelectorGui.pointSearchMouse(mouseX, mouseY);
        }

        public void e() {
            super.e();
            this.textField.updateCursorCounter();
        }

        protected void a(char typedChar, int keyCode) throws IOException {
            super.a(typedChar, keyCode);
            if (this.textField.textboxKeyTyped(typedChar, keyCode)) {
                this.emoteSelectorGui.filter(this.textField.getText());
            }
        }

        protected void a(int mouseX, int mouseY, int mouseButton) throws IOException {
            super.a(mouseX, mouseY, mouseButton);
            if (this.textField.mouseClicked(mouseX, mouseY, mouseButton)) {
                return;
            }
            this.emoteSelectorGui.pointSearchMouse(mouseX, mouseY);
            ave.A().a(null);
            this.emoteSelectorGui.close();
        }

        protected void a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
            super.a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
            this.emoteSelectorGui.pointSearchMouse(mouseX, mouseY);
        }
    }
}

