/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.emote.keys.provider;

import java.util.Iterator;
import net.labymod.user.emote.keys.EmoteKeyFrame;
import net.labymod.user.emote.keys.EmotePose;
import net.labymod.user.emote.keys.PoseAtTime;
import net.labymod.user.emote.keys.provider.EmoteProvider;
import net.labymod.user.emote.keys.provider.KeyFrameStorage;

public class StoredEmote
extends EmoteProvider {
    private Iterator<PoseAtTime>[] iterator = new Iterator[7];

    public StoredEmote(KeyFrameStorage keyFrameStorage) {
        EmoteKeyFrame[] emoteKeyFrames = keyFrameStorage.getKeyframes();
        for (int id = 0; id < 7; ++id) {
            int count = 0;
            for (EmoteKeyFrame emoteKeyFrame : emoteKeyFrames) {
                for (EmotePose subPose : emoteKeyFrame.getEmotePoses()) {
                    if (subPose.getBodyPart() != id) continue;
                    ++count;
                }
            }
            final PoseAtTime[] posesAtTime = new PoseAtTime[count];
            int index = 0;
            for (EmoteKeyFrame keyframe : emoteKeyFrames) {
                for (EmotePose pose : keyframe.getEmotePoses()) {
                    if (pose.getBodyPart() != id) continue;
                    posesAtTime[index] = new PoseAtTime(pose, keyframe.getOffset(), true);
                    ++index;
                }
            }
            final int keyFrameCount = count;
            this.iterator[id] = new Iterator<PoseAtTime>(){
                private int currentIndex = 0;

                @Override
                public boolean hasNext() {
                    return this.currentIndex < keyFrameCount && posesAtTime[this.currentIndex] != null;
                }

                @Override
                public PoseAtTime next() {
                    return posesAtTime[this.currentIndex++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    @Override
    public boolean hasNext(int bodyPoseId) {
        return this.iterator[bodyPoseId].hasNext();
    }

    @Override
    public PoseAtTime next(int bodyPoseId) {
        return this.iterator[bodyPoseId].next();
    }

    @Override
    public boolean isWaiting() {
        return false;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.iterator.length; ++i) {
            while (this.hasNext(i)) {
                this.next(i);
            }
        }
    }

    public Iterator<PoseAtTime>[] getIterator() {
        return this.iterator;
    }
}

