/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.emote;

import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.HashMap;
import java.util.Map;
import net.labymod.support.util.Debug;
import net.labymod.user.emote.EmoteRegistry;
import net.labymod.user.emote.keys.provider.KeyFrameStorage;
import net.labymod.utils.Consumer;
import net.labymod.utils.GZIPCompression;
import net.labymod.utils.request.DownloadServerRequest;
import net.labymod.utils.request.RequestException;
import net.labymod.utils.request.ServerResponse;

public class EmoteLoader {
    private static final Gson GSON = new Gson();
    private EmoteRegistry emoteRegistry;

    public EmoteLoader(EmoteRegistry emoteRegistry) {
        this.emoteRegistry = emoteRegistry;
    }

    private void decompile(byte[] decompressed, Consumer<Map<Short, KeyFrameStorage>> consumer) throws Exception {
        HashMap<Short, KeyFrameStorage> emoteSources = new HashMap<Short, KeyFrameStorage>();
        ByteArrayInputStream bais = new ByteArrayInputStream(decompressed);
        DataInputStream dis = new DataInputStream(bais);
        int count = dis.readInt();
        for (int i = 0; i < count; ++i) {
            short id = dis.readShort();
            byte[] nameInBytes = new byte[dis.readInt()];
            dis.read(nameInBytes);
            String name = new String(nameInBytes);
            byte[] jsonInBytes = new byte[dis.readInt()];
            dis.read(jsonInBytes);
            String json = new String(jsonInBytes);
            try {
                KeyFrameStorage storage = (KeyFrameStorage)GSON.fromJson(json, KeyFrameStorage.class);
                storage.setName(name);
                storage.setId(id);
                emoteSources.put(storage.getId(), storage);
                continue;
            }
            catch (Exception error) {
                Debug.log(Debug.EnumDebugMode.EMOTE, "Invalid emote data: " + json);
            }
        }
        Debug.log(Debug.EnumDebugMode.EMOTE, "Loaded " + this.emoteRegistry.emoteSources.size() + " emotes!");
        consumer.accept(emoteSources);
    }

    public Map<Short, KeyFrameStorage> read(final Consumer<Map<Short, KeyFrameStorage>> consumer) {
        DownloadServerRequest.getBytesAsync("https://dl.labymod.net/emotes/emotedata", new ServerResponse<byte[]>(){

            @Override
            public void success(byte[] bytes) {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                    DataInputStream dis = new DataInputStream(bais);
                    byte[] compressed = new byte[dis.readInt()];
                    dis.read(compressed);
                    byte[] decompressed = GZIPCompression.decompress(compressed);
                    EmoteLoader.this.decompile(decompressed, consumer);
                }
                catch (Exception error) {
                    error.printStackTrace();
                }
            }

            @Override
            public void failed(RequestException exception) {
                exception.printStackTrace();
                Debug.log(Debug.EnumDebugMode.EMOTE, "Emotedata response code is " + exception.getCode());
            }
        });
        return null;
    }
}

