/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.pet.ai;

import net.labymod.core.LabyModCore;
import net.labymod.user.cosmetic.ModelCosmetics;
import net.labymod.user.cosmetic.animation.EnumTrigger;
import net.labymod.user.cosmetic.pet.PetStorage;
import net.labymod.user.cosmetic.pet.ai.PetAI;
import net.labymod.user.cosmetic.pet.object.CosmeticPet;
import net.labymod.user.cosmetic.pet.util.Vector;
import net.labymod.user.cosmetic.util.CosmeticData;

public class WalkingPet<T extends CosmeticData>
implements PetAI<T> {
    private final CosmeticPet<T> pet;

    public WalkingPet(CosmeticPet<T> pet) {
        this.pet = pet;
    }

    @Override
    public void preRender(ModelCosmetics model, pk entityIn, PetStorage<T> data, float currentTick, float walkingSpeed, float partialTicks) {
        bet player = (bet)entityIn;
        double playerX = entityIn.p + (entityIn.s - entityIn.p) * (double)partialTicks;
        double playerY = entityIn.q + (entityIn.t - entityIn.q) * (double)partialTicks;
        double playerZ = entityIn.r + (entityIn.u - entityIn.r) * (double)partialTicks;
        double x = data.prevPosition.x + (data.position.x - data.prevPosition.x) * (double)partialTicks;
        double y = data.prevPosition.y + (data.position.y - data.prevPosition.y) * (double)partialTicks;
        double z = data.prevPosition.z + (data.position.z - data.prevPosition.z) * (double)partialTicks;
        float renderYaw = player.aJ + (player.aI - player.aJ) * partialTicks;
        bfl.b((float)renderYaw, (float)0.0f, (float)-1.0f, (float)0.0f);
        bfl.b((double)(-playerX), (double)playerY, (double)playerZ);
        bfl.b((double)x, (double)(-y), (double)(-z));
        bfl.b((double)0.0, (double)1.5, (double)0.0);
    }

    @Override
    public void firstPersonTransform(pk entityIn, PetStorage<T> data, boolean firstPersonContext, float partialTicks) {
        double playerX = entityIn.p + (entityIn.s - entityIn.p) * (double)partialTicks;
        double playerY = entityIn.q + (entityIn.t - entityIn.q) * (double)partialTicks;
        double playerZ = entityIn.r + (entityIn.u - entityIn.r) * (double)partialTicks;
        double x = data.prevPosition.x + (data.position.x - data.prevPosition.x) * (double)partialTicks;
        double y = data.prevPosition.y + (data.position.y - data.prevPosition.y) * (double)partialTicks;
        double z = data.prevPosition.z + (data.position.z - data.prevPosition.z) * (double)partialTicks;
        if (!firstPersonContext) {
            double diffX = playerX - x;
            double diffY = playerY - y;
            double diffZ = playerZ - z;
            bfl.b((double)(-diffX / 15.0), (double)(diffY / 15.0), (double)(diffZ / 15.0));
            if (entityIn.av()) {
                bfl.b((float)0.0f, (float)-0.33f, (float)0.0f);
            }
        }
    }

    @Override
    public void onTick(ModelCosmetics model, wn player, PetStorage<T> data, float movementFactor, float walkingSpeed, float tickValue, float partialTicks) {
        data.prevPosition.setX(data.position.x).setY(data.position.y).setZ(data.position.z);
        data.prevRotation.setX(data.rotation.x).setY(data.rotation.y).setZ(data.rotation.z);
        if (Math.abs(data.motion.x) < 0.003) {
            data.motion.x = 0.0;
        }
        if (Math.abs(data.motion.y) < 0.003) {
            data.motion.y = 0.0;
        }
        if (Math.abs(data.motion.z) < 0.003) {
            data.motion.z = 0.0;
        }
        double distance3D = data.ownerPosition.distanceSquared(data.position);
        double distance2D = Vector.square(data.ownerPosition.x - data.position.x) + Vector.square(data.ownerPosition.z - data.position.z);
        boolean moving = false;
        float rotation = (float)Math.toDegrees(Math.atan2(-player.s + data.position.x, -player.u + data.position.z));
        data.setRotation(0.0, -rotation + 180.0f, 0.0);
        if (distance2D > 5.0 && this.pet.moveType.canMove()) {
            if (!data.isMoving()) {
                data.setMovingState(true);
                data.standingUp = true;
                this.pet.handleTrigger(EnumTrigger.START_MOVING, data.animationController, tickValue, (pk)player, data);
            }
            if (!data.standingUp || !data.isPlayingAnimation(tickValue)) {
                moving = true;
                data.standingUp = false;
            }
        } else if (data.isMoving() && this.pet.moveType.canIdle()) {
            data.setMovingState(false);
            data.attached = false;
            this.pet.handleTrigger(EnumTrigger.STOP_MOVING, data.animationController, tickValue, (pk)player, data);
        }
        if (this.pet.moveType.canMove()) {
            data.travel(player.e(), moving ? -1.0f : 0.0f, 0.0f, 0.0f);
        }
        if (LabyModCore.getMinecraft().isJumpPredicted(data.position.x, data.position.y, data.position.z, data.prevPosition.x, data.prevPosition.y, data.prevPosition.z, (float)data.rotation.y, (float)data.rotation.x, data.boundingBox.minY, data.boundingBox.maxY, 1.0f, 0.0f, player.J, player.K, player.bI(), false, data.onGround, false)) {
            data.motion.y = 0.42f;
        }
        if (distance3D > 500.0 && player.C && this.pet.moveType.canMove()) {
            data.teleport(player.p, player.q + 1.0, player.r, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void renderFirstPerson(wn entity, float partialTicks) {
    }

    @Override
    public boolean canAttach() {
        return false;
    }
}

