/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.pet.ai;

import net.labymod.core.LabyModCore;
import net.labymod.support.gui.GuiCosmeticPreview;
import net.labymod.user.cosmetic.ModelCosmetics;
import net.labymod.user.cosmetic.animation.EnumTrigger;
import net.labymod.user.cosmetic.pet.PetStorage;
import net.labymod.user.cosmetic.pet.ai.PetAI;
import net.labymod.user.cosmetic.pet.object.CosmeticPet;
import net.labymod.user.cosmetic.pet.util.EnumMoveType;
import net.labymod.user.cosmetic.pet.util.Vector;
import net.labymod.user.cosmetic.util.CosmeticData;

public class FlyingAI<T extends CosmeticData>
implements PetAI<T> {
    private final CosmeticPet<T> pet;

    public FlyingAI(CosmeticPet<T> pet) {
        this.pet = pet;
    }

    @Override
    public void preRender(ModelCosmetics model, pk entityIn, PetStorage<T> data, float currentTick, float walkingSpeed, float partialTicks) {
        float shoulderMirror;
        Vector offset = data.offset;
        if (data.prevPosition.distanceSquared(data.position) > 10.0) {
            this.onTick(model, (wn)entityIn, data, 0.0f, 0.0f, 0.0f, partialTicks);
        }
        bet player = (bet)entityIn;
        float renderYaw = player.aJ + (player.aI - player.aJ) * partialTicks;
        double playerX = entityIn.p + (entityIn.s - entityIn.p) * (double)partialTicks;
        double playerY = entityIn.q + (entityIn.t - entityIn.q) * (double)partialTicks;
        double playerZ = entityIn.r + (entityIn.u - entityIn.r) * (double)partialTicks;
        double x = data.prevPosition.x + (data.position.x - data.prevPosition.x) * (double)partialTicks;
        double y = data.prevPosition.y + (data.position.y - data.prevPosition.y) * (double)partialTicks;
        double z = data.prevPosition.z + (data.position.z - data.prevPosition.z) * (double)partialTicks;
        bfl.b((double)(offset.x / 16.0), (double)(offset.y / 16.0), (double)(offset.z / 16.0));
        bct armSource = data.rightShoulder ? model.h : model.i;
        float f = shoulderMirror = data.rightShoulder ? -1.0f : 1.0f;
        if (!(ave.A().m instanceof GuiCosmeticPreview)) {
            bfl.b((float)(0.3125f * shoulderMirror), (float)0.15625f, (float)0.0f);
            if (data.isAttachedToOwner(currentTick)) {
                float transition = Math.min(1.0f, 1.0f - walkingSpeed);
                bfl.b((float)((float)Math.toDegrees(armSource.f) * transition), (float)1.0f, (float)0.0f, (float)0.0f);
                bfl.b((float)((float)Math.toDegrees(armSource.g) * transition), (float)0.0f, (float)1.0f, (float)0.0f);
                bfl.b((float)((float)Math.toDegrees(armSource.h) * transition), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            bfl.b((float)(0.0625f * shoulderMirror), (float)-0.14f, (float)-0.0625f);
        }
        bfl.b((float)0.0f, (float)0.015f, (float)0.0f);
        if (LabyModCore.getMinecraft().hasChestplate((wn)entityIn)) {
            bfl.b((float)0.0f, (float)-0.08f, (float)0.0f);
        }
        if (!data.isAttachedToOwner(currentTick) && this.pet.moveType.canMove()) {
            bfl.b((float)renderYaw, (float)0.0f, (float)-1.0f, (float)0.0f);
            double f2 = 1.0659f;
            bfl.a((double)f2, (double)f2, (double)f2);
            bfl.b((double)(x - playerX), (double)(-y + playerY), (double)(-z + playerZ));
        }
        if (!entityIn.av() && data.isAttachedToOwner(currentTick)) {
            double uniqueTick = (double)currentTick + (double)this.pet.getCosmeticId() * Math.PI;
            bfl.b((double)0.0, (double)(-Math.abs(Math.cos(uniqueTick / 2.0) / 3.0 * (double)walkingSpeed / 2.0)), (double)0.0);
            bfl.b((float)((float)Math.cos(uniqueTick / 2.0) * 10.0f * walkingSpeed), (float)0.0f, (float)0.0f, (float)1.0f);
            double chasingY = player.br + (player.bu - player.br) * (double)partialTicks;
            double velocityY = playerY > chasingY ? 0.0 : playerY - chasingY;
            double bounce = Math.abs(Math.cos(uniqueTick / 2.0 + velocityY) / 20.0);
            bfl.b((double)0.0, (double)(bounce * velocityY), (double)0.0);
        }
    }

    @Override
    public void firstPersonTransform(pk entityIn, PetStorage<T> data, boolean firstPersonContext, float partialTicks) {
    }

    @Override
    public void onTick(ModelCosmetics model, wn player, PetStorage<T> data, float movementFactor, float walkingSpeed, float tickValue, float partialTicks) {
        boolean isMoving;
        boolean bl = isMoving = walkingSpeed > 0.3f || player.ar;
        if (!data.isMoving() && this.pet.moveType == EnumMoveType.MOVE_ONLY) {
            data.setMovingState(true);
        }
        if (this.pet.moveType.canIdle()) {
            if (isMoving && data.isAttachedToOwner(tickValue) && this.pet.moveType.canMove()) {
                data.setMovingState(true);
                this.pet.handleTrigger(EnumTrigger.START_MOVING, data.animationController, tickValue, (pk)player, data);
            }
        } else if (isMoving && data.fakeIdle && this.pet.moveType.canMove()) {
            data.fakeIdle = false;
            this.pet.handleTrigger(EnumTrigger.START_MOVING, data.animationController, tickValue, (pk)player, data);
        }
        if (data.isAttachedToOwner(tickValue) || isMoving) {
            data.lastTimeMoved = System.currentTimeMillis();
        }
        long timePassedSinceChange = System.currentTimeMillis() - data.lastTimeFlyingChanged;
        float sigmoidInput = 0.006f * (float)Math.min(1000L, timePassedSinceChange);
        float increasing = (float)((1.0 - Math.exp(-sigmoidInput)) / (1.0 + Math.exp(-sigmoidInput)) * 1.0);
        float decreasing = 1.0f - increasing;
        double chasingX = player.bt;
        double chasingY = player.bu + (double)this.getFlightAltitude();
        double chasingZ = player.bv;
        double posX = player.s;
        double posY = player.t;
        double posZ = player.u;
        double positionFactor = data.isMoving() ? (double)decreasing : (double)increasing;
        double chasingFactor = data.isMoving() ? (double)increasing : (double)decreasing;
        double x = posX * positionFactor + chasingX * chasingFactor;
        double y = posY * positionFactor + chasingY * chasingFactor;
        double z = posZ * positionFactor + chasingZ * chasingFactor;
        float renderYaw = player.aI;
        float lookYaw = (float)(-Math.toDegrees(Math.atan2(-x + posX, -z + posZ)));
        float sigmoidInputTransition = (float)Math.min(2000L, System.currentTimeMillis() - data.lastTimeAboveShoulderChanged) / 2000.0f * 6.0f;
        float transition = (float)((1.0 - Math.exp(-sigmoidInputTransition)) / (1.0 + Math.exp(-sigmoidInputTransition)) * 1.0);
        float factor = data.isAboveShoulder ? 1.0f - transition : transition;
        float modDiff = (renderYaw - lookYaw) % 360.0f;
        float shortestDistance = 180.0f - Math.abs(Math.abs(modDiff) - 180.0f);
        float distance = (modDiff + 360.0f) % 360.0f < 180.0f ? shortestDistance : shortestDistance * -1.0f;
        float rotationY = renderYaw - distance * factor;
        data.teleport(x, y, z, 0.0, rotationY, 0.0);
        if (this.pet.moveType.canIdle()) {
            if (data.isMoving()) {
                boolean aboveShoulder;
                boolean bl2 = aboveShoulder = walkingSpeed < 0.1f || chasingFactor < (double)0.9f;
                if (aboveShoulder != data.isAboveShoulder) {
                    data.isAboveShoulder = aboveShoulder;
                    data.lastTimeAboveShoulderChanged = System.currentTimeMillis();
                }
                if (data.isAboveShoulder && data.lastTimeMoved + 7000L < System.currentTimeMillis() && this.pet.moveType.canIdle()) {
                    data.setMovingState(false);
                    this.pet.handleTrigger(EnumTrigger.STOP_MOVING, data.animationController, tickValue, (pk)player, data);
                }
            } else {
                data.isAboveShoulder = true;
            }
        } else {
            boolean aboveShoulder;
            boolean bl3 = aboveShoulder = walkingSpeed < 0.1f || chasingFactor < (double)0.9f;
            if (aboveShoulder != data.isAboveShoulder) {
                data.isAboveShoulder = aboveShoulder;
                data.lastTimeAboveShoulderChanged = System.currentTimeMillis();
            }
            if (!data.fakeIdle && data.lastTimeMoved + 1000L < System.currentTimeMillis()) {
                data.fakeIdle = true;
                this.pet.handleTrigger(EnumTrigger.STOP_MOVING, data.animationController, tickValue, (pk)player, data);
            }
        }
    }

    @Override
    public void renderFirstPerson(wn player, float partialTicks) {
    }

    public float getFlightAltitude() {
        return 0.5f;
    }

    @Override
    public boolean canAttach() {
        return this.pet.moveType.canIdle();
    }
}

