/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.geometry.render;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.labymod.core.LabyModCore;
import net.labymod.core.WorldRendererAdapter;
import net.labymod.user.cosmetic.geometry.render.Extruded;
import net.labymod.user.cosmetic.geometry.render.GeometryModelBox;
import org.lwjgl.opengl.GL11;

public class GeometryModelRenderer {
    public float textureWidth = 64.0f;
    public float textureHeight = 32.0f;
    public int textureOffsetX;
    public int textureOffsetY;
    public float rotationPointX;
    public float rotationPointY;
    public float rotationPointZ;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    public boolean compiled;
    private int displayList;
    public boolean mirror;
    public boolean showModel = true;
    public boolean isHidden;
    public List<GeometryModelBox> cubeList = Lists.newArrayList();
    public List<GeometryModelRenderer> childModels = Lists.newArrayList();
    public float offsetX;
    public float offsetY;
    public float offsetZ;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float scaleZ = 1.0f;
    public GeometryModelRenderer parent;
    public Color color = null;
    public Extruded extruded = null;
    public boolean glow;
    public Map<Integer, Integer> extrudedCompileList = new HashMap<Integer, Integer>();

    public void addChild(GeometryModelRenderer renderer) {
        if (this.childModels == null) {
            this.childModels = Lists.newArrayList();
        }
        renderer.parent = this;
        this.childModels.add(renderer);
    }

    public GeometryModelRenderer setTextureOffset(int x, int y) {
        this.textureOffsetX = x;
        this.textureOffsetY = y;
        return this;
    }

    public void addBox(float x, float y, float z, float width, float height, float depth, float delta, boolean mirror) {
        GeometryModelBox box = new GeometryModelBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, delta, mirror, this.textureWidth, this.textureHeight);
        this.cubeList.add(box);
    }

    public void setRotationPoint(float rotationPointXIn, float rotationPointYIn, float rotationPointZIn) {
        this.rotationPointX = rotationPointXIn;
        this.rotationPointY = rotationPointYIn;
        this.rotationPointZ = rotationPointZIn;
    }

    public void render(float scale) {
        if (this.extruded != null) {
            int code = this.extruded.hashCode();
            if (this.extrudedCompileList.containsKey(code)) {
                this.displayList = this.extrudedCompileList.get(code);
                this.compiled = true;
            } else {
                this.compiled = false;
            }
        }
        if (!this.isHidden && this.showModel) {
            if (!this.compiled) {
                this.compileDisplayList(scale);
            }
            bfl.b((float)this.offsetX, (float)this.offsetY, (float)this.offsetZ);
            bfl.E();
            if (this.rotationPointX != 0.0f || this.rotationPointY != 0.0f || this.rotationPointZ != 0.0f) {
                bfl.b((float)(this.rotationPointX * scale), (float)(this.rotationPointY * scale), (float)(this.rotationPointZ * scale));
            }
            if (this.rotateAngleZ != 0.0f) {
                bfl.b((float)(this.rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.rotateAngleY != 0.0f) {
                bfl.b((float)(this.rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.rotateAngleX != 0.0f) {
                bfl.b((float)(this.rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (this.scaleX != 1.0f || this.scaleY != 1.0f || this.scaleZ != 1.0f) {
                bfl.a((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
            }
            if (this.color != null) {
                GL11.glColor4f((float)((float)this.color.getRed() / 255.0f), (float)((float)this.color.getGreen() / 255.0f), (float)((float)this.color.getBlue() / 255.0f), (float)((float)this.color.getAlpha() / 255.0f));
            }
            if (this.glow) {
                bfl.f();
                ave.A().o.h();
            }
            bfl.o((int)this.displayList);
            if (this.childModels != null) {
                for (int i = 0; i < this.childModels.size(); ++i) {
                    this.childModels.get(i).render(scale);
                }
            }
            if (this.color != null) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (this.glow) {
                bfl.e();
                ave.A().o.i();
            }
            bfl.F();
            bfl.b((float)(-this.offsetX), (float)(-this.offsetY), (float)(-this.offsetZ));
        }
    }

    private void compileDisplayList(float scale) {
        this.displayList = avd.a((int)1);
        GL11.glNewList((int)this.displayList, (int)4864);
        if (this.extruded != null) {
            int code = this.extruded.hashCode();
            this.extrudedCompileList.put(code, this.displayList);
        }
        WorldRendererAdapter worldRenderer = LabyModCore.getWorldRenderer();
        for (int cubeIndex = 0; cubeIndex < this.cubeList.size(); ++cubeIndex) {
            GeometryModelBox box = this.cubeList.get(cubeIndex);
            for (int quadIndex = 0; quadIndex < box.quadList.length; ++quadIndex) {
                if (this.extruded != null && !this.extruded.isVisible(cubeIndex, quadIndex)) continue;
                box.quadList[quadIndex].draw(worldRenderer, scale);
            }
        }
        GL11.glEndList();
        this.compiled = true;
    }

    public GeometryModelRenderer setTextureSize(int textureWidthIn, int textureHeightIn) {
        this.textureWidth = textureWidthIn;
        this.textureHeight = textureHeightIn;
        return this;
    }

    public void setScale(float scaleX, float scaleY, float scaleZ) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
    }
}

