/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.geometry;

import net.labymod.core.LabyModCore;
import net.labymod.main.LabyMod;
import net.labymod.support.util.Debug;
import net.labymod.user.cosmetic.CosmeticRenderer;
import net.labymod.user.cosmetic.ModelCosmetics;
import net.labymod.user.cosmetic.animation.AnimationLoader;
import net.labymod.user.cosmetic.animation.EnumTrigger;
import net.labymod.user.cosmetic.animation.IModelTransformer;
import net.labymod.user.cosmetic.animation.model.KeyframeVector;
import net.labymod.user.cosmetic.geometry.AnimationStorage;
import net.labymod.user.cosmetic.geometry.BlockBenchLoader;
import net.labymod.user.cosmetic.geometry.GeometryLoader;
import net.labymod.user.cosmetic.geometry.IGeometryProviderCallback;
import net.labymod.user.cosmetic.geometry.TriggerHandler;
import net.labymod.user.cosmetic.geometry.blockbench.Item;
import net.labymod.user.cosmetic.geometry.render.GeometryModelRenderer;
import net.labymod.user.cosmetic.remote.model.EnumAttachedTo;
import net.labymod.user.cosmetic.remote.model.EnumMirrorType;
import net.labymod.user.cosmetic.remote.model.RemoteObject;
import net.labymod.user.cosmetic.remote.objects.data.RemoteData;
import net.labymod.user.cosmetic.util.CosmeticData;
import org.lwjgl.opengl.GL11;

public abstract class GeometryCosmetic<T extends CosmeticData>
extends CosmeticRenderer<T>
implements IModelTransformer,
TriggerHandler {
    private final RemoteObject data;
    private IGeometryProviderCallback<T> callback;
    private BlockBenchLoader geometry;
    private AnimationLoader animation;

    public GeometryCosmetic(RemoteObject data, IGeometryProviderCallback<T> callback) {
        this.data = data;
        this.callback = callback;
    }

    @Override
    public void addModels(ModelCosmetics baseModel, float modelSize) {
        try {
            this.geometry = new GeometryLoader(this.callback.getGeometryJson()).toBlockBenchLoader((bbo)baseModel);
            this.animation = new AnimationLoader(this.callback.getAnimationJson()).load();
        }
        catch (Exception e) {
            Debug.log(Debug.EnumDebugMode.REMOTE_COSMETIC, "Can't load " + this.data.name + ": " + e.getMessage());
        }
    }

    @Override
    public void setInvisible(boolean invisible) {
        if (this.geometry != null && this.geometry.getModel() != null) {
            this.geometry.getModel().showModel = invisible;
        }
    }

    @Override
    public void transform(String boneName, KeyframeVector rotation, KeyframeVector position, KeyframeVector scale) {
        GeometryModelRenderer model;
        GeometryModelRenderer geometryModelRenderer = model = this.geometry == null ? null : this.geometry.getModel(boneName);
        if (model != null) {
            Item item = this.geometry.getItem(boneName);
            double fixedRotationX = item.rotation == null ? 0.0 : item.rotation.get(0);
            double fixedRotationY = item.rotation == null ? 0.0 : item.rotation.get(1);
            double fixedRotationZ = item.rotation == null ? 0.0 : item.rotation.get(2);
            model.rotateAngleX = (float)Math.toRadians(rotation.x - fixedRotationX);
            model.rotateAngleY = (float)Math.toRadians(rotation.y - fixedRotationY);
            model.rotateAngleZ = (float)Math.toRadians(rotation.z + fixedRotationZ);
            model.offsetX = (float)(position.x / 16.0);
            model.offsetY = (float)(-position.y / 16.0);
            model.offsetZ = (float)(position.z / 16.0);
            model.scaleX = (float)scale.x;
            model.scaleY = (float)scale.y;
            model.scaleZ = (float)scale.z;
        }
    }

    @Override
    public void resetTransformation(String boneName) {
        GeometryModelRenderer model;
        GeometryModelRenderer geometryModelRenderer = model = this.geometry == null ? null : this.geometry.getModel(boneName);
        if (model != null) {
            Item item = this.geometry.getItem(boneName);
            model.rotateAngleX = item.rotation == null ? 0.0f : (float)Math.toRadians(-item.rotation.get(0).doubleValue());
            model.rotateAngleY = item.rotation == null ? 0.0f : (float)Math.toRadians(-item.rotation.get(1).doubleValue());
            model.rotateAngleZ = item.rotation == null ? 0.0f : (float)Math.toRadians(item.rotation.get(2));
            model.offsetX = 0.0f;
            model.offsetY = 0.0f;
            model.offsetZ = 0.0f;
            model.scaleX = 1.0f;
            model.scaleY = 1.0f;
            model.scaleZ = 1.0f;
        }
    }

    @Override
    public BlockBenchLoader getGeometry() {
        return this.geometry;
    }

    @Override
    public void renderModel(float renderScale) {
        if (this.geometry != null && this.geometry.getModel() != null) {
            this.geometry.getModel().render(renderScale);
        }
    }

    @Override
    public void render(ModelCosmetics modelCosmetics, pk entityIn, T cosmeticData, float scale, float movementFactor, float walkingSpeed, float currentTick, float firstRotationX, float secondRotationX, float partialTicks, boolean firstPersonContext) {
        jy texture;
        int itemId;
        boolean swap = LabyMod.getSettings().leftHand;
        zx itemStack = LabyModCore.getMinecraft().getMainHandItem();
        int n = itemId = itemStack != null && itemStack.b() != null ? zw.b((zw)itemStack.b()) : 0;
        if (LabyMod.getSettings().swapBow && itemId == 261) {
            boolean bl = swap = !swap;
        }
        if (swap && LabyModCore.getMinecraft().getItemInUseMaxCount() != 0 && itemId == 261 || swap && LabyMod.getInstance().isHasLeftHand()) {
            swap = false;
        }
        bfl.E();
        if (swap && this.data.attachedTo.canBeMirrored() && !firstPersonContext) {
            bfl.a((float)-1.0f, (float)1.0f, (float)1.0f);
            bfl.p();
        }
        if ((texture = this.callback.getTexture(entityIn, cosmeticData)) != null) {
            boolean showBothHands;
            int tex = GL11.glGetInteger((int)32873);
            ave.A().P().a(texture);
            boolean bl = showBothHands = !firstPersonContext || entityIn instanceof wn && LabyModCore.getMinecraft().isMapInMainHand((wn)entityIn);
            if (this.data.mirror && this.data.attachedTo.canBeMirrored()) {
                for (int i = 0; i < 2; ++i) {
                    boolean mirrored;
                    boolean bl2 = mirrored = i == 1;
                    if (!showBothHands && i == 0) continue;
                    this.renderGeometryWithSide(entityIn, modelCosmetics, cosmeticData, movementFactor, walkingSpeed, currentTick, partialTicks, scale, texture, mirrored);
                }
            } else {
                boolean mirrored;
                boolean bl3 = mirrored = cosmeticData instanceof RemoteData && ((RemoteData)cosmeticData).rightSide;
                if (showBothHands || cosmeticData instanceof RemoteData && ((RemoteData)cosmeticData).rightSide) {
                    this.renderGeometryWithSide(entityIn, modelCosmetics, cosmeticData, movementFactor, walkingSpeed, currentTick, partialTicks, scale, texture, mirrored);
                }
            }
            bfl.i((int)tex);
        }
        if (swap && this.data.attachedTo.canBeMirrored() && !firstPersonContext) {
            bfl.a((float)-1.0f, (float)1.0f, (float)1.0f);
            bfl.p();
        }
        bfl.F();
    }

    private void renderGeometryWithSide(pk entityIn, ModelCosmetics modelCosmetics, T cosmeticData, float movementFactor, float walkingSpeed, float currentTick, float partialTicks, float scaleIn, jy texture, boolean mirrored) {
        AnimationStorage storage;
        bfl.E();
        bfl.p();
        bfl.l();
        bfl.e();
        bfl.G();
        float scale = (float)(0.0625 / this.data.scale);
        if (this.data.attachedTo == EnumAttachedTo.ARM || this.data.attachedTo == EnumAttachedTo.LEG) {
            boolean isArm;
            boolean bl = isArm = this.data.attachedTo == EnumAttachedTo.ARM;
            bct model = isArm ? (mirrored ? modelCosmetics.h : modelCosmetics.i) : (mirrored ? modelCosmetics.j : modelCosmetics.k);
            boolean slim = modelCosmetics.isSlim();
            bfl.b((float)(model.c * scale), (float)(model.d * scale), (float)(model.e * scale));
            bfl.b((float)((float)Math.toDegrees(model.h)), (float)0.0f, (float)0.0f, (float)1.0f);
            bfl.b((float)((float)Math.toDegrees(model.g)), (float)0.0f, (float)1.0f, (float)0.0f);
            bfl.b((float)((float)Math.toDegrees(model.f)), (float)1.0f, (float)0.0f, (float)0.0f);
            if (mirrored) {
                if (this.data.mirrorType == EnumMirrorType.DUPLICATE) {
                    if (isArm) {
                        bfl.b((float)(slim ? -scale : -scale * 2.0f), (float)0.0f, (float)0.0f);
                    }
                } else if (this.data.mirrorType == EnumMirrorType.MIRROR) {
                    bfl.a((float)-1.0f, (float)1.0f, (float)1.0f);
                } else {
                    bfl.b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
            if (isArm) {
                bfl.b((float)(slim ? scale / 2.0f : scale), (float)(-2.0f * scale), (float)0.0f);
            }
        }
        if (this.data.attachedTo == EnumAttachedTo.BODY) {
            bfl.b((float)((float)Math.toDegrees(modelCosmetics.g.g)), (float)0.0f, (float)1.0f, (float)0.0f);
            bfl.b((float)((float)Math.toDegrees(modelCosmetics.g.f)), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (this.data.attachedTo == EnumAttachedTo.HEAD) {
            if (modelCosmetics.n) {
                bfl.b((float)0.0f, (float)(1.0f * scale), (float)0.0f);
            }
            bfl.b((float)((float)Math.toDegrees(modelCosmetics.e.g)), (float)0.0f, (float)1.0f, (float)0.0f);
            bfl.b((float)((float)Math.toDegrees(modelCosmetics.e.f)), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if ((storage = this.getAnimationStorage(cosmeticData)) != null) {
            boolean moving;
            boolean sneaking = entityIn.av();
            boolean bl = moving = (double)walkingSpeed > 0.1;
            if (sneaking && !storage.lastSneaking) {
                this.handleTrigger(EnumTrigger.START_SNEAKING, storage.controller, currentTick, entityIn, cosmeticData);
            } else if (!sneaking && storage.lastSneaking) {
                this.handleTrigger(EnumTrigger.STOP_SNEAKING, storage.controller, currentTick, entityIn, cosmeticData);
            }
            storage.lastSneaking = sneaking;
            if (moving && !storage.lastMoving) {
                this.handleTrigger(EnumTrigger.START_MOVING, storage.controller, currentTick, entityIn, cosmeticData);
            } else if (!moving && storage.lastMoving) {
                this.handleTrigger(EnumTrigger.STOP_MOVING, storage.controller, currentTick, entityIn, cosmeticData);
            }
            storage.lastMoving = moving;
            if (System.currentTimeMillis() > storage.nextTriggerTime || !storage.controller.isPlaying(currentTick)) {
                storage.nextTriggerTime = System.currentTimeMillis() + 500L;
                EnumTrigger trigger = moving ? (sneaking ? EnumTrigger.SNEAK_MOVING : EnumTrigger.MOVING) : (sneaking ? EnumTrigger.SNEAK_IDLE : EnumTrigger.IDLE);
                this.handleTrigger(trigger, storage.controller, currentTick, entityIn, cosmeticData);
            }
            if (this.geometry != null && this.geometry.getModel() != null) {
                if (cosmeticData instanceof RemoteData) {
                    RemoteData remoteData = (RemoteData)cosmeticData;
                    if (remoteData.offset != null) {
                        bfl.b((double)(remoteData.offset.x / 16.0 / this.data.scale), (double)(-remoteData.offset.y / 16.0 / this.data.scale), (double)(remoteData.offset.z / 16.0 / this.data.scale));
                    }
                }
                storage.controller.transformAndRender(this, entityIn, (CosmeticData)cosmeticData, movementFactor, walkingSpeed, currentTick, scaleIn, partialTicks, mirrored);
                if (cosmeticData instanceof RemoteData) {
                    ((RemoteData)cosmeticData).depthMapChangedInThisFrame = false;
                }
            }
        }
        bfl.F();
    }

    protected abstract AnimationStorage getAnimationStorage(T var1);

    @Override
    public float getNameTagHeight() {
        return this.data.nametagOffset;
    }

    @Override
    public int getCosmeticId() {
        return this.data.id;
    }

    @Override
    public String getCosmeticName() {
        return this.data.name;
    }

    @Override
    public boolean isOfflineAvailable() {
        return false;
    }

    @Override
    public boolean isVisibleInFirstPerson(CosmeticData data, boolean rightHand) {
        return this.data != null && this.data.attachedTo == EnumAttachedTo.ARM;
    }

    @Override
    public AnimationLoader getLoader() {
        return this.animation;
    }
}

