/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.custom;

import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.support.util.Debug;
import net.labymod.user.User;
import net.labymod.user.cosmetic.custom.AnimatedResourceLocation;
import net.labymod.user.cosmetic.custom.BufferedImageTexture;
import net.labymod.user.cosmetic.custom.DepthMap;
import net.labymod.user.cosmetic.custom.UserTextureContainer;
import net.labymod.user.cosmetic.remote.RemoteCosmeticLoader;
import net.labymod.user.cosmetic.remote.model.Ratio;
import net.labymod.user.cosmetic.remote.model.TextureMeta;
import net.labymod.utils.request.DownloadServerRequest;
import net.labymod.utils.texture.ThreadDownloadTextureImage;
import net.labymod.utils.texture.async.AsyncTextureLoader;
import net.labymod.utils.texture.async.BulkTask;
import org.apache.commons.io.FilenameUtils;

public abstract class CosmeticImageHandler {
    private static final Executor EXECUTOR = Executors.newFixedThreadPool(5);
    private final Ratio ratio;
    protected Map<UUID, AnimatedResourceLocation> resourceLocations = new HashMap<UUID, AnimatedResourceLocation>();
    private String userAgent;
    private String resourceName;
    private boolean canUnload;

    public CosmeticImageHandler(String userAgent, String resourceName, boolean canUnload) {
        this(userAgent, resourceName, canUnload, null);
    }

    public CosmeticImageHandler(String userAgent, String resourceName, boolean canUnload, Ratio ratio) {
        this.userAgent = userAgent;
        this.resourceName = resourceName;
        this.canUnload = canUnload;
        this.ratio = ratio;
    }

    public void loadUserTexture(UUID uuid, String url) {
        if (url == null || this.resourceLocations.containsKey(uuid) && !this.canUnload) {
            return;
        }
        if (this.ratio == null) {
            this.loadStaticImageTexture(uuid, url);
        } else {
            this.loadAnimatedImageTexture(uuid, url);
        }
    }

    public AnimatedResourceLocation getAnimatedResourceLocation(bet player) {
        User user = LabyMod.getInstance().getUserManager().getUser(player.aK());
        UserTextureContainer container = this.getContainer(user);
        if (container == null) {
            return null;
        }
        container.validateTexture(this);
        return this.resourceLocations.get(container.getFileName());
    }

    public jy getResourceLocation(bet player, int frame) {
        AnimatedResourceLocation resource = this.getAnimatedResourceLocation(player);
        return resource == null ? ModTextures.TRANSPARENT : resource.get(frame);
    }

    public jy getResourceLocation(bet player) {
        return this.getResourceLocation(player, 0);
    }

    public abstract UserTextureContainer getContainer(User var1);

    public void validate(User user) {
        UserTextureContainer container = this.getContainer(user);
        if (container != null) {
            container.validateTexture(this);
        }
    }

    public abstract void unload();

    public abstract ThreadDownloadTextureImage.TextureImageParser getTextureImageParser();

    private void loadStaticImageTexture(UUID uuid, String url) {
        AnimatedResourceLocation animatedResource = new AnimatedResourceLocation(this.resourceName + "/" + FilenameUtils.getBaseName((String)url));
        jy resourceLocation = animatedResource.getDefault();
        ThreadDownloadTextureImage textureCosmetic = new ThreadDownloadTextureImage(url, animatedResource.getDefault(), success -> this.resourceLocations.put(uuid, animatedResource), this.userAgent);
        textureCosmetic.setDebugMode(Debug.EnumDebugMode.COSMETIC_IMAGE_MANAGER);
        textureCosmetic.setTextureImageParser(this.getTextureImageParser());
        textureCosmetic.setCallback(image -> animatedResource.setDepthMap(new DepthMap((BufferedImage)image)));
        Debug.log(Debug.EnumDebugMode.COSMETIC_IMAGE_MANAGER, "Load static image " + animatedResource.getPath());
        LabyMod.getInstance().getAsyncTextureLoader().uploadTextureAsync(resourceLocation, (bly)textureCosmetic);
    }

    protected void loadAnimatedImageTexture(UUID uuid, String url) {
        EXECUTOR.execute(() -> {
            try {
                String metaJson = DownloadServerRequest.getString(url + ".json");
                TextureMeta textureMeta = (TextureMeta)RemoteCosmeticLoader.GSON.fromJson(metaJson, TextureMeta.class);
                BufferedImage spriteMapImage = ImageIO.read(new URL(url).openStream());
                int frameWidth = spriteMapImage.getWidth();
                int frameHeight = (int)((float)frameWidth / ((float)this.ratio.width / (float)this.ratio.height));
                int frames = spriteMapImage.getHeight() / frameHeight;
                AnimatedResourceLocation animatedResource = new AnimatedResourceLocation(this.resourceName + "/" + FilenameUtils.getBaseName((String)url), frames, textureMeta.delay);
                Debug.log(Debug.EnumDebugMode.COSMETIC_IMAGE_MANAGER, "Load animated image " + animatedResource.getPath());
                ArrayList<BufferedImageTexture> queue = new ArrayList<BufferedImageTexture>();
                for (int frame = 0; frame < frames; ++frame) {
                    BufferedImage imageFrame = spriteMapImage.getSubimage(0, frame * frameHeight, frameWidth, frameHeight);
                    queue.add(new BufferedImageTexture(imageFrame));
                }
                AsyncTextureLoader asyncTextureLoader = LabyMod.getInstance().getAsyncTextureLoader();
                if (asyncTextureLoader.isAsyncAvailable()) {
                    asyncTextureLoader.runTaskAsync(() -> {
                        for (int frame = 0; frame < queue.size(); ++frame) {
                            BufferedImageTexture texture = (BufferedImageTexture)((Object)((Object)((Object)queue.get(frame))));
                            jy resource = animatedResource.get(frame);
                            if (resource == null) continue;
                            asyncTextureLoader.uploadTexture(resource, texture);
                        }
                        this.resourceLocations.put(uuid, animatedResource);
                    });
                } else {
                    BulkTask bulkTask = new BulkTask(accepted -> this.resourceLocations.put(uuid, animatedResource));
                    for (int frame = 0; frame < queue.size(); ++frame) {
                        BufferedImageTexture texture = (BufferedImageTexture)((Object)((Object)queue.get(frame)));
                        jy resource = animatedResource.get(frame);
                        if (resource == null) continue;
                        bulkTask.queue(() -> ave.A().P().a(resource, (bmk)texture));
                    }
                    asyncTextureLoader.runBulkTask(bulkTask);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public Map<UUID, AnimatedResourceLocation> getResourceLocations() {
        return this.resourceLocations;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public boolean isCanUnload() {
        return this.canUnload;
    }
}

