/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.cosmetics.shop.head;

import java.awt.Color;
import net.labymod.core.LabyModCore;
import net.labymod.main.ModTextures;
import net.labymod.user.User;
import net.labymod.user.cosmetic.CosmeticRenderer;
import net.labymod.user.cosmetic.ModelCosmetics;
import net.labymod.user.cosmetic.util.CosmeticData;
import net.labymod.user.cosmetic.util.EnumLegacyCosmeticType;
import net.labymod.user.cosmetic.util.ModelRendererHook;

public class CosmeticRabbit
extends CosmeticRenderer<CosmeticRabbitData> {
    public static final int ID = 11;
    private bct rabbitEar;
    private bct rabbitEarPlayerSkin;

    @Override
    public void addModels(ModelCosmetics modelCosmetics, float modelSize) {
        for (int i = 0; i <= 1; ++i) {
            boolean playerSkin = i != 0;
            ModelRendererHook target = new ModelRendererHook((bbo)modelCosmetics);
            if (playerSkin) {
                target.a(24, 0);
            } else {
                target.b(6, 7);
            }
            target.a(0.0f, 0.0f, 0.0f, 2, 6, 1, modelSize);
            target.d = -6.0f;
            if (i == 0) {
                this.rabbitEar = target;
                continue;
            }
            this.rabbitEarPlayerSkin = target;
        }
    }

    @Override
    public void setInvisible(boolean invisible) {
        this.rabbitEar.j = invisible;
        this.rabbitEarPlayerSkin.j = invisible;
    }

    @Override
    public void render(ModelCosmetics modelCosmetics, pk entityIn, CosmeticRabbitData cosmeticData, float scale, float movementFactor, float walkingSpeed, float tickValue, float firstRotationX, float secondRotationX, float partialTicks) {
        bfl.E();
        if (entityIn.av()) {
            bfl.b((double)0.0, (double)0.06, (double)0.0);
        }
        bfl.b((float)firstRotationX, (float)0.0f, (float)1.0f, (float)0.0f);
        bfl.b((float)secondRotationX, (float)1.0f, (float)0.0f, (float)0.0f);
        double rescale = 1.15;
        bfl.b((double)0.0, (double)-0.44, (double)-0.1);
        bfl.a((double)rescale, (double)rescale, (double)rescale);
        bet entitylivingbaseIn = (bet)entityIn;
        double motionX = entitylivingbaseIn.bq + (entitylivingbaseIn.bt - entitylivingbaseIn.bq) * (double)partialTicks - (entitylivingbaseIn.p + (entitylivingbaseIn.s - entitylivingbaseIn.p) * (double)partialTicks);
        double motionY = entitylivingbaseIn.br + (entitylivingbaseIn.bu - entitylivingbaseIn.br) * (double)partialTicks - (entitylivingbaseIn.q + (entitylivingbaseIn.t - entitylivingbaseIn.q) * (double)partialTicks);
        double motionZ = entitylivingbaseIn.bs + (entitylivingbaseIn.bv - entitylivingbaseIn.bs) * (double)partialTicks - (entitylivingbaseIn.r + (entitylivingbaseIn.u - entitylivingbaseIn.r) * (double)partialTicks);
        float motionYaw = entitylivingbaseIn.aJ + (entitylivingbaseIn.aI - entitylivingbaseIn.aJ) * partialTicks;
        double yawSin = LabyModCore.getMath().sin(motionYaw * (float)Math.PI / 180.0f);
        double yawCos = -LabyModCore.getMath().cos(motionYaw * (float)Math.PI / 180.0f);
        float rotation = (float)motionY * 10.0f;
        rotation = LabyModCore.getMath().clamp_float(rotation, -6.0f, 32.0f);
        float motionAdd = (float)(motionX * yawSin + motionZ * yawCos) * 100.0f;
        float motionSub = (float)(motionX * yawCos - motionZ * yawSin) * 100.0f;
        if (motionAdd < 0.0f) {
            motionAdd = 0.0f;
        }
        if (motionAdd >= 130.0f) {
            motionAdd = 130.0f + (motionAdd - 180.0f) * 0.2f;
        }
        float f4 = entitylivingbaseIn.bn + (entitylivingbaseIn.bo - entitylivingbaseIn.bn) * partialTicks;
        rotation += LabyModCore.getMath().sin((entitylivingbaseIn.L + (entitylivingbaseIn.M - entitylivingbaseIn.L) * partialTicks) * 6.0f) * 32.0f * f4;
        bct targetModel = this.bindTextureAndColor(cosmeticData.getColor(), cosmeticData.isUseSkinTexture() ? null : ModTextures.COSMETIC_RABBIT, cosmeticData.isUseSkinTexture() ? this.rabbitEarPlayerSkin : this.rabbitEar);
        double distanceToMid = 0.09;
        boolean hat = cosmeticData.isHat();
        if (hat) {
            motionSub /= 5.0f;
        }
        bfl.o();
        for (int i = -1; i < 2; i += 2) {
            bfl.E();
            if (i == 1) {
                bfl.a((float)-1.0f, (float)1.0f, (float)1.0f);
                LabyModCore.getRenderImplementation().cullFaceFront();
            }
            bfl.b((double)(-distanceToMid * 2.0), (double)0.0, (double)0.0);
            bfl.b((float)(6.0f - motionAdd / 3.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            bfl.b((float)(-motionSub / 4.0f * (float)(-i) + rotation / 8.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            if (entityIn.av()) {
                bfl.b((float)(Math.abs(entityIn.z) / -5.0f), (float)0.0f, (float)1.0f, (float)1.0f);
            }
            if (hat) {
                bfl.b((float)-30.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            targetModel.a(scale);
            bfl.F();
        }
        LabyModCore.getRenderImplementation().cullFaceBack();
        bfl.F();
    }

    @Override
    public int getCosmeticId() {
        return 11;
    }

    @Override
    public String getCosmeticName() {
        return "Rabbit Ears";
    }

    @Override
    public boolean isOfflineAvailable() {
        return false;
    }

    @Override
    public float getNameTagHeight() {
        return 0.2f;
    }

    public static class CosmeticRabbitData
    extends CosmeticData {
        private Color color = Color.WHITE;
        private boolean hat;
        private boolean useSkinTexture = false;

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void loadData(String[] data) throws Exception {
            this.color = Color.decode("#" + data[0]);
            this.useSkinTexture = Integer.parseInt(data[1]) == 1;
        }

        @Override
        public void completed(User user) {
        }

        @Override
        public EnumLegacyCosmeticType getType() {
            return EnumLegacyCosmeticType.HAT;
        }

        public Color getColor() {
            return this.color;
        }

        public boolean isHat() {
            return this.hat;
        }

        public boolean isUseSkinTexture() {
            return this.useSkinTexture;
        }
    }
}

