/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.cosmetics.partner;

import java.awt.Color;
import net.labymod.core.LabyModCore;
import net.labymod.core.WorldRendererAdapter;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.user.User;
import net.labymod.user.cosmetic.CosmeticRenderer;
import net.labymod.user.cosmetic.ModelCosmetics;
import net.labymod.user.cosmetic.cosmetics.shop.head.CosmeticEyelids;
import net.labymod.user.cosmetic.util.CosmeticData;
import net.labymod.user.cosmetic.util.EnumLegacyCosmeticType;
import org.lwjgl.opengl.GL11;

public class CosmeticSnoxh
extends CosmeticRenderer<CosmeticSnoxhData> {
    public static final int ID = 32;

    @Override
    public void addModels(ModelCosmetics modelCosmetics, float modelSize) {
    }

    @Override
    public void setInvisible(boolean invisible) {
    }

    @Override
    public void render(ModelCosmetics modelCosmetics, pk entityIn, CosmeticSnoxhData cosmeticData, float scale, float movementFactor, float walkingSpeed, float tickValue, float firstRotationX, float secondRotationX, float partialTicks) {
        int minColor = Math.min(cosmeticData.getBrightness(), 0);
        int maxColor = cosmeticData.getBrightness();
        float animation = ((float)minColor + (float)Math.abs(Math.cos(tickValue / 30.0f) * (double)(maxColor - minColor))) / 255.0f;
        int brightness = 2;
        User user = LabyMod.getInstance().getUserManager().getUser(entityIn.aK());
        if (user.getCosmetics().containsKey(36)) {
            CosmeticEyelids.CosmeticEyelidsData data = (CosmeticEyelids.CosmeticEyelidsData)user.getCosmetics().get(36);
            animation = (float)((double)animation * (1.0 - data.lastRenderedPercetage));
        }
        bfl.E();
        bfl.p();
        bfl.b((float)firstRotationX, (float)0.0f, (float)1.0f, (float)0.0f);
        if (entityIn.av()) {
            double sneakRotate = (double)entityIn.z / 70000.0;
            sneakRotate = Math.max(0.0, sneakRotate);
            bfl.b((double)0.0, (double)0.062, (double)0.0);
            bfl.b((double)0.0, (double)sneakRotate, (double)(-sneakRotate));
        }
        bfl.b((float)secondRotationX, (float)1.0f, (float)0.0f, (float)0.0f);
        bfl.a((double)0.0625, (double)0.0625, (double)0.06);
        bfl.b((double)-4.0, (double)-8.0, (double)-4.17);
        ave.A().P().a(ModTextures.COSMETIC_SNOXH_EYE);
        bfl.l();
        bfl.a((int)770, (int)772, (int)1, (int)1);
        bfl.c();
        bfl.j((int)7425);
        bfl.x();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        int x = cosmeticData.getX();
        int y = cosmeticData.getY();
        int width = cosmeticData.getWidth();
        int height = cosmeticData.getHeight();
        ave.A().o.h();
        bfl.f();
        boolean overlappingLeft = x + width - 1 == 3;
        for (int i = 0; i < 2; ++i) {
            for (int b2 = 0; b2 < brightness; ++b2) {
                if (!(i == 0 ? cosmeticData.isRightVisible() : cosmeticData.isLeftVisible())) continue;
                this.renderGlowingBorder(i == 0 ? x : 8 - x - width, y, width, height, cosmeticData.getColor(), animation, overlappingLeft, i == 0);
            }
            bfl.b((double)0.0, (double)0.0, (double)-0.01);
        }
        ave.A().o.i();
        bfl.w();
        bfl.j((int)7424);
        bfl.d();
        bfl.k();
        bfl.e();
        bfl.o();
        bfl.F();
    }

    private void renderGlowingBorder(int x, int y, int width, int height, Color color, float alpha, boolean overlapping, boolean isLeftSide) {
        float r = (float)color.getRed() / 255.0f;
        float g2 = (float)color.getGreen() / 255.0f;
        float b2 = (float)color.getBlue() / 255.0f;
        float middleAlpha = 0.4f;
        float radius = 0.6f;
        float basis = 0.0f;
        float middleLeft = (float)x + basis;
        float middleTop = (float)y + basis;
        float middleRight = (float)(x + width) - basis;
        float middleBottom = (float)(y + height) - basis;
        bfx tessellator = bfx.a();
        WorldRendererAdapter worldrenderer = LabyModCore.getWorldRenderer();
        worldrenderer.begin(7, bms.i);
        this.drawGradient(middleLeft, middleTop - radius, 0.0f, middleRight, middleTop - radius, 0.0f, middleRight, middleTop, alpha, middleLeft, middleTop, alpha, r, g2, b2);
        this.drawGradient(middleRight, middleTop, alpha, middleRight + radius, middleTop, 0.0f, middleRight + radius, middleBottom, 0.0f, middleRight, middleBottom, alpha, r, g2, b2);
        this.drawGradient(middleLeft, middleTop, alpha, middleLeft - radius, middleTop, 0.0f, middleLeft - radius, middleBottom, 0.0f, middleLeft, middleBottom, alpha, r, g2, b2);
        this.drawGradient(middleLeft, middleBottom + radius, 0.0f, middleRight, middleBottom + radius, 0.0f, middleRight, middleBottom, alpha, middleLeft, middleBottom, alpha, r, g2, b2);
        this.drawGradient(middleLeft, middleTop, middleAlpha, middleRight, middleTop, middleAlpha, middleRight, middleBottom, middleAlpha, middleLeft, middleBottom, middleAlpha, r, g2, b2);
        double cornerRadiusWidth = (double)radius * Math.cos(Math.toRadians(45.0));
        double cornerRadiusHeight = (double)radius * Math.sin(Math.toRadians(45.0));
        double lowCornerRadiusWidth = (double)radius * Math.cos(Math.toRadians(22.5));
        double lowCornerRadiusHeight = (double)radius * Math.sin(Math.toRadians(22.5));
        double highCornerRadiusWidth = (double)radius * Math.cos(Math.toRadians(67.5));
        double highCornerRadiusHeight = (double)radius * Math.sin(Math.toRadians(67.5));
        if (!overlapping || (isLeftSide ? overlapping : !overlapping)) {
            this.drawGradient(middleLeft - radius, middleTop, 0.0f, (double)middleLeft - lowCornerRadiusWidth, (double)middleTop - lowCornerRadiusHeight, 0.0f, (double)middleLeft - cornerRadiusWidth, (double)middleTop - cornerRadiusHeight, 0.0f, middleLeft, middleTop, alpha, r, g2, b2);
            this.drawGradient((double)middleLeft - cornerRadiusWidth, (double)middleTop - cornerRadiusHeight, 0.0f, (double)middleLeft - highCornerRadiusWidth, (double)middleTop - highCornerRadiusHeight, 0.0f, middleLeft, middleTop - radius, 0.0f, middleLeft, middleTop, alpha, r, g2, b2);
        }
        if (!overlapping || (isLeftSide ? !overlapping : overlapping)) {
            this.drawGradient(middleRight + radius, middleTop, 0.0f, (double)middleRight + lowCornerRadiusWidth, (double)middleTop - lowCornerRadiusHeight, 0.0f, (double)middleRight + cornerRadiusWidth, (double)middleTop - cornerRadiusHeight, 0.0f, middleRight, middleTop, alpha, r, g2, b2);
            this.drawGradient((double)middleRight + cornerRadiusWidth, (double)middleTop - cornerRadiusHeight, 0.0f, (double)middleRight + highCornerRadiusWidth, (double)middleTop - highCornerRadiusHeight, 0.0f, middleRight, middleTop - radius, 0.0f, middleRight, middleTop, alpha, r, g2, b2);
        }
        if (!overlapping || (isLeftSide ? overlapping : !overlapping)) {
            this.drawGradient(middleLeft - radius, middleBottom, 0.0f, (double)middleLeft - lowCornerRadiusWidth, (double)middleBottom + lowCornerRadiusHeight, 0.0f, (double)middleLeft - cornerRadiusWidth, (double)middleBottom + cornerRadiusHeight, 0.0f, middleLeft, middleBottom, alpha, r, g2, b2);
            this.drawGradient((double)middleLeft - cornerRadiusWidth, (double)middleBottom + cornerRadiusHeight, 0.0f, (double)middleLeft - highCornerRadiusWidth, (double)middleBottom + highCornerRadiusHeight, 0.0f, middleLeft, middleBottom + radius, 0.0f, middleLeft, middleBottom, alpha, r, g2, b2);
        }
        if (!overlapping || (isLeftSide ? !overlapping : overlapping)) {
            this.drawGradient(middleRight + radius, middleBottom, 0.0f, (double)middleRight + lowCornerRadiusWidth, (double)middleBottom + lowCornerRadiusHeight, 0.0f, (double)middleRight + cornerRadiusWidth, (double)middleBottom + cornerRadiusHeight, 0.0f, middleRight, middleBottom, alpha, r, g2, b2);
            this.drawGradient((double)middleRight + cornerRadiusWidth, (double)middleBottom + cornerRadiusHeight, 0.0f, (double)middleRight + highCornerRadiusWidth, (double)middleBottom + highCornerRadiusHeight, 0.0f, middleRight, middleBottom + radius, 0.0f, middleRight, middleBottom, alpha, r, g2, b2);
        }
        tessellator.b();
    }

    private void drawGradient(double x1, double y1, float a1, double x2, double y2, float a2, double x3, double y3, float a3, double x4, double y4, float a4, float r, float g2, float b2) {
        WorldRendererAdapter worldrenderer = LabyModCore.getWorldRenderer();
        worldrenderer.pos(x1, y1, 0.0).tex(1.0, 1.0).color(r, g2, b2, a1).endVertex();
        worldrenderer.pos(x2, y2, 0.0).tex(1.0, 1.0).color(r, g2, b2, a2).endVertex();
        worldrenderer.pos(x3, y3, 0.0).tex(1.0, 1.0).color(r, g2, b2, a3).endVertex();
        worldrenderer.pos(x4, y4, 0.0).tex(1.0, 1.0).color(r, g2, b2, a4).endVertex();
    }

    @Override
    public int getCosmeticId() {
        return 32;
    }

    @Override
    public String getCosmeticName() {
        return "Snoxh Eyes";
    }

    @Override
    public boolean isOfflineAvailable() {
        return false;
    }

    public static class CosmeticSnoxhData
    extends CosmeticData {
        private int x = 1;
        private int y = 4;
        private int width = 2;
        private int height = 1;
        private Color color = Color.WHITE;
        private boolean leftVisible = true;
        private boolean rightVisible = true;
        private int brightness = 120;

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void loadData(String[] data) throws Exception {
            Exception exception = null;
            try {
                this.x = Integer.parseInt(data[0]);
                this.y = Integer.parseInt(data[1]);
                this.width = Integer.parseInt(data[2]);
                this.height = Integer.parseInt(data[3]);
                this.leftVisible = Integer.parseInt(data[4]) == 1;
                this.rightVisible = Integer.parseInt(data[5]) == 1;
                this.color = Color.decode("#" + data[6]);
                this.brightness = Integer.parseInt(data[7]);
            }
            catch (Exception e) {
                exception = e;
            }
            this.x = Math.min(this.x, 7);
            this.y = Math.min(this.y, 7);
            this.width = Math.min(this.width, 4);
            this.height = Math.min(this.height, 4);
            this.x = Math.max(this.x, 0);
            this.y = Math.max(this.y, 0);
            this.width = Math.max(this.width, 1);
            this.height = Math.max(this.height, 1);
            this.brightness = Math.min(this.brightness, 160);
            this.brightness = Math.max(this.brightness, 0);
            if (exception != null) {
                throw exception;
            }
        }

        @Override
        public void init(User user) {
        }

        @Override
        public EnumLegacyCosmeticType getType() {
            return EnumLegacyCosmeticType.FACE;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public Color getColor() {
            return this.color;
        }

        public boolean isLeftVisible() {
            return this.leftVisible;
        }

        public boolean isRightVisible() {
            return this.rightVisible;
        }

        public int getBrightness() {
            return this.brightness;
        }
    }
}

