/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.animation.model;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.labymod.support.util.Debug;
import net.labymod.user.cosmetic.animation.EnumAnimationMetaType;
import net.labymod.user.cosmetic.animation.EnumCondition;
import net.labymod.user.cosmetic.animation.EnumTrigger;
import net.labymod.user.cosmetic.animation.model.BoneAnimation;

public class Animation {
    private final String name;
    private final Map<String, BoneAnimation> boneAnimation = new HashMap<String, BoneAnimation>();
    private final Map<EnumAnimationMetaType, String> meta = new HashMap<EnumAnimationMetaType, String>();
    private final List<EnumTrigger> triggers = new ArrayList<EnumTrigger>();
    private Integer probability = null;
    private final List<EnumCondition> conditions = new ArrayList<EnumCondition>();

    public Animation(String name) {
        this.name = name;
    }

    public void parseMeta(JsonObject object) {
        for (EnumAnimationMetaType type : EnumAnimationMetaType.values()) {
            if (!object.has(type.getKey())) continue;
            this.meta.put(type, object.get(type.getKey()).getAsString());
        }
    }

    public void parseMeta(String command) {
        if (command.isEmpty()) {
            return;
        }
        String[] args = command.split(" ");
        EnumAnimationMetaType lastMetaType = null;
        for (String argument : args) {
            if (lastMetaType != null) {
                this.meta.put(lastMetaType, argument);
                lastMetaType = null;
                continue;
            }
            lastMetaType = EnumAnimationMetaType.get(argument.replace("-", ""));
            if (lastMetaType != null) continue;
            Debug.log(Debug.EnumDebugMode.REMOTE_COSMETIC, "Invalid animation meta: " + command);
            return;
        }
        this.parseMetaTrigger();
        this.parseMetaProbability();
        this.parseMetaConditions();
    }

    private void parseMetaTrigger() {
        String value = this.getMetaValue(EnumAnimationMetaType.TRIGGER);
        if (value != null) {
            if (value.contains(",")) {
                for (String triggerEntry : value.split(",")) {
                    EnumTrigger trigger = EnumTrigger.getById(triggerEntry.toUpperCase());
                    if (trigger == null) continue;
                    this.triggers.add(trigger);
                }
            } else if (value.equals("*")) {
                Collections.addAll(this.triggers, EnumTrigger.values());
            } else {
                EnumTrigger trigger = EnumTrigger.getById(value.toUpperCase());
                if (trigger != null) {
                    this.triggers.add(trigger);
                }
            }
        }
    }

    private void parseMetaProbability() {
        String probability = this.getMetaValue(EnumAnimationMetaType.PROBABILITY);
        if (probability != null) {
            try {
                this.probability = Integer.parseInt(probability);
            }
            catch (Exception e) {
                Debug.log(Debug.EnumDebugMode.REMOTE_COSMETIC, "Invalid probability of " + this.name + ": " + probability);
            }
        }
    }

    private void parseMetaConditions() {
        String conditions = this.getMetaValue(EnumAnimationMetaType.CONDITION);
        if (conditions != null) {
            try {
                for (String condition : conditions.split(",")) {
                    this.conditions.add(EnumCondition.valueOf(condition.toUpperCase(Locale.ROOT)));
                }
            }
            catch (Exception e) {
                Debug.log(Debug.EnumDebugMode.REMOTE_COSMETIC, "Invalid conditions of " + this.name + ": " + conditions);
            }
        }
    }

    public BoneAnimation getBoneAnimation(String boneName) {
        BoneAnimation boneAnimation = this.boneAnimation.get(boneName);
        if (boneAnimation == null) {
            boneAnimation = new BoneAnimation();
            this.boneAnimation.put(boneName, boneAnimation);
        }
        return boneAnimation;
    }

    public long getLength() {
        long maxLength = 0L;
        for (BoneAnimation boneAnimation : this.boneAnimation.values()) {
            maxLength = Math.max(boneAnimation.getLength(), maxLength);
        }
        return maxLength;
    }

    public String getMetaValue(EnumAnimationMetaType type) {
        return this.meta.get((Object)type);
    }

    public List<EnumCondition> getConditions() {
        return this.conditions;
    }

    public boolean hasTrigger(EnumTrigger trigger) {
        return this.triggers.contains((Object)trigger);
    }

    public Integer getProbability() {
        return this.probability;
    }

    public Map<String, BoneAnimation> getBoneAnimations() {
        return this.boneAnimation;
    }

    public String getName() {
        return this.name;
    }

    public boolean meetsConditions(pk entity) {
        if (this.conditions.isEmpty()) {
            return true;
        }
        double motionX = entity.p - entity.s;
        double motionZ = entity.r - entity.u;
        double yawSin = Math.sin(Math.toRadians(entity.y));
        double yawCos = -Math.cos(Math.toRadians(entity.y));
        double forward = motionX * yawSin + motionZ * yawCos;
        for (EnumCondition condition : this.conditions) {
            switch (condition) {
                case MOTION_BACKWARDS: {
                    if (forward >= 0.0) {
                        return false;
                    }
                }
                case NO_MOTION: {
                    if (forward != 0.0) {
                        return false;
                    }
                }
                case MOTION_FORWARD: {
                    if (!(forward <= 0.0)) break;
                    return false;
                }
                case SNEAKING: {
                    if (entity.av()) break;
                    return false;
                }
                case NOT_SNEAKING: {
                    if (!entity.av()) break;
                    return false;
                }
                case IN_WATER: {
                    if (entity.V()) break;
                    return false;
                }
                case NOT_IN_WATER: {
                    if (!entity.V()) break;
                    return false;
                }
                case ON_GROUND: {
                    if (entity.C) break;
                    return false;
                }
                case IN_AIR: {
                    if (!entity.C) break;
                    return false;
                }
            }
        }
        return true;
    }
}

