/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.labymod.core.LabyModCore;
import net.labymod.main.LabyMod;
import net.labymod.user.UserManager;
import net.labymod.user.cosmetic.custom.UserTextureContainer;
import net.labymod.user.cosmetic.custom.handler.CloakImageHandler;
import net.labymod.user.cosmetic.util.CosmeticData;
import net.labymod.user.group.GroupManager;
import net.labymod.user.group.LabyGroup;

public class User {
    private UUID uuid;
    private Map<Integer, CosmeticData> cosmetics = new ConcurrentHashMap<Integer, CosmeticData>();
    private Map<Integer, List<String>> possibleRemoteIds = new ConcurrentHashMap<Integer, List<String>>();
    private List<Short> emotes = new ArrayList<Short>();
    private List<Short> stickerPacks = new ArrayList<Short>();
    protected short playingSticker = (short)-1;
    protected long stickerStartedPlaying;
    private LabyGroup group = GroupManager.DEFAULT_GROUP;
    private boolean dailyEmoteFlat;
    private String subTitle;
    private double subTitleSize;
    private boolean mojangCapeModified = false;
    private boolean mojangCapeVisible = true;
    private long nextPriorityCheck = -1L;
    private final UserTextureContainer cloakContainer;
    private final UserTextureContainer bandanaContainer;
    private final UserTextureContainer shoesContainer;
    private final UserTextureContainer kawaiiMaskContainer;
    private final UserTextureContainer coverMaskContainer;
    private final UserTextureContainer watchContainer;
    private final UserTextureContainer angelWingsContainer;
    private final UserTextureContainer capContainer;
    private final UserTextureContainer petDragonContainer;
    private final UserTextureContainer bunnyShoesContainer;
    private final UserTextureContainer scarfContainer;
    private final Map<Integer, UserTextureContainer> remoteContainer = new HashMap<Integer, UserTextureContainer>();
    private float maxNameTagHeight;
    private UserManager userManager;
    private boolean familiar;
    public long lastRendered;
    private boolean canSeeDraftCosmetics;
    private boolean hideCape = false;

    public User(UUID uuid) {
        this.uuid = uuid;
        this.cloakContainer = new UserTextureContainer("../capes", this.uuid);
        this.bandanaContainer = new UserTextureContainer("bandanas", this.uuid);
        this.shoesContainer = new UserTextureContainer("shoes");
        this.kawaiiMaskContainer = new UserTextureContainer("kawaiimasks");
        this.coverMaskContainer = new UserTextureContainer("covermasks");
        this.watchContainer = new UserTextureContainer("watches");
        this.angelWingsContainer = new UserTextureContainer("angelwings");
        this.capContainer = new UserTextureContainer("caps");
        this.petDragonContainer = new UserTextureContainer("petdragons");
        this.bunnyShoesContainer = new UserTextureContainer("bunnyshoes");
        this.scarfContainer = new UserTextureContainer("scarf");
        this.userManager = LabyMod.getInstance().getUserManager();
    }

    public LabyGroup getGroup() {
        return this.group;
    }

    public boolean hasCosmeticById(int id) {
        return this.cosmetics.containsKey(id);
    }

    public void resetMaxNameTagHeight() {
        this.maxNameTagHeight = 0.0f;
    }

    public void applyNameTagHeight(float nameTagHeight) {
        if (nameTagHeight > this.maxNameTagHeight) {
            this.maxNameTagHeight = nameTagHeight;
        }
    }

    public void unloadCosmeticTextures() {
        this.cloakContainer.unload();
        this.bandanaContainer.unload();
        this.shoesContainer.unload();
        this.kawaiiMaskContainer.unload();
        this.coverMaskContainer.unload();
        this.watchContainer.unload();
        this.angelWingsContainer.unload();
        this.capContainer.unload();
        this.petDragonContainer.unload();
        this.bunnyShoesContainer.unload();
        this.scarfContainer.unload();
        for (UserTextureContainer container : this.remoteContainer.values()) {
            container.unload();
        }
        this.hideCape = false;
    }

    public boolean canRenderMojangCape(bet player) {
        boolean canRenderMojangCape;
        if (this.nextPriorityCheck > System.currentTimeMillis()) {
            return this.mojangCapeVisible;
        }
        this.nextPriorityCheck = System.currentTimeMillis() + 500L;
        UserManager userManager = LabyMod.getInstance().getUserManager();
        bcy netHandlerPlayClient = LabyModCore.getMinecraft().getConnection();
        bdc networkPlayerInfo = netHandlerPlayClient != null ? netHandlerPlayClient.a(this.getUuid()) : null;
        jy locationOptifine = player.k();
        jy locationMinecon = networkPlayerInfo == null ? null : networkPlayerInfo.h();
        this.setMojangCapeModified(locationMinecon == null || !locationMinecon.equals((Object)locationOptifine));
        boolean enabled = LabyMod.getSettings().cosmetics && LabyMod.getSettings().cosmeticsCustomTextures;
        boolean bl = canRenderMojangCape = !this.hideCape || !enabled;
        if (userManager.getCapePriority() != CloakImageHandler.EnumCapePriority.LABYMOD && (locationMinecon != null || locationOptifine != null)) {
            canRenderMojangCape = true;
        }
        this.mojangCapeVisible = canRenderMojangCape;
        return this.mojangCapeVisible;
    }

    public boolean isFamiliar() {
        return this.familiar;
    }

    public boolean isStickerVisible() {
        if (this.playingSticker == -1) {
            return false;
        }
        long timePassed = System.currentTimeMillis() - this.stickerStartedPlaying;
        return timePassed < 4000L;
    }

    public void setGroup(LabyGroup group) {
        this.group = group == null ? GroupManager.DEFAULT_GROUP : group;
        this.canSeeDraftCosmetics = this.userManager.canSeeDraftCosmetics(this);
    }

    public void setFamiliar(boolean familiar) {
        this.familiar = familiar;
    }

    public boolean isRendered() {
        return System.currentTimeMillis() - this.lastRendered < 1000L;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Map<Integer, CosmeticData> getCosmetics() {
        return this.cosmetics;
    }

    public Map<Integer, List<String>> getPossibleRemoteIds() {
        return this.possibleRemoteIds;
    }

    public List<Short> getEmotes() {
        return this.emotes;
    }

    public List<Short> getStickerPacks() {
        return this.stickerPacks;
    }

    public short getPlayingSticker() {
        return this.playingSticker;
    }

    public long getStickerStartedPlaying() {
        return this.stickerStartedPlaying;
    }

    public boolean isDailyEmoteFlat() {
        return this.dailyEmoteFlat;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public double getSubTitleSize() {
        return this.subTitleSize;
    }

    public boolean isMojangCapeModified() {
        return this.mojangCapeModified;
    }

    public boolean isMojangCapeVisible() {
        return this.mojangCapeVisible;
    }

    public long getNextPriorityCheck() {
        return this.nextPriorityCheck;
    }

    public UserTextureContainer getCloakContainer() {
        return this.cloakContainer;
    }

    public UserTextureContainer getBandanaContainer() {
        return this.bandanaContainer;
    }

    public UserTextureContainer getShoesContainer() {
        return this.shoesContainer;
    }

    public UserTextureContainer getKawaiiMaskContainer() {
        return this.kawaiiMaskContainer;
    }

    public UserTextureContainer getCoverMaskContainer() {
        return this.coverMaskContainer;
    }

    public UserTextureContainer getWatchContainer() {
        return this.watchContainer;
    }

    public UserTextureContainer getAngelWingsContainer() {
        return this.angelWingsContainer;
    }

    public UserTextureContainer getCapContainer() {
        return this.capContainer;
    }

    public UserTextureContainer getPetDragonContainer() {
        return this.petDragonContainer;
    }

    public UserTextureContainer getBunnyShoesContainer() {
        return this.bunnyShoesContainer;
    }

    public UserTextureContainer getScarfContainer() {
        return this.scarfContainer;
    }

    public Map<Integer, UserTextureContainer> getRemoteContainer() {
        return this.remoteContainer;
    }

    public float getMaxNameTagHeight() {
        return this.maxNameTagHeight;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public long getLastRendered() {
        return this.lastRendered;
    }

    public boolean isCanSeeDraftCosmetics() {
        return this.canSeeDraftCosmetics;
    }

    public void setCosmetics(Map<Integer, CosmeticData> cosmetics) {
        this.cosmetics = cosmetics;
    }

    public void setPossibleRemoteIds(Map<Integer, List<String>> possibleRemoteIds) {
        this.possibleRemoteIds = possibleRemoteIds;
    }

    public void setEmotes(List<Short> emotes) {
        this.emotes = emotes;
    }

    public void setStickerPacks(List<Short> stickerPacks) {
        this.stickerPacks = stickerPacks;
    }

    public void setPlayingSticker(short playingSticker) {
        this.playingSticker = playingSticker;
    }

    public void setStickerStartedPlaying(long stickerStartedPlaying) {
        this.stickerStartedPlaying = stickerStartedPlaying;
    }

    public void setDailyEmoteFlat(boolean dailyEmoteFlat) {
        this.dailyEmoteFlat = dailyEmoteFlat;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public void setSubTitleSize(double subTitleSize) {
        this.subTitleSize = subTitleSize;
    }

    public void setMojangCapeModified(boolean mojangCapeModified) {
        this.mojangCapeModified = mojangCapeModified;
    }

    public boolean isHideCape() {
        return this.hideCape;
    }

    public void setHideCape(boolean hideCape) {
        this.hideCape = hideCape;
    }
}

