/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.support.listener;

import com.google.gson.JsonObject;
import java.beans.ConstructorProperties;
import net.labymod.api.events.MessageSendEvent;
import net.labymod.labyconnect.ClientConnection;
import net.labymod.labyconnect.packets.PacketAddonMessage;
import net.labymod.main.LabyMod;
import net.labymod.utils.ModColor;

public class LabyConnectCommands
implements MessageSendEvent {
    private ClientConnection connection;

    @Override
    public boolean onSend(String message) {
        String lowercaseMessage = message.toLowerCase();
        try {
            if (lowercaseMessage.startsWith("/labymodchatdebug")) {
                if (!lowercaseMessage.contains(" ")) {
                    LabyMod.getInstance().getLabyModAPI().displayMessageInChat(ModColor.cl("c") + "/labymodchatdebug ip:port");
                    return true;
                }
                String ip2 = lowercaseMessage.split(" ")[1];
                int port = 25565;
                if (ip2.contains(":")) {
                    String[] split = ip2.split(":");
                    ip2 = split[0];
                    port = Integer.parseInt(split[1]);
                }
                LabyMod.getInstance().getLabyModAPI().displayMessageInChat(ModColor.cl("a") + "Connecting to " + ModColor.cl("f") + ip2 + ModColor.cl("a") + " on port " + ModColor.cl("f") + port);
                this.connection.customIp = ip2;
                this.connection.customPort = port;
                this.connection.connect();
                return true;
            }
            char[] actions = new char[]{'k', 'o', 'b', 'u'};
            for (int action = 0; action < actions.length; ++action) {
                char character = actions[action];
                if (!lowercaseMessage.startsWith("/lm" + character)) continue;
                String[] words = message.split(" ");
                JsonObject object = new JsonObject();
                if (action % 2 != 0) {
                    if (words.length < 2) {
                        LabyMod.getInstance().getLabyModAPI().displayMessageInChat(ModColor.cl("c") + "/lm" + character + " <target>");
                        return true;
                    }
                } else {
                    if (words.length < 3) {
                        LabyMod.getInstance().getLabyModAPI().displayMessageInChat(ModColor.cl("c") + "/lm" + character + " <target> <string>");
                        return true;
                    }
                    String string = "";
                    for (int i = 2; i < words.length; ++i) {
                        if (!string.isEmpty()) {
                            string = string + " ";
                        }
                        string = string + words[i];
                    }
                    object.addProperty("string", string);
                }
                object.addProperty("target", words[1]);
                object.addProperty("action", (Number)action);
                this.connection.sendPacket(new PacketAddonMessage("LMAC", object.toString()));
                return true;
            }
        }
        catch (Exception error) {
            LabyMod.getInstance().getLabyModAPI().displayMessageInChat(ModColor.cl("c") + "Error: " + error.getMessage());
        }
        return false;
    }

    @ConstructorProperties(value={"connection"})
    public LabyConnectCommands(ClientConnection connection) {
        this.connection = connection;
    }
}

