/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.support.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import net.labymod.addon.AddonLoader;
import net.labymod.api.LabyModAddon;
import net.labymod.core.asm.LabyModCoreMod;
import net.labymod.main.LabyMod;
import net.labymod.main.Source;
import net.labymod.support.util.Debug;
import net.labymod.support.util.Hastebin;
import net.labymod.user.User;
import net.labymod.user.UserManager;
import net.labymod.user.cosmetic.remote.RemoteCosmeticLoader;
import net.labymod.user.cosmetic.util.CosmeticData;
import net.labymod.utils.Consumer;
import net.labymod.utils.ModUtils;

public class GuiDebugConsole
extends JFrame {
    private JTextPane textPane = new JTextPane();
    private long idle = 0L;

    public GuiDebugConsole(final Consumer<Boolean> consumer) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.setSize(900, 520);
        this.setLocationRelativeTo(null);
        this.setTitle("LabyMod Debug Console");
        try {
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(GuiDebugConsole.class.getResource("/assets/minecraft/labymod/textures/labymod_logo.png")));
        }
        catch (Exception error) {
            error.printStackTrace();
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                consumer.accept(true);
                e.getWindow().dispose();
            }
        });
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel controlPanel = new JPanel();
        this.getContentPane().add(controlPanel);
        controlPanel.setLayout(new FlowLayout(2, 5, 5));
        controlPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        JButton uploadButton = new JButton("Upload");
        uploadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String log = GuiDebugConsole.this.createLog();
                Hastebin.upload(log);
            }
        });
        controlPanel.add(uploadButton);
        JPanel guiPanel = new JPanel();
        controlPanel.add(guiPanel);
        guiPanel.setLayout(new BorderLayout(0, 0));
        JButton restartDebugButton = new JButton("Restart in debug");
        restartDebugButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Debug.DEBUG_FILE.createNewFile();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                ave.A().m();
            }
        });
        guiPanel.add(restartDebugButton);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(0, 0));
        this.textPane.setFont(new Font("Courier New", 0, 15));
        this.textPane.setEditable(false);
        this.textPane.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                if (evt.getDot() == evt.getMark()) {
                    return;
                }
                JTextPane txtPane = (JTextPane)evt.getSource();
                DefaultHighlighter highlighter = (DefaultHighlighter)txtPane.getHighlighter();
                highlighter.removeAllHighlights();
                DefaultHighlighter.DefaultHighlightPainter hPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(0xFFAA00));
                String selText = txtPane.getSelectedText();
                if (selText.isEmpty() || selText.equals("\n")) {
                    return;
                }
                String contText = "";
                DefaultStyledDocument document = (DefaultStyledDocument)txtPane.getDocument();
                try {
                    contText = document.getText(0, document.getLength());
                    if (contText.isEmpty() || contText.equals("\n")) {
                        return;
                    }
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
                int index = 0;
                while ((index = contText.indexOf(selText, index)) > -1) {
                    try {
                        highlighter.addHighlight(index, selText.length() + index, hPainter);
                        index += selText.length();
                    }
                    catch (BadLocationException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.textPane);
        panel.add(scrollPane);
        this.getContentPane().add(panel);
        this.setVisible(true);
        final JScrollBar scrollBar = scrollPane.getVerticalScrollBar();
        scrollBar.setUnitIncrement(16);
        new Thread(new Runnable(){

            @Override
            public void run() {
                Debug.log(Debug.EnumDebugMode.GENERAL, "Debug console started");
                try {
                    BufferedReader br = new BufferedReader(new FileReader(new File("logs/latest.log")));
                    while (GuiDebugConsole.this.isVisible()) {
                        boolean isAtBottom;
                        boolean bl = isAtBottom = scrollBar.getValue() + 10 >= scrollBar.getMaximum() - scrollBar.getVisibleAmount();
                        if (!scrollBar.isVisible() || isAtBottom) {
                            GuiDebugConsole.this.readLogFile(br);
                        }
                        if (GuiDebugConsole.this.idle >= System.currentTimeMillis()) continue;
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Debug.log(Debug.EnumDebugMode.GENERAL, "Debug console closed");
            }
        }).start();
    }

    private String createLog() {
        String log = this.textPane.getText();
        long maxMemory = Runtime.getRuntime().maxMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        long percent = usedMemory * 100L / maxMemory;
        String addons = "";
        for (LabyModAddon addon : AddonLoader.getAddons()) {
            if (addon == null || addon.about == null) continue;
            addons = addons + addon.about.name + ", ";
        }
        UserManager userManager = LabyMod.getInstance().getUserManager();
        User user = userManager.getUser(LabyMod.getInstance().getPlayerUUID());
        RemoteCosmeticLoader remote = userManager.getRemoteCosmeticLoader();
        log = log + "\n---------------------------------------";
        log = log + "\nTime: " + new Date().toString();
        log = log + "\nUsername: " + LabyMod.getInstance().getPlayerName();
        log = log + "\nUUID: " + user.getUuid().toString();
        log = log + "\nGroup: " + (user.getGroup() == null ? "NONE" : user.getGroup().getName());
        log = log + "\nWhitelist: " + userManager.isWhitelisted(user.getUuid());
        log = log + "\nRemote Cosmetics: " + (remote.getIndex() == null ? "null" : Integer.valueOf(remote.getIndex().cosmetics.size()));
        log = log + "\nCosmetics: " + user.getCosmetics().size();
        for (CosmeticData cos : user.getCosmetics().values()) {
            log = log + "\n- " + cos.getClass().getSimpleName();
        }
        log = log + "\nMemory: " + (int)percent + "% (" + ModUtils.humanReadableByteCount(maxMemory, true, true) + ")";
        log = log + "\nAddons: [" + AddonLoader.getAddons().size() + "] " + addons;
        log = log + "\nForge: " + LabyModCoreMod.isForge();
        log = log + "\nVersion: " + Source.getUserAgent();
        log = log + "\n---------------------------------------";
        return log;
    }

    private void readLogFile(BufferedReader br) {
        try {
            String line;
            boolean changed = false;
            while ((line = br.readLine()) != null) {
                if (line.contains("Session ID is token")) continue;
                this.addString(line + "\n");
                changed = true;
            }
            if (changed) {
                this.textPane.repaint();
                this.idle = System.currentTimeMillis() + 5000L;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addString(String string) {
        try {
            Document doc = this.textPane.getDocument();
            StringReader sr = new StringReader(string);
            EditorKit ek2 = this.textPane.getEditorKit();
            ek2.read(sr, doc, this.textPane.getDocument().getLength());
            this.textPane.setCaretPosition(doc.getLength());
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }
}

