/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.settings.elements;

import java.lang.reflect.Field;
import net.labymod.core.LabyModCore;
import net.labymod.ingamegui.Module;
import net.labymod.main.LabyMod;
import net.labymod.main.ModSettings;
import net.labymod.settings.elements.ControlElement;
import net.labymod.utils.Consumer;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;
import org.apache.commons.lang3.StringUtils;

public class NumberElement
extends ControlElement {
    private static final jy SERVER_SELECTION_BUTTONS = new jy("textures/gui/server_selection.png");
    private Integer currentValue;
    private Consumer<Integer> changeListener;
    private avw textField;
    private Consumer<Integer> callback;
    private int minValue = 0;
    private int maxValue = Integer.MAX_VALUE;
    private boolean hoverUp;
    private boolean hoverDown;
    private int steps = 1;
    private long fastTickerCounterValue = 0L;

    public NumberElement(String displayName, final String configEntryName, ControlElement.IconData iconData) {
        super(displayName, configEntryName, iconData);
        if (!configEntryName.isEmpty()) {
            try {
                this.currentValue = (Integer)ModSettings.class.getDeclaredField(configEntryName).get(LabyMod.getSettings());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (this.currentValue == null) {
            this.currentValue = this.minValue;
        }
        this.changeListener = new Consumer<Integer>(){

            @Override
            public void accept(Integer accepted) {
                try {
                    Field f = ModSettings.class.getDeclaredField(configEntryName);
                    if (f.getType().equals(Integer.TYPE)) {
                        f.set(LabyMod.getSettings(), accepted);
                    } else {
                        f.set(LabyMod.getSettings(), String.valueOf(accepted));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (NumberElement.this.callback != null) {
                    NumberElement.this.callback.accept(accepted);
                }
            }
        };
        this.createTextfield();
    }

    public NumberElement(String displayName, ControlElement.IconData iconData, int currentValue) {
        super(displayName, null, iconData);
        this.currentValue = currentValue;
        this.changeListener = new Consumer<Integer>(){

            @Override
            public void accept(Integer accepted) {
                if (NumberElement.this.callback != null) {
                    NumberElement.this.callback.accept(accepted);
                }
            }
        };
        this.createTextfield();
    }

    public NumberElement(final Module module, ControlElement.IconData iconData, String displayName, final String attribute) {
        super(module, iconData, displayName);
        try {
            String attr = module.getAttributes().get(attribute);
            this.currentValue = attr == null ? this.minValue : Integer.valueOf(attr);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
        if (this.currentValue == null) {
            this.currentValue = this.minValue;
        }
        this.changeListener = new Consumer<Integer>(){

            @Override
            public void accept(Integer accepted) {
                module.getAttributes().put(attribute, String.valueOf(accepted));
                module.loadSettings();
                if (NumberElement.this.callback != null) {
                    NumberElement.this.callback.accept(accepted);
                }
            }
        };
        this.createTextfield();
    }

    public NumberElement(String configEntryName, ControlElement.IconData iconData) {
        this(configEntryName, configEntryName, iconData);
    }

    public NumberElement setMinValue(int minValue) {
        this.minValue = minValue;
        if (this.currentValue < this.minValue) {
            this.currentValue = this.minValue;
        }
        return this;
    }

    public NumberElement setMaxValue(int maxValue) {
        this.maxValue = maxValue;
        if (this.currentValue > this.maxValue) {
            this.currentValue = this.maxValue;
        }
        return this;
    }

    public NumberElement setRange(int min, int max) {
        this.setMinValue(min);
        this.setMaxValue(max);
        return this;
    }

    public NumberElement setSteps(int steps) {
        this.steps = steps;
        return this;
    }

    public void createTextfield() {
        this.textField = new avw(-2, LabyModCore.getMinecraft().getFontRenderer(), 0, 0, this.getObjectWidth(), 20);
        this.updateValue();
        this.textField.b(false);
    }

    private void updateValue() {
        this.textField.a(String.valueOf(this.currentValue));
    }

    @Override
    public void draw(int x, int y, int maxX, int maxY, int mouseX, int mouseY) {
        super.draw(x, y, maxX, maxY, mouseX, mouseY);
        int width = this.getObjectWidth();
        if (this.textField == null) {
            return;
        }
        LabyModCore.getMinecraft().setTextFieldXPosition(this.textField, maxX - width - 2);
        LabyModCore.getMinecraft().setTextFieldYPosition(this.textField, y + 1);
        this.textField.g();
        LabyMod.getInstance().getDrawUtils().drawRectangle(x - 1, y, x, maxY, ModColor.toRGB(120, 120, 120, 120));
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        ave.A().P().a(SERVER_SELECTION_BUTTONS);
        bfl.c((float)1.0f, (float)1.0f, (float)1.0f);
        this.hoverUp = mouseX > maxX - 15 && mouseX < maxX - 15 + 11 && mouseY > y + 2 && mouseY < y + 2 + 7;
        this.hoverDown = mouseX > maxX - 15 && mouseX < maxX - 15 + 11 && mouseY > y + 12 && mouseY < y + 12 + 7;
        draw.drawTexture(maxX - 15, y + 2, 99.0, this.hoverUp ? 37.0 : 5.0, 11.0, 7.0, 11.0, 7.0);
        draw.drawTexture(maxX - 15, y + 12, 67.0, this.hoverDown ? 52.0 : 20.0, 11.0, 7.0, 11.0, 7.0);
        if (this.isMouseOver() && this.fastTickerCounterValue != 0L) {
            NumberElement numberElement;
            if (this.fastTickerCounterValue > 0L && this.fastTickerCounterValue + 80L < System.currentTimeMillis()) {
                this.fastTickerCounterValue = System.currentTimeMillis();
                if (this.currentValue < this.maxValue) {
                    numberElement = this;
                    numberElement.currentValue = numberElement.currentValue + this.steps;
                    this.updateValue();
                }
            }
            if (this.fastTickerCounterValue < 0L && this.fastTickerCounterValue - 80L > System.currentTimeMillis() * -1L) {
                this.fastTickerCounterValue = System.currentTimeMillis() * -1L;
                if (this.currentValue > this.minValue) {
                    numberElement = this;
                    numberElement.currentValue = numberElement.currentValue - this.steps;
                    this.updateValue();
                }
            }
        } else {
            this.mouseRelease(mouseX, mouseY, 0);
        }
    }

    @Override
    public void unfocus(int mouseX, int mouseY, int mouseButton) {
        super.unfocus(mouseX, mouseY, mouseButton);
        this.textField.b(false);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        NumberElement numberElement;
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.hoverUp && this.currentValue < this.maxValue) {
            numberElement = this;
            numberElement.currentValue = numberElement.currentValue + this.steps;
            this.updateValue();
            this.fastTickerCounterValue = System.currentTimeMillis() + 500L;
        }
        if (this.hoverDown && this.currentValue > this.minValue) {
            numberElement = this;
            numberElement.currentValue = numberElement.currentValue - this.steps;
            this.updateValue();
            this.fastTickerCounterValue = System.currentTimeMillis() * -1L - 500L;
        }
        if (this.currentValue > this.maxValue) {
            this.currentValue = this.maxValue;
            this.updateValue();
        }
        if (this.currentValue < this.minValue) {
            this.currentValue = this.minValue;
            this.updateValue();
        }
        this.textField.a(mouseX, mouseY, 0);
    }

    @Override
    public void mouseRelease(int mouseX, int mouseY, int mouseButton) {
        super.mouseRelease(mouseX, mouseY, mouseButton);
        if (this.fastTickerCounterValue != 0L) {
            this.fastTickerCounterValue = 0L;
            this.changeListener.accept(this.currentValue);
        }
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
        int preNumber;
        int n = preNumber = this.textField.b().isEmpty() ? this.minValue : Integer.valueOf(this.textField.b());
        if (this.textField.a(typedChar, keyCode)) {
            String currentText = this.textField.b();
            String numericCheck = currentText;
            if (numericCheck.startsWith("-")) {
                numericCheck = numericCheck.replaceFirst("-", "");
            }
            boolean numeric = currentText.isEmpty() || StringUtils.isNumeric((CharSequence)numericCheck);
            int newNumber = 0;
            try {
                int n2 = currentText.isEmpty() || !numeric ? this.minValue : (newNumber = Integer.valueOf(currentText.isEmpty() ? String.valueOf(this.minValue) : currentText).intValue());
                if (!numeric) {
                    newNumber = preNumber;
                }
                if (newNumber > this.maxValue) {
                    newNumber = this.maxValue;
                }
                if (newNumber < this.minValue) {
                    newNumber = this.minValue;
                }
            }
            catch (NumberFormatException e) {
                newNumber = this.maxValue;
            }
            String newText = String.valueOf(newNumber);
            if (!currentText.equals(newText)) {
                this.textField.a(String.valueOf(newNumber));
            }
            this.changeListener.accept(newNumber);
            this.currentValue = newNumber;
        }
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        this.textField.a();
    }

    public avw getTextField() {
        return this.textField;
    }

    public NumberElement addCallback(Consumer<Integer> callback) {
        this.callback = callback;
        return this;
    }

    @Override
    public int getObjectWidth() {
        return 50;
    }

    public Integer getCurrentValue() {
        return this.currentValue;
    }
}

