/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.settings.elements;

import java.util.List;
import net.labymod.core.LabyModCore;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.settings.SettingsCategory;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.utils.DrawUtils;

public class CategorySettingsElement
extends SettingsElement {
    private SettingsCategory category;
    private ClickedCallback callback;

    public CategorySettingsElement(SettingsCategory category, ClickedCallback callback) {
        super(category.getTitle(), null);
        this.category = category;
        this.callback = callback;
    }

    @Override
    public void init() {
    }

    @Override
    public void draw(int x, int y, int maxX, int maxY, int mouseX, int mouseY) {
        super.draw(x, y, maxX, maxY, mouseX, mouseY);
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        double textureSize = 292.0;
        double textureScale = 36.0;
        int elementWidth = maxX - x;
        int elementHeight = maxY - y;
        ave.A().P().a(this.isMouseOver() ? ModTextures.BUTTON_LARGE_PRESSED : ModTextures.BUTTON_LARGE);
        draw.drawTexture(x, y, textureSize / 200.0 * (double)elementWidth / 2.0, textureSize / 200.0 * (double)elementHeight / 2.0, elementWidth / 2, elementHeight / 2);
        draw.drawTexture(x, y + elementHeight / 2, 0.0, -textureScale + textureSize - textureSize / 200.0 * (double)elementHeight / 2.0, textureSize / 200.0 * (double)elementWidth / 2.0, textureSize / 200.0 * (double)elementHeight / 2.0, elementWidth / 2, elementHeight / 2);
        draw.drawTexture(x + elementWidth / 2, y, -textureScale + textureSize - textureSize / 200.0 * (double)elementWidth / 2.0, 0.0, textureSize / 200.0 * (double)elementWidth / 2.0, textureSize / 200.0 * (double)elementHeight / 2.0, elementWidth / 2, elementHeight / 2);
        draw.drawTexture(x + elementWidth / 2, y + elementHeight / 2, -textureScale + textureSize - textureSize / 200.0 * (double)elementWidth / 2.0, -textureScale + textureSize - textureSize / 200.0 * (double)elementHeight / 2.0, textureSize / 200.0 * (double)elementWidth / 2.0, textureSize / 200.0 * (double)elementHeight / 2.0, elementWidth / 2, elementHeight / 2);
        if (this.category.getResourceLocation() != null) {
            bfl.d();
            ave.A().P().a(this.category.getResourceLocation());
            draw.drawTexture(x + 2, y + 1, 256.0, 256.0, maxY - y - 4, maxY - y - 4);
        }
        List<String> list = draw.listFormattedStringToWidth(this.category.getTitle(), maxX - x - 64 + 25, 2);
        int posY = list.size() * -5 + 5;
        for (String line : list) {
            draw.c(LabyModCore.getMinecraft().getFontRenderer(), line, x + maxY - y + 2, y + 7 + posY, this.isMouseOver() ? 0xFFFFA0 : 0xE0E0E0);
            posY += 10;
        }
    }

    @Override
    public int getEntryHeight() {
        return 22;
    }

    @Override
    public void drawDescription(int x, int y, int screenWidth) {
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.isMouseOver()) {
            this.callback.clicked(this.category);
        }
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
    }

    @Override
    public void mouseRelease(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public void unfocus(int mouseX, int mouseY, int mouseButton) {
    }

    public static interface ClickedCallback {
        public void clicked(SettingsCategory var1);
    }
}

